VERSION 4.00
Begin VB.Form fmDirlist 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Directory List"
   ClientHeight    =   5190
   ClientLeft      =   1215
   ClientTop       =   1875
   ClientWidth     =   8325
   FillColor       =   &H00FFFFFF&
   BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
      Name            =   "Courier New"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H00000000&
   Height          =   5880
   Icon            =   "dirlist.frx":0000
   Left            =   1155
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5190
   ScaleWidth      =   8325
   Top             =   1245
   Width           =   8445
   Begin VB.ListBox lstDirCont 
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4050
      ItemData        =   "dirlist.frx":0442
      Left            =   0
      List            =   "dirlist.frx":0444
      TabIndex        =   11
      Top             =   1080
      Width           =   8295
   End
   Begin VB.CommandButton cmdBrowse 
      Caption         =   "Browse"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   855
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   2040
      TabIndex        =   2
      Top             =   120
      Width           =   855
   End
   Begin VB.CheckBox chkAttrs 
      Caption         =   "Attributes"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6960
      TabIndex        =   9
      Top             =   600
      Width           =   1095
   End
   Begin VB.CheckBox chkSize 
      Caption         =   "Size"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6000
      TabIndex        =   8
      Top             =   600
      Width           =   855
   End
   Begin VB.CheckBox chkTime 
      Caption         =   "Time"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6960
      TabIndex        =   7
      Top             =   240
      Width           =   855
   End
   Begin VB.CheckBox chkDate 
      Caption         =   "Date"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   6000
      TabIndex        =   6
      Top             =   240
      Width           =   735
   End
   Begin VB.TextBox txtPath 
      Enabled         =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   960
      TabIndex        =   4
      Top             =   600
      Width           =   4695
   End
   Begin VB.CommandButton cmdList 
      Caption         =   "List"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1080
      TabIndex        =   1
      Top             =   120
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Include"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   5760
      TabIndex        =   5
      Top             =   0
      Width           =   2415
   End
   Begin VB.FileListBox File1 
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   450
      Hidden          =   -1  'True
      Left            =   240
      TabIndex        =   10
      Top             =   1200
      Width           =   2535
   End
   Begin VB.Label Label1 
      Caption         =   "Directory:"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   600
      Width           =   855
   End
   Begin VB.Menu miFile 
      Caption         =   "&File"
      Begin VB.Menu miPrint 
         Caption         =   "&Print"
         Shortcut        =   ^P
      End
      Begin VB.Menu miSep1 
         Caption         =   "-"
      End
      Begin VB.Menu miExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu miEdit 
      Caption         =   "&Edit"
      Begin VB.Menu miCopy 
         Caption         =   "&Copy"
         Shortcut        =   ^C
      End
   End
   Begin VB.Menu miDirectory 
      Caption         =   "&Directory"
      Begin VB.Menu miList 
         Caption         =   "&List"
      End
      Begin VB.Menu miBrowse 
         Caption         =   "&Browse"
      End
   End
   Begin VB.Menu miHelp 
      Caption         =   "&Help"
      Begin VB.Menu miInstruct 
         Caption         =   "Instructions"
      End
      Begin VB.Menu miAbout 
         Caption         =   "&About"
         Shortcut        =   {F1}
      End
   End
End
Attribute VB_Name = "fmDirlist"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Dim FileNames(1024) As String  ' File names used in data collection
Dim names(1024) As String      ' file names used in printing
Dim dates(1024) As String      ' file dates
Dim times(1024) As String      ' file times
Dim sizes(1024) As String      ' file sizes
Dim attrs(1024) As String      ' file attributes string

Dim iLineCount As Integer      ' The number of lines in the text control
Dim bChanged As Integer        ' Flag: Path has changed since last list op.
Dim iListEntries As Integer    ' No. of directory entries in the list
Dim dTotSize As Double         ' sum total of all file sizes in directory
Dim iTotFiles As Integer       ' total no. of files in dir.
Dim iTotDirs As Integer        ' total no. of directories in dir.

Const MAX_CHAR_PER_LINE = 80

Private Function fGetLine$(LineNumber As Long)
    ' This function fills the buffer with a line of text
    ' specified by LineNumber from the text control box.
    fGetLine$ = fmDirlist.lstDirCont.List(LineNumber)
End Function

Private Function LoadArrays()
    Dim datestr As String      ' string to hold the current file's date
    Dim timestr As String      ' string to hold the current file's time
    Dim tempattrstr As String  ' temporary attribute string
    Dim bAttr As Integer       ' the actual attributes data from file sys.
    Dim printname As String    ' the file name used only for textbox display
    
    iTotFiles = 0               'total files in array: summary info for user
    dTotSize = 0                'total bytes used: summary info for user
    iTotDirs = 0                ' total no of directories in directory
    
    MyPath = fmDirlist.txtPath  ' Set the path.
    MyName = Dir(MyPath, 30)    ' Retrieve the first entry.
    iListEntries = 0
    Do While MyName <> ""   ' Start the loop.
        ' Ignore the current directory and the parent directory.
        If MyName <> "." And MyName <> ".." Then
            ' fix the name if it's longer than 34 chars.
            If (GetAttr(MyPath & MyName) And vbDirectory) = vbDirectory Then
                printname = MyName
                If Len(printname) > 32 Then
                    printname = (Left(printname, 27)) & "..."
                End If
                printname = "[" & printname & "]"
                
                'identify the entry as a directory in the size column.
                sizes(iListEntries) = "<DIR>"
                
                'build the date and time strings...
                dtstring = FileDateTime(MyPath & MyName)
                If Len(dtstring) < 10 Then
                    ' File time is 12:00 a.m. - process as such.
                    dates(iListEntries) = dtstring
                    times(iListEntries) = "12:00:00 AM"
                Else
                    dates(iListEntries) = Left(dtstring, InStr(1, dtstring, " ") - 1)
                    times(iListEntries) = Right(Trim(dtstring), Len(Trim(dtstring)) - InStr(1, dtstring, " "))
                End If
                
                'build the directory's attribute string.
                bAttr = GetAttr(MyPath & MyName) And vbArchive
                If bAttr = 0 Then
                    tempattrstr = "-"
                Else
                    tempattrstr = "A"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbSystem
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "S"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbHidden
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "H"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbReadOnly
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "R"
                End If
                attrs(iListEntries) = tempattrstr
                iTotDirs = iTotDirs + 1
            Else
                printname = MyName
                If Len(printname) > 32 Then
                    printname = (Left(printname, 29)) & "..."
                End If
                sFileSizStr = Str(FileLen(MyPath & MyName))
                sizes(iListEntries) = sFileSizStr
                dTotSize = dTotSize + FileLen(MyPath & MyName)
                dtstring = FileDateTime(MyPath & MyName)
                If Len(dtstring) < 10 Then
                    ' File time is 12:00 a.m. - process as such.
                    dates(iListEntries) = dtstring
                    times(iListEntries) = "12:00:00 AM"
                Else
                    dates(iListEntries) = Left(dtstring, InStr(1, dtstring, " ") - 1)
                    times(iListEntries) = Right(Trim(dtstring), Len(Trim(dtstring)) - InStr(1, dtstring, " "))
                End If
                ' Time to make the attribute string...
                bAttr = GetAttr(MyPath & MyName) And vbArchive
                If bAttr = 0 Then
                    tempattrstr = "-"
                Else
                    tempattrstr = "A"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbSystem
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "S"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbHidden
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "H"
                End If
                bAttr = GetAttr(MyPath & MyName) And vbReadOnly
                If bAttr = 0 Then
                    tempattrstr = tempattrstr & "-"
                Else
                    tempattrstr = tempattrstr & "R"
                End If
                attrs(iListEntries) = tempattrstr
                iTotFiles = iTotFiles + 1
            End If
            FileNames(iListEntries) = MyName
            names(iListEntries) = printname
            iListEntries = iListEntries + 1
        End If
        MyName = Dir    ' Get next entry.
    Loop
End Function

Private Sub cmdBrowse_Click()
   fmBrowse.Show vbModal
   bChanged = 1
End Sub

Private Sub cmdExit_Click()
    End
End Sub

Private Sub cmdList_Click()
    Dim Cntr As Integer
    Dim sTempRow As String
    
    If fmDirlist.txtPath = "" Then
        Msg = "No directory selected. Please browse for a directory first."   ' Define message.
        Style = vbOKOnly     ' Define buttons.
        Title = "List error"  ' Define title.
        ' Display message.
        Response = MsgBox(Msg, Style, Title)
    Else
        'clear the list before adding items
        If fmDirlist.lstDirCont.ListCount > 0 Then
            fmDirlist.lstDirCont.Clear
        End If
        
        ' Step 1: Load the arrays if necessary.
        If bChanged = 1 Then
            Screen.MousePointer = 11       'place cursor into hourglass state
            LoadArrays            ' call function to load (reload) arrays
            bChanged = 0          ' list is no longer "changed"
            Screen.MousePointer = 0        ' place cursor back into default state
        End If
        
        ' Step 2: display the contents in the text box.
        Screen.MousePointer = 11      'place cursor into hourglass state
        ' Write dir name, and don't let it get over 60 char's long.
        If Len(fmDirlist.txtPath.Text) > 60 Then
            fmDirlist.lstDirCont.AddItem "Directory of " + Left(txtPath.Text, 57) + "..."
        Else
            fmDirlist.lstDirCont.AddItem "Directory of " + txtPath.Text
        End If
        fmDirlist.lstDirCont.AddItem " "
        
        ' Start compiling list information, based upon what's checked.
        Cntr = 0
        Do While Cntr < iListEntries
            sTempRow = names(Cntr) + Space(33 - Len(names(Cntr)))
            If fmDirlist.chkSize = 1 Then
                sTempRow = sTempRow + Space(12 - Len(sizes(Cntr))) + sizes(Cntr)
            End If
            If fmDirlist.chkDate = 1 Then
                sTempRow = sTempRow + Space(11 - Len(dates(Cntr))) + dates(Cntr)
            End If
            If fmDirlist.chkTime = 1 Then
                sTempRow = sTempRow + Space(12 - Len(times(Cntr))) + times(Cntr)
            End If
            If fmDirlist.chkAttrs = 1 Then
                sTempRow = sTempRow + Space(5 - Len(attrs(Cntr))) + attrs(Cntr)
            End If
            fmDirlist.lstDirCont.AddItem sTempRow
            sTempRow = sTempRow + Chr$(13) + Chr$(10)
            Cntr = Cntr + 1
        Loop
        
        
        'print some white space and append summary info for this directory.
        fmDirlist.lstDirCont.AddItem " "
        fmDirlist.lstDirCont.AddItem "Bytes used: " + Format(Str(dTotSize), "#,###,###,###")
        fmDirlist.lstDirCont.AddItem "Total Files: " + Str(iTotFiles)
        fmDirlist.lstDirCont.AddItem "Total Directories: " + Str(iTotDirs)
        
        Screen.MousePointer = 0     ' place cursor back into default state
        fmDirlist.lstDirCont.Refresh
    End If
    iLineCount = iListEntries + 7  ' This is used for printing
                        ' (iListEntries lines + 6 for header/summary info).
End Sub





Private Sub miAbout_Click()
   fmAbout.Show vbModal
End Sub

Private Sub miBrowse_Click()
   fmBrowse.Show vbModal
   bChanged = 1
End Sub

Private Sub miCopy_Click()
    Clipboard.Clear ' Clear Clipboard.
    For n = 0 To fmDirlist.lstDirCont.ListCount - 1
        Clipboard.SetText Clipboard.GetText + fmDirlist.lstDirCont.List(n) + Chr$(13) + Chr$(10)
    Next n
End Sub

Private Sub miExit_Click()
    End
End Sub

Private Sub miInstruct_Click()
    fmDirlist.lstDirCont.Clear
    fmDirlist.lstDirCont.AddItem "INSTRUCTIONS"
    fmDirlist.lstDirCont.AddItem " "
    fmDirlist.lstDirCont.AddItem "1. Locate a directory to view by clicking the Browse button."
    fmDirlist.lstDirCont.AddItem "2. Select your desired detail in the Include group."
    fmDirlist.lstDirCont.AddItem "3. Click the List button to display the directory contents."
    fmDirlist.lstDirCont.AddItem "4. Click File, then Print to print the directory listing out."
    fmDirlist.lstDirCont.AddItem " "
    fmDirlist.lstDirCont.AddItem "* Click File then Exit or the Exit button to quit."
    fmDirlist.lstDirCont.AddItem "* Click Edit then Copy to copy the directory list to the Clipboard."
End Sub

Private Sub miList_Click()
    Dim Cntr As Integer
    Dim sTempRow As String
    
    If fmDirlist.txtPath = "" Then
        Msg = "No directory selected. Please browse for a directory first."   ' Define message.
        Style = vbOKOnly     ' Define buttons.
        Title = "List error"  ' Define title.
        ' Display message.
        Response = MsgBox(Msg, Style, Title)
    Else
        'clear the list before adding items
        If fmDirlist.lstDirCont.ListCount > 0 Then
            fmDirlist.lstDirCont.Clear
        End If
        
        ' Step 1: Load the arrays if necessary.
        If bChanged = 1 Then
            Screen.MousePointer = 11       'place cursor into hourglass state
            LoadArrays            ' call function to load (reload) arrays
            bChanged = 0          ' list is no longer "changed"
            Screen.MousePointer = 0        ' place cursor back into default state
        End If
        
        ' Step 2: display the contents in the text box.
        Screen.MousePointer = 11      'place cursor into hourglass state
        ' Write dir name, and don't let it get over 60 char's long.
        If Len(fmDirlist.txtPath.Text) > 60 Then
            fmDirlist.lstDirCont.AddItem "Directory of " + Left(txtPath.Text, 57) + "..."
        Else
            fmDirlist.lstDirCont.AddItem "Directory of " + txtPath.Text
        End If
        fmDirlist.lstDirCont.AddItem " "
        
        ' Start compiling list information, based upon what's checked.
        Cntr = 0
        Do While Cntr < iListEntries
            sTempRow = names(Cntr) + Space(33 - Len(names(Cntr)))
            If fmDirlist.chkSize = 1 Then
                sTempRow = sTempRow + Space(12 - Len(sizes(Cntr))) + sizes(Cntr)
            End If
            If fmDirlist.chkDate = 1 Then
                sTempRow = sTempRow + Space(11 - Len(dates(Cntr))) + dates(Cntr)
            End If
            If fmDirlist.chkTime = 1 Then
                sTempRow = sTempRow + Space(12 - Len(times(Cntr))) + times(Cntr)
            End If
            If fmDirlist.chkAttrs = 1 Then
                sTempRow = sTempRow + Space(5 - Len(attrs(Cntr))) + attrs(Cntr)
            End If
            fmDirlist.lstDirCont.AddItem sTempRow
            sTempRow = sTempRow + Chr$(13) + Chr$(10)
            Cntr = Cntr + 1
        Loop
        
        
        'print some white space and append summary info for this directory.
        fmDirlist.lstDirCont.AddItem " "
        fmDirlist.lstDirCont.AddItem "Bytes used: " + Format(Str(dTotSize), "#,###,###,###")
        fmDirlist.lstDirCont.AddItem "Total Files: " + Str(iTotFiles)
        fmDirlist.lstDirCont.AddItem "Total Directories: " + Str(iTotDirs)
        
        Screen.MousePointer = 0     ' place cursor back into default state
        fmDirlist.lstDirCont.Refresh
    End If
    iLineCount = iListEntries + 7  ' This is used for printing
                        ' (iListEntries lines + 6 for header/summary info).
End Sub


Private Sub miPrint_Click()
    If fmDirlist.lstDirCont.ListCount = 0 Then
        Msg = "Nothing to print: Try Listing first."
        Style = vbOKOnly
        Title = "Print error"
        Response = MsgBox(Msg, Style, Title)
    Else
        ndx& = iLineCount
        For n& = 1 To ndx&
            Buffer = "   " & fGetLine(n& - 1)
            Printer.Print Buffer
        Next n&
        Printer.EndDoc
    End If
End Sub


