{ checks that (1) file lengths match up, (2) files don't overlap,      }
{ (3) that files don't have end-clusters in the middle, and (4) that   }
{ filenames are all different.                                         }

{$I+}

type filedata_ptr = ^filedata;
     clusterdata_ptr = ^clusterdata;
     filedata = record
                  name:string;
                  given_length:longint;
                  lastcluster_bytes:word;
                  firstcluster:clusterdata_ptr;
                  next:filedata_ptr;
                end;
     clusterdata = record
                     useCVF:boolean;
                     cluster:longint;
                     consecutive:longint;
                     next:clusterdata_ptr;
                   end;
     endcluster_list = array[0..$1FFF] of longint;
     endcluster_array = array[0..9999] of ^endcluster_list;  { dummy index }


var infile,outfile:text;
    endcluster:^endcluster_array;
    num_endclusters:longint;
    firstfile:filedata_ptr;




procedure getclusterlist;
var clusterfile:file of longint;
    numchunks,i:longint;
begin
  assign(clusterfile,paramstr(3));
  reset(clusterfile);
  num_endclusters:=filesize(clusterfile);
  numchunks:=num_endclusters shr 13;
  if (num_endclusters and $1FFF)<>0 then inc(numchunks);
  if numchunks>0 then
    begin
      getmem(endcluster,numchunks*sizeof(pointer));
      for i:=0 to (numchunks-1) do new(endcluster^[i]);
      for i:=0 to (num_endclusters-1) do read(clusterfile,endcluster^[i shr 13]^[i and $1FFF]);
    end;
  close(clusterfile);
end;




function dectohex(x:longint):string;
const hex:string[16]='0123456789ABCDEF';
var result:string;
begin
  result:='';
  repeat
    result:=hex[(x and $F)+1]+result;
    x:=x shr 4;
  until x=0;
  dectohex:=result;
end;




function hextodec(const s:string; var err:integer):longint;
var p:byte;
    result:longint;
begin
  p:=0;
  result:=0;
  while p<length(s) do
    begin
      result:=result shl 4;
      inc(p);
      if (s[p]>='0') and (s[p]<='9') then inc(result,ord(s[p])-ord('0'))
      else if (upcase(s[p])>='A') and (upcase(s[p])<='F')
        then inc(result,ord(upcase(s[p]))-ord('A')+10)
      else
        begin
          err:=p;
          result:=0;
          p:=length(s);
        end;
    end;
  hextodec:=result;
end;




procedure removewhitespace(var s:string);
var c:byte;
    new_s:string;
begin
  new_s:='';
  c:=1;
  while (c<=length(s)) and (s[c]<>';') do
    begin
      if (s[c]<>' ') and (s[c]<>#9) and (s[c]<>#10) and (s[c]<>#13)
        then new_s:=new_s+s[c];
      inc(c);
    end;
  s:=new_s;
end;




procedure parseinputfile;
var current_cluster,cl:clusterdata_ptr;
    current_file,cf:filedata_ptr;
    linecount,noname_count,n,m,calclength:longint;
    p,q,len,cshift:byte;
    errcode:integer;
    useCVF:boolean;
    csize:longint;
    s:string;
begin
  linecount:=0;
  noname_count:=1;
  current_file:=nil;
  while not(eof(infile)) do
    begin
      readln(infile,s);
      inc(linecount);
      removewhitespace(s);
      len:=length(s);
      if len>0 then if s[1]='#' then
        begin
          calclength:=0;
          new(cf);
          cf^.next:=nil;
          cf^.firstcluster:=nil;
          current_cluster:=nil;
          if firstfile=nil then
            begin
              firstfile:=cf;
              current_file:=cf;
            end
          else
            begin
              current_file^.next:=cf;
              current_file:=cf;
            end;
          p:=2;
          while (p<=len) and (s[p]<>',') do inc(p);
          if p=2 then
            begin
              str(noname_count,current_file^.name);
              inc(noname_count);
              current_file^.name:='UNKNOWN.'+current_file^.name;
              writeln(outfile,'LINE ',linecount,': Missing file name');
            end
          else current_file^.name:=copy(s,2,p-2);
          if p>=len then current_file^.given_length:=0 else
            begin
              if s[p+1]='$'
                then current_file^.given_length:=hextodec(copy(s,p+2,len-p-1),errcode)
                else val(copy(s,p+1,len-p),current_file^.given_length,errcode);
              if errcode<>0 then
                begin
                  current_file^.given_length:=0;
                  writeln(outfile,'LINE ',linecount,': Invalid file length');
                end;
            end;
        end
      else if (current_file=nil) then writeln(outfile,'LINE ',linecount,': Syntax error') else
        begin
          if (len>0) and (s[1]='U') then
            begin
              useCVF:=true;
              csize:=$200;
              cshift:=9;
              p:=2;
            end
          else
            begin
              useCVF:=false;
              csize:=$8000;
              cshift:=15;
              p:=1;
            end;
          while (p<=len) do
            begin
              q:=p;
              while (q<=len) and (s[q]<>',') and (s[q]<>'-') do inc(q);
              n:=hextodec(copy(s,p,q-p),errcode);
              if (p=q) or (errcode<>0) then
                writeln(outfile,'LINE ',linecount,': Invalid entry "',copy(s,p,q-p),'"')
              else
                begin
                  new(cl);
                  cl^.next:=nil;
                  cl^.cluster:=n shr cshift;
                  if (n and (csize-1))<>0 then
                    begin
                      write(outfile,'LINE ',linecount,': $',dectohex(n),' is not the start of a ');
                      if useCVF then writeln(outfile,'sector') else writeln(outfile,'cluster');
                    end;
                  cl^.consecutive:=1;
                  cl^.useCVF:=useCVF;
                  if current_file^.firstcluster=nil then
                    begin
                      current_file^.firstcluster:=cl;
                      current_cluster:=cl;
                    end
                  else
                    begin
                      if (current_cluster^.useCVF and
                          ((current_file^.lastcluster_bytes<>$200) or
                           ((current_cluster^.consecutive and 63)<>0)))
                         or (not(current_cluster^.useCVF) and
                             (current_file^.lastcluster_bytes<>$8000)) then
                        begin
                          writeln(outfile,'LINE ',linecount,': Length of file fragment preceding $',
                                          dectohex(n),' not a whole no. of clusters');
                          if current_cluster^.useCVF
                            then inc(calclength,$200-current_file^.lastcluster_bytes)
                            else inc(calclength,$8000-current_file^.lastcluster_bytes);
                        end;
                      current_cluster^.next:=cl;
                      current_cluster:=cl;
                    end;
                  current_file^.lastcluster_bytes:=csize;
                  if (q<=len) and (s[q]='-') then
                    begin
                      inc(q);
                      p:=q;
                      if (q=len) and (s[q]='.') then
                        begin
                          if current_file^.given_length=0 then
                            begin
                              writeln(outfile,'LINE ',linecount,': No file length provided to fill in $',dectohex(n),'-.');
                              m:=n+csize;
                            end
                          else m:=n+current_file^.given_length-calclength;
                          if m<=0 then
                            begin
                              writeln(outfile,'LINE ',linecount,
                                      ': File length exceeded before encountering $',dectohex(n),'-.');
                              m:=n+csize;
                            end;
                          inc(q);
                          errcode:=0;
                        end
                      else
                        begin
                          while (q<=len) and (s[q]<>',') do inc(q);
                          m:=hextodec(copy(s,p,q-p),errcode);
                        end;
                      if (p=q) or (errcode<>0) then
                        writeln(outfile,'LINE ',linecount,': Invalid entry "',copy(s,p,q-p),'"')
                      else if (m<=n) then
                        writeln(outfile,'LINE ',linecount,': Invalid range $',dectohex(n),' - $',dectohex(m))
                      else
                        begin
                          current_cluster^.consecutive:=(m shr cshift)-(n shr cshift);
                          if (m and (csize-1))<>0 then
                            begin
                              inc(current_cluster^.consecutive);
                              current_file^.lastcluster_bytes:=m and (csize-1);
                            end;
                          inc(calclength,current_file^.lastcluster_bytes+
                                 ((current_cluster^.consecutive-1) shl cshift));
                        end;
                    end
                  else inc(calclength,csize);
                end;
              p:=q+1;
            end;
        end;
    end;
end;





function contains_endcluster(first,last:longint; var lo,hi:longint):boolean;
var i,j,c:longint;
begin
  if (num_endclusters=0) or
     (first>endcluster^[num_endclusters-1]^[(num_endclusters-1) and $1FFF]) or
     (last<endcluster^[0]^[0]) then contains_endcluster:=false else
    begin
      lo:=0;  i:=num_endclusters-1;
      while (lo<i) and (endcluster^[lo shr 13]^[lo and $1FFF]<first) do
        begin
          j:=(lo+i) div 2;
          c:=endcluster^[j shr 13]^[j and $1FFF];
          if c<first then lo:=j+1 else i:=j;
        end;
      i:=0;  hi:=num_endclusters-1;
      while (i<hi) and (endcluster^[hi shr 13]^[hi and $1FFF]>last) do
        begin
          j:=(i+hi+1) div 2;
          c:=endcluster^[j shr 13]^[j and $1FFF];
          if c>last then hi:=j-1 else i:=j;
        end;
      if (lo<=hi) then contains_endcluster:=true
                  else contains_endcluster:=false;
    end;
end;





procedure checkforerrors;
var f1,f2:filedata_ptr;
    c1,c2:clusterdata_ptr;
    count,first,last,filelength,lo,hi,i:longint;
    useCVF:boolean;
begin
  f1:=firstfile;
  while f1<>nil do
    begin
      f2:=firstfile;  { check for repeat filenames and overlapping clusters }
      while f2<>f1 do
        begin
          if f1^.name=f2^.name
            then writeln(outfile,'DUPLICATE FILE: "',f1^.name,'"') else
            begin
              count:=0;
              c1:=f1^.firstcluster;
              while c1<>nil do
                begin
                  c2:=f2^.firstcluster;
                    while c2<>nil do
                      begin
                        if c1^.useCVF=c2^.useCVF then
                          begin
                            if (c1^.cluster>=c2^.cluster)
                              then first:=c1^.cluster
                              else first:=c2^.cluster;
                            if (c1^.cluster+c1^.consecutive<=c2^.cluster+c2^.consecutive)
                              then last:=c1^.cluster+c1^.consecutive-1
                              else last:=c2^.cluster+c2^.consecutive-1;
                            if first<=last then
                              begin
                                if count=0 then
                                  writeln(outfile,'FILES "',f1^.name,'" AND "',f2^.name,'" OVERLAP ON CLUSTER(S):');
                                if (count and 3)<>0 then write(outfile,',   ');
                                write(outfile,dectohex(first shl 15));
                                if last>first then write(outfile,'-',dectohex((last+1) shl 15));
                                inc(count);
                                if (count and 3)=0 then writeln(outfile);
                              end;
                          end;
                        c2:=c2^.next;
                      end;
                  c1:=c1^.next;
                end;
              if (count and 3)<>0 then writeln(outfile);
            end;
          f2:=f2^.next;
        end;
      { check for mid-file end-clusters and verify given file length }
      filelength:=0;
      c1:=f1^.firstcluster;
      count:=0;
      while c1<>nil do
        begin
          useCVF:=c1^.useCVF;
          if useCVF then
            if c1^.next=nil
              then inc(filelength,((c1^.consecutive-1) shl 9)+f1^.lastcluster_bytes)
              else inc(filelength,c1^.consecutive shl 9)
          else
            begin
              if c1^.next=nil
                then inc(filelength,((c1^.consecutive-1) shl 15)+f1^.lastcluster_bytes)
                else inc(filelength,c1^.consecutive shl 15);
              if ((c1^.next=nil) and (c1^.consecutive>1) and
                  contains_endcluster(c1^.cluster,c1^.cluster+c1^.consecutive-2,lo,hi))
                 or
                 ((c1^.next<>nil) and
                  contains_endcluster(c1^.cluster,c1^.cluster+c1^.consecutive-1,lo,hi)) then
                begin
                  if count=0 then writeln(outfile,'"',f1^.name,'" CONTAINS THE FOLLOWING END-CLUSTER(S) MID WAY THROUGH:');
                  for i:=lo to hi do
                    begin
                      if (count and 3)<>0 then write(outfile,',   ');
                      write(outfile,dectohex((endcluster^[i shr 13]^[i and $1FFF]) shl 15));
                      inc(count);
                      if (count and 3)=0 then writeln(outfile);
                    end;
                end;
            end;
          c1:=c1^.next;
        end;
      if (count and 3)<>0 then writeln(outfile);
      if (f1^.firstcluster=nil) or (filelength=0) then
        writeln(outfile,'NO DATA SPECIFIED FOR "',f1^.name,'" !')
      else if (f1^.given_length>0) and (f1^.given_length<>filelength) then
        if ((f1^.given_length-1) shr 15)<>((filelength-1) shr 15) then
          begin
            writeln(outfile,'"',f1^.name,'" HAS INCORRECT NUMBER OF CLUSTERS:');
            writeln(outfile,((f1^.given_length-1) shr 15)+1,' required, but ',((filelength-1) shr 15)+1,' supplied');
          end
        else
          begin
            writeln(outfile,'"',f1^.name,'" HAS INCORRECT LENGTH:');
            writeln(outfile,f1^.given_length,' was the specified length, actual length is ',filelength);
          end;
      if not(useCVF) and (((f1^.given_length-1) and $7FFF)<$200) then
        writeln(outfile,'"',f1^.name,'" HAS AN UNACCOUNTED-FOR FINAL CLUSTER THAT WAS STORED UNCOMPRESSED');
      f1:=f1^.next;
    end;
end;





procedure cleanup;
var cl1,cl2:clusterdata_ptr;
    f:filedata_ptr;
    numchunks,i:longint;
begin
  close(infile);
  close(outfile);
  if num_endclusters>0 then
    begin
      numchunks:=num_endclusters shr 13;
      if (num_endclusters and $1FFF)<>0 then inc(numchunks);
      for i:=0 to (numchunks-1) do dispose(endcluster^[i]);
      freemem(endcluster,numchunks*sizeof(pointer));
    end;
  while firstfile<>nil do
    begin
      cl1:=firstfile^.firstcluster;
      while cl1<>nil do
        begin
          cl2:=cl1^.next;
          dispose(cl1);
          cl1:=cl2;
        end;
      f:=firstfile^.next;
      dispose(firstfile);
      firstfile:=f;
    end;
end;



begin
  if (paramcount<2) or (paramcount>3) then
    begin
      writeln;
      writeln('Usage:  CHKRECVR <recovery data file> <output file> [<cluster info file>]');
      writeln;
      writeln('See accompanying README.TXT file for more information');
      halt;
    end;
  firstfile:=nil;

  if paramcount=3 then getclusterlist else num_endclusters:=0;

  assign(outfile,paramstr(2));
  rewrite(outfile);
  writeln(outfile,'*** ERROR LIST FOR RECOVERY FILE:');
  writeln(outfile);
  assign(infile,paramstr(1));
  reset(infile);

  parseinputfile;
  checkforerrors;

  writeln(outfile);
  writeln(outfile,'DONE.');
  cleanup;
end.