/*******************************************************
  mdel v1.1
  Copyright (c) 1997-1998 Magnus Bck
  baeck@swipnet.se
********************************************************
  This software may be distributed and modified freely
  as long as the original copyright is not removed and
  no profit is made from it.
*******************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>
#include <io.h>

#ifdef __WIN32__
#include <windows.h>
#endif

#ifdef __WIN32__
const char *FULLAPPNAME 		= "mdel for Win32";
#else
const char *FULLAPPNAME 		= "mdel";
#endif
const char *APPNAME				= "mdel";
const char *VERSION				= "v1.1";
const char *COPYRIGHT			= "Copyright (c) 1997-1998 Magnus Bck";
const int EXIT_INVALID_PARAM	= 2;
const int EXIT_DELETE_ERROR		= 3;

void error(char *message, char *filename, int errorCode);

void deletefile(char *filename, bool recycle, bool force);

int main(int argc, char *argv[])
{
	bool doRecycle = false;
	bool doForce = false;
#ifdef __WIN32__
	SetFileApisToOEM();
#endif
	if ((argc > 1) && !strcmp(argv[1], "/?"))
	{
		printf("%s %s %s\n\n", FULLAPPNAME, VERSION, COPYRIGHT);
#ifdef __WIN32__
		puts("Syntax:  mdel32.exe [/F] [/R[ECYCLE]]");
#else
		puts("Syntax:  mdel.exe [/F]");
#endif
		puts("Purpose: Deletes the files received from stdin (one file per line).");
		puts("\n/F forces deletion of read-only files.");
#ifdef __WIN32__
		puts("/RECYCLE (or just /R) places the files in the Recycle bin instead.");
#endif
		exit(EXIT_SUCCESS);
	}
	for (int i = 1; i < argc; i++)
	{
		if (!stricmp(argv[i], "/F"))
			doForce = true;
		else
#ifdef __WIN32__
		if (!stricmp(argv[i], "/R") || !stricmp(argv[i], "/RECYCLE"))
			doRecycle = true;
		else
#endif
			error("Invalid parameter. Use /? for help.", NULL, EXIT_INVALID_PARAM);
	}
	char *file = new char[MAXPATH];
	while (gets(file))
		deletefile(file, doRecycle, doForce);
	delete file;
	return 0;
}

void error(char *message, char *filename, int errorCode)
{
	if (filename)
		fprintf(stderr, "%s: %s: %s\n", APPNAME, filename, message);
	else
		fprintf(stderr, "%s: %s\n", APPNAME, message);
	if (errorCode)
		exit(errorCode);
}

void deletefile(char *filename, bool recycle, bool force)
{
	int attr = _rtl_chmod(filename, 0);
	if (force && (attr != -1) && (attr & FA_RDONLY))
		_rtl_chmod(filename, 1, attr - FA_RDONLY);
#ifdef __WIN32__
	if (recycle)
	{
		char *nameparam = new char[MAXPATH];
		strcpy(nameparam, filename);
		if ((nameparam[1] != ':') && (nameparam[2] != '\\'))
		{
			if ((nameparam[1] == ':') || strstr(nameparam, "\\"))
				error("Relative file specifications not allowed", nameparam, 0);
			else
			{
				char cwd[MAXPATH];
				GetCurrentDirectory(MAXPATH, cwd);
				if (cwd[strlen(cwd) - 1] != '\\')
					strcat(cwd,"\\");
				strcat(cwd, nameparam);
				strcpy(nameparam, cwd);
			}
		}
		nameparam[strlen(nameparam) + 1] = 0;
		SHFILEOPSTRUCT *opdata = new SHFILEOPSTRUCT;
		opdata->hwnd = GetDesktopWindow();
		opdata->wFunc = FO_DELETE;
		opdata->pFrom = nameparam;
		opdata->pTo = NULL;
		opdata->fFlags = FOF_ALLOWUNDO | FOF_NOCONFIRMATION	| FOF_SILENT;
		opdata->hNameMappings = NULL;
		opdata->lpszProgressTitle = NULL;
		if (SHFileOperation(opdata) != 0)
			error("Error recycling file", filename, 0);
		delete opdata;
	}
	else
#endif
	if ((attr & FA_DIREC) && (rmdir(filename) == -1))
		error("Error deleting directory, it may be non-empty", filename, 0);
	else if (!(attr & FA_DIREC) && (remove(filename) == -1))
		error("Error deleting file", filename, 0);
}

