unit WIMADLL;

interface
uses
  Windows;

const
  WimaDllName = 'wimadll.dll';

Type PBool     = ^WordBool;
     PBoolean  = ^Boolean;
     PByte     = ^Byte;
     PWord     = ^Word;
     PShortInt = ^ShortInt;
     PInteger  = ^Integer;
     PLongInt  = ^LongInt;
     PSingle   = ^Single;
     PDouble   = ^Double;
     PPointer  = ^Pointer;

     HGlobal                 =  THandle;
     PRGBTriple              = ^TRGBTriple;
     PRGBQuad                = ^TRGBQuad;
     PMenuItemTemplateHeader = ^TMenuItemTemplateHeader;
     PMenuItemTemplate       = ^TMenuItemTemplate;
     PMultiKeyHelp           = ^TMultiKeyHelp;



Type str_ima_handle = record
                        unused: Integer;
                      end {str_ima_handle};

Type HIMA = str_ima_handle;



{$IFNDEF _INC_DISK}

{$IFNDEF MAXLFN}
Const MAXLFN = 256;
{$ENDIF}


Type DIRINFO = record
            nom: Array[0..8-1] of Char;
            ext: Array[0..3-1] of Char;
            szCompactName: Array[0..13-1] of Char;
            bAttr: BYTE;

            dir_CreateMSec: BYTE;
            dir_CreateDate: Word;

            DosTime: Word;
            DosDate: Word;

            fIsSubDir: Bool;
            fSel: Bool;
            fLfnEntry: Bool;
            dwSize: LongInt;
            uiPosInDir: LongInt;
            dwLocalisation: LongInt;
            dwTrueSize: LongInt;
            longname: Array[0..MAXLFN-1] of Char;
            dir_CreateTime: Word;
            dir_LastAccessDate: Word;

          end {_1};
Type PDIRINFO =  ^DIRINFO;          
Type LPDIRINFO = PDIRINFO;
{$ENDIF}


{$IFNDEF SORT_NONE}
Const SORT_NONE = 72;
Const SORT_NAME = 73;
Const SORT_EXT = 74;
Const SORT_SIZE = 75;
Const SORT_DATE = 76;
{$ENDIF}

{$IFNDEF CDM_ROOT}
Const CDM_ROOT = 50;
Const CDM_UPPER = 51;
Const CDM_ENTRY = 52; {// use ChszDir}
{$ENDIF}

type CHOICEAPP = LongInt;
Const NOTHING:CHOICEAPP=0;
Const USED:CHOICEAPP = 1;
Const ALL:CHOICEAPP =2;
Const BEGINFLOPPY:CHOICEAPP=3;
{/// CreateMemFatHima : Create an Image Object. }
{/// you need call ReadImaFile, ReadFloppy or MakeEmptyImage }

function CreateMemFatHima: HIMA ;
               stdcall; external WimaDllName name 'CreateMemFatHima';

{/// CreateMemHfsHima : Create an Image Object for Mac floppy. }
{/// you need call ReadImaFile, ReadFloppy }
{/// extract, inject... cannot be used }

function CreateMemHfsHima: HIMA ;
               stdcall; external WimaDllName name 'CreateMemHfsHima';

{/// CreateMemHfsHima : Create an Image Object by loading CDRom ISO image }
{/// lpFn : Filename of .ISO file }
{/// inject,...cannot be used }

function CreateCDIsoIma(lpFn: PChar): HIMA ;
               stdcall; external WimaDllName name 'CreateCDIsoIma';

{/// DeleteIma : Delete an Image Object. }

procedure DeleteIma(Ima: HIMA) ;stdcall;
               stdcall; external WimaDllName name 'DeleteIma';

{/// Read an image file (.IMA or .IMZ) }
{/// hWnd : parent window for progress window }
{/// lpFn : FileName }
{/// lpfCompr : pointer to Boolean (will receive TRUE if file is compressed) }
{/// dwPosFileBegin : position in file (usualy 0, except in WLZ) }

function ReadImaFile(hIma: HIMA;
                     hWnd: HWND;
                     lpFn: PChar;
                     lpfCompr: PBool;
                     dwPosFileBegin: LongInt): Bool ;
               stdcall; external WimaDllName name 'ReadImaFile';

{/// WriteImaFile : WriteCompressed image }
{/// hWnd : parent window for progress window }
{/// lpFn : FileName }
{/// fTruncate : TRUE if you want truncate unused part of image }
{/// fCompress : TRUE if you want compress }
{/// iLevelCompress : used is fCompress is TRUE, level of compress (1 to 9) }
{/// dwPosBeginWrite : position in file (usualy 0) }
{/// lpNameInCompr : alternate name in compressed file (can be NULL) }

function WriteImaFile(hIma: HIMA;
                      hWnd: HWND;
                      lpFn: PChar;
                      fTruncate: Bool;
                      fCompress: Bool;
                      iLevelCompress: Integer;
                      dwPosBeginWrite: LongInt;
                      lpNameInCompr: PChar): Bool ;
               stdcall; external WimaDllName name 'WriteImaFile';

{/// ReadFloppy : Read a floppy }
{/// hWnd : parent window for progress window }
{/// bFloppy : Floppy to read (0 for A:) }
{/// caRead : USED, or ALL (ALL if you want read unused part of floppy) }

function ReadFloppy(hIma: HIMA;
                    hWnd: HWND;
                    bFloppy: BYTE;
                    caRead: CHOICEAPP): Bool ;
               stdcall; external WimaDllName name 'ReadFloppy';

{/// WriteFloppy : Write a floppy }
{/// hWnd : parent window for progress window }
{/// bFloppy : Floppy to write (0 for A:) }
{/// caFormat : NOTHING or ALL (ALL for format) }
{/// caWrite : USED or ALL }
{/// caCompare : NOTHING, USED or ALL }
{/// fCheckDiskBeforeWrite : if you want check disk is empty }

function WriteFloppy(hIma: HIMA;
                     hWnd: HWND;
                     bFloppy: BYTE;
                     caFormat: CHOICEAPP;
                     caWrite: CHOICEAPP;
                     caCompare: CHOICEAPP;
                     fCheckDiskBeforeWrite: BYTE): Bool;
               stdcall; external WimaDllName name 'WriteFloppy';

{/// Create a directory in the image }
{/// lpDir : Directory name }

function MkDir(hIma: HIMA;
               lpDir: PChar): Bool ;stdcall;
               stdcall; external WimaDllName name 'MkDir';

{/// Change current directory by name }
{/// lpDir : Directory name }

function ChszDir(hIma: HIMA;
                 lpDir: PChar): Bool ;
               stdcall; external WimaDllName name 'ChszDir';

{/// Change current directory by mode }
{/// bMode : CDM_ROOT or CDM_UPPER (equiv. to cd \ and cd ..) }

function ChDir(hIma: HIMA;
               bMode: BYTE): Bool ;
               stdcall; external WimaDllName name 'ChDir';

{/// InjectFile : Inject a file in floppy }
{/// lpFn : file to inject }
{/// lpDwSize : Pointer to DWORD that will receive the size. Can be NULL. }
{/// lpTooBig : Pointer to BOOL, become TRUE if file too big to be injected }
{/// (if InjectFile return FALSE). Can be NULL. }
{/// lpNameWhenInjected : if not NULL, contain a new name in the image }
{/// (if the file must have another name when injected). Can be NULL. }

function InjectFile(hIma: HIMA;
                    lpFn: PChar;
                    lpDwSize: PLongInt;
                    lpTooBig: PBool;
                    lpNameWhenInjected: PChar): Bool ;
               stdcall; external WimaDllName name 'InjectFile';

{/// MakeEmptyImage : make an empty image }
{/// iNotypeDisk : 4=720K,6=1440K,7=2880K,8=DMF2048,9=DMF1024,10=1680K }
{/// 0=160K,1=180K,2=320K,3=360K,5=1200K (old, no ! :-)) }

function MakeEmptyImage(hIma: HIMA;
                        iNoTypeDisk: Integer): Bool ;
               stdcall; external WimaDllName name 'MakeEmptyImage';

{/// InitWimaSdk : Init the DLL and use hinstdll for resource }
Const DEBENUSTD = 'ENU';
Const BASEENUSTD = (10000);

function InitWimaSdk(hinstdll: HINST;
                     lpDeb: PChar;
                     wBase: Word): Bool ;
               stdcall; external WimaDllName name 'InitWimaSdk';

{/// GetCurDir : Get the name of current directory }
{/// lpBuf : buffer that will receive the name }
{/// uiMaxSize : the size of buffer }

function GetCurDir(hIma: HIMA;
                   lpBuf: PChar;
                   uiMaxSize: Word): Bool ;
               stdcall; external WimaDllName name 'GetCurDir';

{/// GetNbEntryCurDir : Get the number of entry of cur directory }

function GetNbEntryCurDir(hIma: HIMA): LongInt ;
               stdcall; external WimaDllName name 'GetNbEntryCurDir';

{/// GetDirInfo : Get info about the entry of cur directory }
{/// LPDIRINFO : array of DIRINFO that will receive the info }
{/// (use GetNbEntryCurDir for know the size needed) }
{/// bSort : specify how the file must be sort }
{/// (SORT_NONE, SORT_NAME, SORT_EXT, SORT_SIZE or SORT_DATE) }

function GetDirInfo(hIma: HIMA;
                    lpdi: PDIRINFO;
                    bSort: BYTE): Bool ;
               stdcall; external WimaDllName name 'GetDirInfo';

{/// Sort : Resort the array obtained by GetDirInfo }

function Sort(hIma: HIMA;
              lpdi: PDIRINFO;
              bSort: BYTE): Bool ;
               stdcall; external WimaDllName name 'Sort';

{/// GetLabel : Get the label of Image }
{/// lpBuf : will receive the label }

function GetLabel(hIma: HIMA;
                  lpBuf: PChar): Bool ;
               stdcall; external WimaDllName name 'GetLabel'

{/// SetLabel : Set the label of Image }
{/// lpBuf : contain the new label }

function SetLabel(hIma: HIMA;
                  lpBuf: PChar): Bool ;
               stdcall; external WimaDllName name 'SetLabel';

{/// ExtractFile : Extract one file }
{/// unPosDir : The uiPosInDir fields in DIRINFO structure that describe }
{/// the file }
{/// lpPath : Path where extract the file }
{/// lpFullName: will receive the exact full name of created file. Can be NULL }

function ExtractFile(hIma: HIMA;
                     uiPosDir: Word;
                     lpPath: PChar;
                     lpFullName: PChar): Bool ;
               stdcall; external WimaDllName name 'ExtractFile';

{/// CheckSpaceForFile : Check you've space for inject a file of dwSize bytes }

function CheckSpaceForFile(hIma: HIMA;
                           dwSize: LongInt): Bool ;
               stdcall; external WimaDllName name 'CheckSpaceForFile';

{/// to know if an inject is possible but need replace }
{/// lpFn : contain the name of file to be injected }
{/// lpDwSize : will receive the size of old file with same name. Can be NULL }
{/// lpNameWhenInjected : if not NULL, contain a new name in the image }
{/// lpShortName : will receive the short (8) name of file in image. Can be NULL }
{/// lpShortExt : will receive the short (3) ext of file in image. Can be NULL }
{/// (if the file must have another name when injected) }

function IfInjectPossibleButNeedReplace(hIma: HIMA;
                                        lpFn: PChar;
                                        lpDwSize: PLongInt;
                                        lpShortName: PChar;
                                        lpShortExt: PChar;
                                        lpNameWhenInjected: PChar): Bool ;
               stdcall; external WimaDllName name 'IfInjectPossibleButNeedReplace';

{/// RmDir : Remove a directory }
{/// unPosDir : The uiPosInDir fields in DIRINFO structure that describe }
{/// the file }

function RmDir(hIma: HIMA;
               uiPosDir: Word): Bool ;
               stdcall; external WimaDllName name 'RmDir';

{/// DeleteFileNameExt }

function DeleteFileNameExt(hIma: HIMA;
                           lpNom: PChar;
                           lpExt: PChar;
                           fRealDel: Bool): Bool ; stdcall; external WimaDllName name 'DeleteFileNameExt';


{// RenameFile :    Extract one file }
{ //  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe }
{ //                  the file }
{ //  lpNewLongName: The new name of the file }
function RenameFile(hIma: HIMA;
                    uiPosDir: Word;
		            lpNewLongName: PChar): Bool ;
               stdcall; external WimaDllName name 'RenameFile';

{ ChangeDateAndAttribute :    Extract one file }
{  uiPosDir :     The uiPosInDir fields in DIRINFO structure that describe }
{                  the file }
{  *lpbNewAttr:   Contain the new attribute of the file (or NULL to no change) }
{  *lpNewDosDate, }
{  *lpNewDosTime: Contain the Modified Date and Time (or NULL to no change) }
{  *lpbNewdir_CreateMSec,*lpwNewdir_CreateTime,*lpwNewdir_CreateDate }
{                 Contain the Created Date and Time (or NULL to no change) }
{  *lpwNewdir_LastAccessDate : Contain the Last Access Date (or NULL...) }

function ChangeDateAndAttribute(hIma: HIMA;
                                uiPosDir: Word;
                                lpbNewAttr: PByte;
                                lpNewDosDate: PWord;
								lpNewDosTime: PWord;
                                lpbNewdir_CreateMSec: PByte;
                                lpwNewdir_CreateTime: PWord;
								lpwNewdir_CreateDate: PWord;
                                lpwNewdir_LastAccessDate: PWord): Bool ;
               stdcall; external WimaDllName name 'ChangeDateAndAttribute';

{/// ReadData : Direct read data in image. }
{/// dwPos : begin position }
{/// dwSize : number of byte to copy (size of buffer) }
{/// lpBuf : buffer that will receive data }

function ReadData(hIma: HIMA;
                  dwPos: LongInt;
                  dwSize: LongInt;
                  lpBuf: PChar): Bool ; stdcall; external WimaDllName name 'ReadData';

{/// WriteData : Direct write data in image. Be carreful, WI don't refresh dir! }
{/// dwPos : begin position }
{/// dwSize : number of byte to copy (size of buffer) }
{/// lpBuf : buffer that contain data }

function WriteData(hIma: HIMA;
                   dwPos: LongInt;
                   dwSize: LongInt;
                   lpBuf: PChar): Bool ; stdcall; external WimaDllName name 'WriteData';

implementation

end.
