// BadDetectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BadDetect.h"
#include "BadDetectDlg.h"
#include "General.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CListCtrl	m_BadList;
CButton	m_Badetect;
CButton	m_Stop;
CComboBox	m_Drive;
char Boot[1000];
BOOT *BootPtr;
HLOCAL hMem;
LPBYTE DiskBuffer;
BOOL g_StopThread;
DWORD Drive;

HMODULE hLib;
extern UINT BadDetectProc(LPVOID lRes);
extern DLLFUNC *DllThunk32, *DllThunk32Write;
HWND hWndMain;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBadDetectDlg dialog

CBadDetectDlg::CBadDetectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBadDetectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBadDetectDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBadDetectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBadDetectDlg)
	DDX_Control(pDX, ID_BADETECT, m_Badetect);
	DDX_Control(pDX, ID_STOP, m_Stop);
	DDX_Control(pDX, IDC_DRIVE, m_Drive);
	DDX_Control(pDX, IDC_BAD, m_BadList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBadDetectDlg, CDialog)
	//{{AFX_MSG_MAP(CBadDetectDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(ID_ABOUT, OnAbout)
	ON_BN_CLICKED(ID_BADETECT, OnBadetect)
	ON_BN_CLICKED(ID_STOP, OnStop)
	ON_BN_CLICKED(ID_COPY_PROTECT, OnCopyProtect)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBadDetectDlg message handlers

BOOL CBadDetectDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	hWndMain = this->m_hWnd;
	hLib = LoadLibrary("Disk32.DLL");
	if(hLib == NULL){
		AfxMessageBox("Disk32.DLL not found");
		CDialog::OnCancel();
	}
	DllThunk32 = (DLLFUNC *) GetProcAddress(hLib, "ReadDisk32");
	if(DllThunk32 == NULL){
		AfxMessageBox("ReadDisk32 Function not accessible!");
		CDialog::OnCancel();
	}
	DllThunk32Write = (DLLFUNC *) GetProcAddress(hLib, "WriteDisk32");
	if(DllThunk32Write == NULL){
		AfxMessageBox("WriteDisk32 Function not accessible!");
		CDialog::OnCancel();
	}
	BOOL DrivePresent=FALSE;
	char TmpStr[]="A:\\";
	for(int i=0; i<26; i++){
		if(GetDriveType(TmpStr)==DRIVE_REMOVABLE){
			m_Drive.AddString(TmpStr);
			DrivePresent = TRUE;
		}
		TmpStr[0]++;
	}
	if(!DrivePresent){
		AfxMessageBox("No Floppy drives in the system!");
		FreeLibrary(hLib);
		CDialog::OnCancel();
	}
	m_Drive.SetCurSel(0);
	m_BadList.InsertColumn(0, "Track", LVCFMT_LEFT, 100, 0);
	m_BadList.InsertColumn(1, "Head", LVCFMT_LEFT, 100, 1);
	m_BadList.InsertColumn(2, "Sector", LVCFMT_LEFT, 100, 2);
	m_BadList.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBadDetectDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBadDetectDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBadDetectDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CBadDetectDlg::OnAbout() 
{
	// TODO: Add your control notification handler code here
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
}

void CBadDetectDlg::OnBadetect() 
{
	// TODO: Add your control notification handler code here
	if(!(DllThunk32)(Drive, 0, 0, 1, 1, (LPBYTE) Boot)){		//Read the boot record
		AfxMessageBox("Boot Record Not Accessible!");
		return;
	}
	BootPtr = (BOOT *) Boot;
	hMem = LocalAlloc(LMEM_MOVEABLE|LMEM_DISCARDABLE, BootPtr->SectorsPerTrack*BootPtr->BytesPerSector);
	if(hMem==NULL){
		AfxMessageBox("Unable to allocate memory");
		return;
	}
	DiskBuffer = (LPBYTE) LocalLock(hMem);
	Drive = m_Drive.GetCurSel();
	m_Stop.EnableWindow(TRUE);	
	m_Badetect.EnableWindow(FALSE);	
	m_Drive.EnableWindow(FALSE);
	g_StopThread = FALSE;
	m_BadList.DeleteAllItems();
	AfxBeginThread(BadDetectProc, 0);
}

void CBadDetectDlg::OnStop() 
{
	// TODO: Add your control notification handler code here
	m_Stop.EnableWindow(FALSE);	
	m_Badetect.EnableWindow(TRUE);	
	m_Drive.EnableWindow(TRUE);
	g_StopThread = TRUE;
}

void CBadDetectDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	LocalUnlock(hMem);
	LocalFree(hMem);
	FreeLibrary(hLib);
	CDialog::OnCancel();
}

void CBadDetectDlg::OnCopyProtect() 
{
	// TODO: Add your control notification handler code here
	TRACKHEADSECT TrackHeadSect[4];
	char TmpStr[100];

	DWORD NumSel = m_BadList.GetSelectedCount();
	if(NumSel != 4){
		AfxMessageBox("Select 4 items to copy protect!");
		return;
	}
	POSITION ps = m_BadList.GetFirstSelectedItemPosition();
	for(int i=0; i<4; i++){
		WORD ItemSel = m_BadList.GetNextSelectedItem(ps);
		m_BadList.GetItemText(ItemSel, 0, (char *) &TmpStr, 50);
		TrackHeadSect[i].Track = atoi(TmpStr);
		m_BadList.GetItemText(ItemSel, 1, (char *) &TmpStr, 50);
		TrackHeadSect[i].Head = atoi(TmpStr);
		m_BadList.GetItemText(ItemSel, 2, (char *) &TmpStr, 50);
		TrackHeadSect[i].Sector = atoi(TmpStr);
	}
	LPBYTE Cprot = (LPBYTE) BootPtr;
	Cprot[0] = 0xEB;
	Cprot[1] = 0xFE;
	Cprot[508] = 'V';	//Vinoj Copy protect
	Cprot[509] = 'C';	//C for Copy protect
	for(i=0; i<4; i++){
		Cprot[496+i*3] = TrackHeadSect[i].Track;
		Cprot[497+i*3] = TrackHeadSect[i].Head;
		Cprot[498+i*3] = TrackHeadSect[i].Sector;
	}
	if(!(DllThunk32Write)(Drive, 0, 0, 1, 1, Cprot)){		//Read the boot record
		AfxMessageBox("Copy Protection failed in the floppy, as boot record is not accessible!");
		return;
	}
}
