// Syntax.h: interface for the LSyntax* classes.
//

#if !defined(AFX_SYNTAX_H__FDC32FA0_618F_11D1_A95D_00805F6CFD10__INCLUDED_)
#define AFX_SYNTAX_H__FDC32FA0_618F_11D1_A95D_00805F6CFD10__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>				// templates

#define SYN_ERRLOADLIB 2044
#define SYN_ERRINITLIB 2045
#define SYN_ERRPROCADD 2046
#define SYN_ERRALLOC   2047

//////////////////////////////////////////////////////////////////////
// LSyntaxItem

class LSyntaxItem  
{
public:
	WORD		o_wName;			// name resource id
	DWORD		o_dwTextColor;		// text color
	DWORD		o_dwBkgdColor;		// background color
	LONG		o_lfWeight;			// font weight
	BYTE		o_lfItalic;			// italic
	BYTE		o_lfUnderline;		// underline
	BYTE		o_lfStrikeOut;		// strike out
	BOOL		o_bUppercase;		// uppercase

	CBrush		*m_pTextBrush;		// text brush
	CPen		*m_pPen;			// triangles pen
	DWORD		m_dwFont;			// font signature

	CFont		*m_pFont;			// font
	int			m_nyChar;			// character height
	int			m_nyLead;			// external leading
	int			m_nxOverhang;		// overhang
	int			m_nxDot;			// dot character width
	int			m_nxBlank;			// blank character width
	int			m_nxParagraph;		// paragraph character width
	int			m_nx[256];			// character widths

public:
	LSyntaxItem();
	virtual ~LSyntaxItem();

	/*======================================================================*/
	/* Dedicated pGetSyntax constructor										*/
	/*======================================================================*/

	LSyntaxItem(
		WORD	wName,					// name resource id
		DWORD	dwTextColor,			// text color
		DWORD	dwBkgdColor,			// background color
		LONG	lfWeight,				// font weight
		BYTE	lfItalic				// italic
		);

	/*======================================================================*/
	/* Load: load syntax item from registry									*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void Load (
		HKEY hItem					// registry key
		);

	/*======================================================================*/
	/* Store: store syntax item into registry								*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void Store (
		HKEY hItem					// registry key
		);

	/*======================================================================*/
	/* GetWidthArray: get character widths in the ascii range				*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void GetWidthArray (
		CDC* pDC,					// display context
		TEXTMETRIC* ptm				// text metrics
		);
};

//////////////////////////////////////////////////////////////////////
// LSyntax

class LSyntax  
{
public:
	CString		o_csName;			// syntax library name
	CString		o_csFile;			// syntax library file
	CString		o_csTypes;			// file types handled
	HINSTANCE	m_hHan;				// syntax library handle
	int			m_nHan;				// syntax handle
	FARPROC		m_pInitSyntax;		// InitSyntax address
	FARPROC		m_pGetSyntax;		// GetSyntax address
	FARPROC		m_pGetToken;		// GetToken address
	CArray<LSyntaxItem, LSyntaxItem&> o_SIA; // syntax items array
	DWORD		o_dwShading;		// shading delta for nesting levels

	CString		o_csFont;			// font name
	BYTE		o_lfCharSet;		// character set
	int			o_nSize;			// size
	LONG		o_lfWeight;			// weight
	BYTE		o_lfItalic;			// italic
	BYTE		o_lfUnderline;		// underline
	BYTE		o_lfStrikeOut;		// strike out
	BOOL		m_bTrueType;		// font is true type
	int			m_nxChar;			// average char width
	int			m_nyChar;			// average char height

	CString		o_csPFont;			// printer font name
	BYTE		o_lfPCharSet;		// character set
	int			o_nPSize;			// size
	LONG		o_lfPWeight;		// weight
	BYTE		o_lfPItalic;		// italic
	BYTE		o_lfPUnderline;		// underline
	BYTE		o_lfPStrikeOut;		// strike out
	BOOL		o_bMirror;			// mirror screen font

public:
	LSyntax();
	virtual ~LSyntax();
	LSyntax (LSyntax&);
	void operator= (LSyntax&);
	void Copy (LSyntax*);
	LSyntaxItem GetAt (int n) { return o_SIA.GetAt (n); }
	BOOL IsTrueType (void) { return m_bTrueType; }
	BOOL IsItalic (void) { return o_lfItalic; }

	/*======================================================================*/
	/* Load: load syntax from registry										*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void Load (
		HKEY hSyntax				// registry key
		);

	/*======================================================================*/
	/* Store: store syntax to registry										*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void Store (
		HKEY hSyntax				// registry key
		);

	/*======================================================================*/
	/* FreeResources: free syntax resources									*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	void FreeResources (
		void						// no argument
		);

	/*======================================================================*/
	/* AllocateResources: allocate syntax resources							*/
	/* return:																*/
	/*		0						// ok									*/
	/*		SYN_ERRLOADLIB			// could not load library				*/
	/*		SYN_ERRPROCADD			// library procedure not found			*/
	/*		SYN_ERRALLOC			// memory allocation error				*/
	/*======================================================================*/

	int AllocateResources (
		DWORD dwTextColor,			// default text color
		DWORD dwBkgdColor,			// default background color
		CDC* pDC					// display context
		);

	/*======================================================================*/
	/* AllocatePrintResources: allocate printer syntax resources			*/
	/* return:																*/
	/*		0						// ok									*/
	/*		SYN_ERRLOADLIB			// could not load library				*/
	/*		SYN_ERRPROCADD			// library procedure not found			*/
	/*		SYN_ERRALLOC			// memory allocation error				*/
	/*======================================================================*/

	int AllocatePrintResources (
		DWORD dwTextColor,			// default text color
		DWORD dwBkgdColor,			// default background color
		CDC* pDC					// display context
		);

	/*======================================================================*/
	/* Reset: reset syntax attributes										*/
	/* return:																*/
	/*		TRUE					// success								*/
	/*		FALSE					// failure								*/
	/*======================================================================*/

	BOOL Reset (
		DWORD dwTextColor,			// default text color
		DWORD dwBkgdColor			// default background color
		);

	/*======================================================================*/
	/* UpdateResources: change brushes and fonts							*/
	/* return:																*/
	/*		TRUE					// ok									*/
	/*		FALSE					// ko - new operator failure			*/
	/*======================================================================*/

	BOOL UpdateResources (
		void						// no argument
		);
};

typedef int (*INITPROC) (int, LPCTSTR);
typedef void (*GETPROC) (int, LPCTSTR, LPCTSTR, HKEY);

//////////////////////////////////////////////////////////////////////
// LSyntaxArray

class LSyntaxArray  
{
public:
	DWORD		o_dwTextColor;		// text color
	DWORD		o_dwBkgdColor;		// background color
	CArray<LSyntax, LSyntax&> o_SA;	// syntax array

public:
	LSyntaxArray();
	virtual ~LSyntaxArray();
	int GetCount (void) { return o_SA.GetUpperBound() + 1; }
	LSyntax GetAt (int n) { return o_SA.GetAt (n); }

	/*======================================================================*/
	/* Load: load syntax array from registry								*/
	/* return:																*/
	/*		void															*/
	/*======================================================================*/

	BOOL Load (
		DWORD& dwTextColor,			// default text color
		DWORD& dwBkgdColor,			// default background color
		LPCTSTR szSyntKey			// key to load from
		);

	/*======================================================================*/
	/* Store: store syntax array into registry								*/
	/* return:																*/
	/*		TRUE					// success								*/
	/*		FALSE					// failure								*/
	/*======================================================================*/

	void Store (
		DWORD dwTextColor,			// default text color
		DWORD dwBkgdColor,			// default background color
		LPCTSTR szSyntKey,			// key to store to
		BOOL bFlush					// flush to registry
		);

	/*======================================================================*/
	/* AddSyntax: add syntax to syntax list									*/
	/*		0						// ok									*/
	/*		SYN_ERRLOADLIB			// could not load library				*/
	/*		SYN_ERRPROCADD			// library procedure not found			*/
	/*		SYN_ERRALLOC			// memory allocation error				*/
	/*======================================================================*/

	int AddSyntax (
		LPCTSTR	lpszName,			// file name
		DWORD dwTextColor,			// default text color
		DWORD dwBkgdColor,			// default background color
		HKEY hSyntKey				// syntax key
		);

	/*======================================================================*/
	/* FindSyntax: find syntax based on file type							*/
	/* return:																*/
	/*		LSyntax&				// syntax reference found				*/
	/*======================================================================*/

	LSyntax* FindSyntax (
		LPCTSTR lpszName				// file name whose syntax is to be seeked
		);
};

#endif // !defined(AFX_SYNTAX_H__FDC32FA0_618F_11D1_A95D_00805F6CFD10__INCLUDED_)
