#ifndef NumberRule_Hdr
#define NumberRule_Hdr

#include "RuleStatus.h"

/*======================================================================*/
/* class NumberRule														*/
/*======================================================================*/

class NumberRule
{
public:
	virtual				~NumberRule() = 0;

	int					getTokenLength (LPCTSTR text, int maxLength);

	virtual	bool		getNextLength (LPCTSTR text,
									int maxLength,
									int& tokenLength,
									RuleStatus status) = 0;

	static	NumberRule*	createRule (LPTSTR allRules);
	static	NumberRule*	createRule (LPCTSTR& ruleDefinition, LPTSTR allRules);
	static	NumberRule*	getRuleByName (LPCTSTR& ruleString, LPTSTR allRules);
};

/*======================================================================*/
/* NumberRulePtrArray - array of pointers to NumberRule					*/
/*======================================================================*/

typedef CTypedPtrArray <CPtrArray, NumberRule*> NumberRulePtrArray;

/*======================================================================*/
/* OrRule																*/
/*	- handles (..|..) constructs										*/
/*======================================================================*/

class OrRule: public NumberRule
{
public:
	virtual				~OrRule();

	void				addAlternative (NumberRule* alternative);

	virtual	bool		getNextLength (LPCTSTR text,
									int maxLength,
									int& tokenLength,
									RuleStatus status);
protected:
	NumberRulePtrArray	alternatives;
};

/*======================================================================*/
/* SequenceRule															*/
/*	- handles sequences of rules										*/
/*======================================================================*/

class SequenceRule: public NumberRule
{
public:
	virtual				~SequenceRule();

	void				addRule (NumberRule* numberRule);
	NumberRule*			removeRule (int idx);
	int					getRulesCount (void) const;

	virtual	bool		getNextLength (LPCTSTR text, int maxLength, int& tokenLength, RuleStatus status);

	void				processDefinition (LPCTSTR& ruleDefinition, LPTSTR allRules);
protected:
	NumberRulePtrArray	sequence;
};

/*======================================================================*/
/* RangeRule															*/
/*	- handles [...] constructs, as well as single char constructs		*/
/*======================================================================*/

class RangeRule: public NumberRule
{
public:
						RangeRule (LPCTSTR _validChars);
						RangeRule (TCHAR validChar);
	virtual				~RangeRule();

	virtual	bool		getNextLength (LPCTSTR text,
									int maxLength,
									int& tokenLength,
									RuleStatus status);

	static	LPCTSTR	getRangeChars( LPCTSTR& ruleDefinition );

protected:
	char*				validChars;
};

/*======================================================================*/
/* RangeRule															*/
/*	- handles zero or more(*), one or more(+) and optional({..})		*/
/*======================================================================*/

class IterationRule: public NumberRule
{
public:
						IterationRule (int _minIterationCount,
									   int _maxIterationCount,
									   NumberRule* _rule);

	virtual				~IterationRule();

	virtual	bool		getNextLength (LPCTSTR text,
									int maxLength,
									int& tokenLength,
									RuleStatus status);
protected:

	int					minIterationCount;
	int					maxIterationCount;
	NumberRule*			rule;
};

#endif // NumberRule_Hdr
