/* *********************************************************************
   ChkWord.Cpp
   Function has as input a word. Returns TRUE or FALSE (1 or 0)
   N.B. Dictionary data is buit in.
  ******************************************************************** */
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include "wordlist.cmp"
int chkword (char * wordv){
   const int TRUE  = 1;
   const int FALSE = 0;
   int ii,jj, inx ;
   const int MAX_STR = 33;  // maximum string size.
   char new_word [MAX_STR+1] = "";
   int size_w = strlen (wordv);
   if (size_w == 0) return TRUE;
   if (size_w > MAX_STR) return FALSE;
   if (size_w == 0) return FALSE;
   ii = wordv[0] - 'a';
   jj = wordv[1] - 'a';
   if (ii < 0 || ii > 25) return FALSE;
   if (jj < 0 || jj > 25) return FALSE;
   // test for valid single letters
   if (size_w == 1){
      if (dic_one_let [ii]){
         return TRUE;
      }
      else {
         return FALSE;
      }
   }
   // compute index
   inx = ii*26 + jj;
   int index1  = dic_data_idx [inx];
   int index2 = dic_data_idx [inx+1];
   int i_siz  = index2 - index1;
   if (i_siz == 0) return FALSE;
   int idx = index1;
   for (;idx < index2;idx++){
      int item = dic_data_buf [idx];
      int num_same = item & 07; // 3 bit field.
      int wrd_size = item /8; // 5 bit field
      for (int yy = num_same; yy < wrd_size;yy++){
         new_word[yy] = dic_data_buf[++idx];
      }
      new_word [wrd_size] = 0;
      int eql;
      if ((eql = strcmp (&wordv[2], new_word))==0) return TRUE;
      if (eql < 0) return FALSE;
   }
   return FALSE;
}
