// Search.h : header file for CHexFindDialog and its CCustEdit (edit control)
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

/////////////////////////////////////////////////////////////////////////////
// CCustEdit control

class CCustEdit : public CEdit
{
// Construction
public:
	CCustEdit();

// Attributes
public:

// Operations
public:
    void normalize_hex();
    void text2hex(int);
    void hex2text(int tt = 1);
    void ascii2ebcdic();
    void ascii2unicode();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCustEdit)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCustEdit();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCustEdit)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CCustRadio window

class CCustRadio : public CButton
{
// Construction
public:
	CCustRadio();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCustRadio)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCustRadio();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCustRadio)
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CHexFindDialog dialog

class CHexFindDialog : public CFindReplaceDialog
{
// Construction
public:
	CHexFindDialog();   // standard constructor

// Operations
    void update_controls(int down = -1, BOOL keep_hex=FALSE);
    void set_hex() ;

// Dialog Data
	//{{AFX_DATA(CHexFindDialog)
	enum { IDD = IDD_FIND };
	int		find_type_;
	//}}AFX_DATA

// Controls
	CCustEdit edit_;
	CCustRadio radio_hex_;
	CCustRadio radio_ascii_;
	CCustRadio radio_unicode_;
	CCustRadio radio_ebcdic_;
	bool from_edit_;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHexFindDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CHexFindDialog)
	afx_msg void OnFindHex();
	afx_msg void OnFindAscii();
	afx_msg void OnFindEbcdic();
	afx_msg void OnFindUnicode();
	afx_msg void OnEditchangeCombo();
	virtual void OnOK();
	afx_msg void OnSelchangeCombo();
	afx_msg void OnDestroy();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
