#define STRICT
#define NOTREEVIEW
#define NOIMAGEAPIS
#include <windows.h>
#include <stdio.h>
#include <commctrl.h>

UINT CALLBACK OFNHookProc1(HWND, UINT, WPARAM, LPARAM);
UINT CALLBACK OFNHookProc2(HWND, UINT, WPARAM, LPARAM);

extern HANDLE       hFile;
HANDLE              hMapFile;
OPENFILENAME        ofn;
int                 iFileLength, numLines;
unsigned char       *c;
extern int          xCaret, yCaret, xCaretCount, t1;
DWORD               dwSize;
extern BOOL         bFind;
extern HWND         hStatusWindow;
char                szSbFileSize[20];

void HexFileInitialize (HWND hwnd)
     {
     ZeroMemory(&ofn, sizeof(ofn));
     
     ofn.lStructSize       = sizeof (OPENFILENAME);
     ofn.hwndOwner         = hwnd;
     ofn.hInstance         = NULL;
     ofn.lpstrFilter       = NULL;
     ofn.lpstrCustomFilter = NULL;
     ofn.nMaxCustFilter    = 0;
     ofn.nFilterIndex      = 0;
     ofn.lpstrFile         = NULL;         
     ofn.nMaxFile          = _MAX_PATH;
     ofn.lpstrFileTitle    = NULL;         
     ofn.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT;
     ofn.lpstrInitialDir   = NULL;
     ofn.lpstrTitle        = NULL;
     ofn.Flags             = 0;            
     ofn.nFileOffset       = 0;
     ofn.nFileExtension    = 0;
     ofn.lpstrDefExt       = NULL;
     ofn.lCustData         = 0L;
     ofn.lpfnHook          = NULL;
     ofn.lpTemplateName    = NULL;
     }

BOOL HexFileOpenDlg (HWND hwnd, PSTR pstrFileName, PSTR pstrTitleName)
     {
     static char szFilter[] = "All Files (*.*)\0*.*\0\0";
     ofn.hwndOwner          = hwnd;
     ofn.lpstrTitle         = "Open";
     ofn.lpstrFile          = pstrFileName;
     ofn.lpstrFileTitle     = pstrTitleName;
     ofn.lpstrFilter        = szFilter;
     ofn.lpfnHook           = OFNHookProc1;
     ofn.Flags              = OFN_ENABLEHOOK|OFN_EXPLORER|OFN_FILEMUSTEXIST;

     return GetOpenFileName (&ofn);
     }

BOOL HexFileExportDlg (HWND hwnd, PSTR pstrFileName, PSTR pstrTitleName)
     {
     static char szFilter[] = "Text (*.txt)\0*.txt\0"
                               "Doc (*.doc)\0*.doc\0\0";
     ofn.hwndOwner          = hwnd;
     ofn.lpstrTitle         = "Export As";
     ofn.lpstrFile          = pstrFileName;
     ofn.lpstrFileTitle     = pstrTitleName;
     ofn.lpstrFilter        = szFilter;
     ofn.lpfnHook           = OFNHookProc2;
     ofn.Flags              = OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|
                              OFN_ENABLEHOOK|OFN_EXPLORER;
     
     return GetSaveFileName (&ofn);
     }

BOOL HexFileSaveDlg (HWND hwnd, PSTR pstrFileName, PSTR pstrTitleName)
     {
     static char szFilter[] = "All Files (*.*)\0*.*\0\0";
     ofn.hwndOwner          = hwnd;
     ofn.lpstrTitle         = "Save As";
     ofn.lpstrFile          = pstrFileName;
     ofn.lpstrFileTitle     = pstrTitleName;
     ofn.lpstrFilter        = szFilter;
     ofn.Flags              = OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY|
                              OFN_EXPLORER;
     
     return GetSaveFileName (&ofn);
     }

BOOL HexFileRead (HWND hwndChild, PSTR pstrFileName)
     {
     numLines = 0;
     if (c != NULL) { UnmapViewOfFile(c); }
     HideCaret(hwndChild);
     SendMessage (hwndChild, WM_SIZE, 0, 0);

     if (NULL == (hFile = CreateFile(pstrFileName,GENERIC_READ,
        FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,NULL)))
        { return FALSE; }

     iFileLength = GetFileSize(hFile, NULL);
     if (iFileLength%16 >= 1) { numLines = (iFileLength/16)+2; }
     if (iFileLength%16 == 0) { numLines = (iFileLength/16)+1; }
  
     if (NULL == (hMapFile = CreateFileMapping(hFile,NULL,PAGE_WRITECOPY,0,0,NULL)))
        { CloseHandle(hFile); return FALSE; }

     if (NULL == (c = MapViewOfFile(hMapFile,FILE_MAP_COPY,0,0,0)))
        { CloseHandle(hMapFile); return FALSE; }

     SetCursor(LoadCursor (NULL, IDC_WAIT));
     ShowCursor(TRUE);
     CloseHandle(hFile);
     CloseHandle(hMapFile);
     bFind=FALSE;
     SendMessage (hwndChild, WM_SIZE, 0, 0);
     wsprintf(szSbFileSize, "%lu Bytes", iFileLength);
     SendMessage (hStatusWindow, SB_SETTEXT, 2 | 0, (LPARAM) szSbFileSize);
     InvalidateRect(hwndChild, NULL, TRUE);
     UpdateWindow(hwndChild);
     ShowCursor(FALSE);
     SetCursor(LoadCursor (NULL, IDC_ARROW));
     ShowCaret(hwndChild);
     t1=-1;
     return TRUE;
     }

BOOL HexFileWrite (HWND hwndChild, PSTR pstrFileName)
     {
     char                szBuffer3[68];
     unsigned int        iHex2=0;
     int                 t=0, a, i;

     HideCaret(hwndChild);
     if (NULL == (hFile = CreateFile(pstrFileName,GENERIC_WRITE,FILE_SHARE_WRITE,
         NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL))) { return FALSE; }

     SetCursor(LoadCursor (NULL, IDC_WAIT));
     ShowCursor(TRUE);

     for (i=0;i<numLines-2;i++) {
     wsprintf(szBuffer3, "%08lX: %02X%02X %02X%02X %02X%02X %02X%02X %02X%02X"
     " %02X%02X %02X%02X %02X%02X %hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc",
     iHex2, c[t], c[t+1], c[t+2], c[t+3], c[t+4], c[t+5], c[t+6], c[t+7], c[t+8], c[t+9],
     c[t+10], c[t+11], c[t+12], c[t+13], c[t+14], c[t+15], c[t], c[t+1], c[t+2], c[t+3],
     c[t+4], c[t+5], c[t+6], c[t+7], c[t+8], c[t+9], c[t+10], c[t+11], c[t+12], c[t+13],
     c[t+14], c[t+15]);

     for (a=50;a<66;a++) { if (szBuffer3[a] < 32 || szBuffer3[a] >= 127) { szBuffer3[a]=46; } }

     szBuffer3[66]='\r';
     szBuffer3[67]='\n';
     WriteFile(hFile, szBuffer3, 68, &dwSize, NULL);
     t+=16;
     iHex2+=16;
     }

     wsprintf(szBuffer3, "%08lX: %02X%02X %02X%02X %02X%02X %02X%02X %02X%02X"
     " %02X%02X %02X%02X %02X%02X %hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc%hc",
     iHex2, c[t], c[t+1], c[t+2], c[t+3], c[t+4], c[t+5], c[t+6], c[t+7], c[t+8], c[t+9],
     c[t+10], c[t+11], c[t+12], c[t+13], c[t+14], c[t+15], c[t], c[t+1], c[t+2], c[t+3],
     c[t+4], c[t+5], c[t+6], c[t+7], c[t+8], c[t+9], c[t+10], c[t+11], c[t+12], c[t+13],
     c[t+14], c[t+15]);

     for (a=50;a<66;a++) {
       if (szBuffer3[a] < 32 || szBuffer3[a] >= 127) { szBuffer3[a]=46; } }
     if (iFileLength%16 >= 1 && iFileLength%16 <= 2) {
       for (a=10+(iFileLength%16)*2;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 3 && iFileLength%16 <= 4) {
       for (a=10+(iFileLength%16)*2+1;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 5 && iFileLength%16 <= 6) {
       for (a=10+(iFileLength%16)*2+2;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 7 && iFileLength%16 <= 8) {
       for (a=10+(iFileLength%16)*2+3;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 9 && iFileLength%16 <= 10) {
       for (a=10+(iFileLength%16)*2+4;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 11 && iFileLength%16 <= 12) {
       for (a=10+(iFileLength%16)*2+5;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 >= 13 && iFileLength%16 <= 14) {
       for (a=10+(iFileLength%16)*2+6;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 == 15) {
       for (a=10+(iFileLength%16)*2+7;a<49;a++) { szBuffer3[a]=' '; } }
     if (iFileLength%16 != 0) {
       for (a=50+(iFileLength%16);a<66;a++) { szBuffer3[a]=' '; } }

     szBuffer3[66]='\r';
     szBuffer3[67]='\n';
     WriteFile(hFile, szBuffer3, 68, &dwSize, NULL);

     CloseHandle(hFile);
     ShowCursor(FALSE);
     SetCursor(LoadCursor (NULL, IDC_ARROW));
     MessageBeep(0);
     ShowCaret(hwndChild);
     return TRUE ;
     }

BOOL HexFileSave (HWND hwndChild, PSTR pstrFileName)
   {

     if (NULL == (hFile = CreateFile(pstrFileName,GENERIC_WRITE,FILE_SHARE_WRITE|
        FILE_SHARE_READ,NULL,OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL)))
        { return FALSE; }

     if (0 == (WriteFile(hFile,c,iFileLength,&dwSize,NULL))) {
         MessageBox(GetParent(hwndChild),"File write sharing violation!",
         "Hexiwin",MB_OK|MB_ICONERROR);
     }
     CloseHandle(hFile);
     InvalidateRect(hwndChild, NULL, TRUE);
     UpdateWindow(hwndChild);

   return TRUE;
   }

UINT CALLBACK OFNHookProc1(HWND hldg, UINT message, WPARAM wParam, LPARAM lParam)
   {

   switch (message)
        {
        case WM_INITDIALOG:
             ofn.lpstrFile[ofn.nFileOffset]='*';
             ofn.lpstrFile[ofn.nFileOffset+1]='.';
             ofn.lpstrFile[ofn.nFileOffset+2]='*';
             ofn.lpstrFile[ofn.nFileOffset+3]='\0';              
      
        return 0;

        case WM_COMMAND:
             break;

        default:
             return 0;   
        }
   return 0;
   }

UINT CALLBACK OFNHookProc2(HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam)
   {
HWND edit;

   switch (message)
        {
        case WM_INITDIALOG:
             if (ofn.nFileExtension == 0) {
               ofn.lpstrFile[ofn.nFileOffset]='*';
               ofn.lpstrFile[ofn.nFileOffset+1]='.';
               ofn.lpstrFile[ofn.nFileOffset+2]='*';
               ofn.lpstrFile[ofn.nFileOffset+3]='\0';
             }
              
             if (ofn.nFilterIndex == 1 && ofn.nFileExtension > 0) {
               ofn.lpstrFile[ofn.nFileExtension]='t';
               ofn.lpstrFile[ofn.nFileExtension+1]='x';
               ofn.lpstrFile[ofn.nFileExtension+2]='t';
               ofn.lpstrFile[ofn.nFileExtension+3]='\0';
             }

             return 0;

        case WM_COMMAND:
             break;

        case WM_NOTIFY:  
             if( (((LPOFNOTIFY)lParam)->hdr).code == CDN_TYPECHANGE) {
           
             if (ofn.nFilterIndex == 1 && ofn.nFileExtension > 0) {
               ofn.lpstrFile[ofn.nFileExtension]='t';
               ofn.lpstrFile[ofn.nFileExtension+1]='x';
               ofn.lpstrFile[ofn.nFileExtension+2]='t';
               ofn.lpstrFile[ofn.nFileExtension+3]='\0';
             }

             if (ofn.nFilterIndex == 2 && ofn.nFileExtension > 0) { 
               ofn.lpstrFile[ofn.nFileExtension]='d';
               ofn.lpstrFile[ofn.nFileExtension+1]='o';
               ofn.lpstrFile[ofn.nFileExtension+2]='c';
               ofn.lpstrFile[ofn.nFileExtension+3]='\0';                                                                         
             }
            
             edit = GetParent(hdlg);
             SetDlgItemText (edit, edt1, ofn.lpstrFile+ofn.nFileOffset);
             }
             return 0;
        default:
             return 0;
        }
        return 0;
   }