/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GAddVertexDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "addvertex.gif";
    public static final Dimension ICONDIM = new Dimension(62, 50);
    private GSolid solid;
    private GNotepad notepad;
    private TextField[] crd;
    private TextField assignedLabel;
    private GButton getOneButton;
    private String defaultLabel;

    public GAddVertexDialog(GFrame gFrame, GProblem gProblem, GNotepad gNotepad, GSolid gSolid, GPoint3D gPoint3D) {
        super(gFrame, "Add vertex to Solid " + gSolid.getLabel());
        this.notepad = gNotepad;
        this.solid = gSolid;
        this.helpTopic = "add vertex";
        this.defaultLabel = gProblem.supplyLabel();
        this.crd = new TextField[3];
        int n = 0;
        while (n < 3) {
            this.crd[n] = new TextField(5);
            this.crd[n].setFont(gFrame.numberFont);
            ++n;
        }
        if (gPoint3D != null) {
            ((TextComponent)this.crd[0]).setText(String.valueOf(gPoint3D.X));
            ((TextComponent)this.crd[1]).setText(String.valueOf(gPoint3D.Y));
            ((TextComponent)this.crd[2]).setText(String.valueOf(gPoint3D.Z));
        }
        this.assignedLabel = new TextField(3);
        this.assignedLabel.setFont(gFrame.numberFont);
        this.getOneButton = new GButton("Get One");
        this.getOneButton.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridheight = 1;
        Label label = new Label("X coord:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        Label label2 = new Label("Y coord:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        Label label3 = new Label("Z coord:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.crd[0], gridBagConstraints);
        this.dataPanel.add(this.crd[0]);
        gridBagLayout.setConstraints(this.crd[1], gridBagConstraints);
        this.dataPanel.add(this.crd[1]);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.crd[2], gridBagConstraints);
        this.dataPanel.add(this.crd[2]);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        Label label4 = new Label("Assign label:");
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.dataPanel.add(label4);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.assignedLabel, gridBagConstraints);
        this.dataPanel.add(this.assignedLabel);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.getOneButton, gridBagConstraints);
        this.getOneButton.setFont(GDialog.buttonFont);
        this.dataPanel.add(this.getOneButton);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        Object object;
        Object object2;
        if (this.assignedLabel.getText().equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "No label assigned to vertex");
            return false;
        }
        double[] dArray = new double[3];
        int n = 0;
        while (n < 3) {
            object2 = this.crd[n].getText().trim();
            object = this.notepad.seekDoubleObject((String)object2);
            if (object == null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Wrong number format or incorrect variable reference: " + (String)object2);
                return false;
            }
            dArray[n] = object instanceof GVariable ? ((GVariable)object).getValue() : ((Double)object).doubleValue();
            ++n;
        }
        object2 = new GPoint3D(dArray[0], dArray[1], dArray[2]);
        object = this.solid.addVertex((GPoint3D)object2, this.assignedLabel.getText());
        if (object instanceof String) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", (String)object);
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.getOneButton) {
            if (this.defaultLabel == null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "No more labels available");
                return;
            }
            ((TextComponent)this.assignedLabel).setText(this.defaultLabel);
        }
    }
}

