/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GAngleDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "angle.gif";
    public static final Dimension ICONDIM = new Dimension(80, 79);
    private TextField[] p;
    private TextField number;
    private TextField varName;
    private GButton writeDown;
    private GSolid solid;
    private GSolidCanvas canvas;
    private GNotepad notepad;
    private boolean wasMeasured;
    private GVariable varWrittenDown;
    private double angleValue;
    private String[] labels;

    public GAngleDialog(GFrame gFrame, GNotepad gNotepad) {
        super(gFrame, "Measure Angle");
        this.notepad = gNotepad;
        this.helpTopic = "measure angle";
        this.labels = new String[3];
        this.p = new TextField[3];
        int n = 0;
        while (n < 3) {
            this.p[n] = new TextField(3);
            this.p[n].setFont(gFrame.labelFont);
            ++n;
        }
        this.number = new TextField(7);
        this.number.setFont(gFrame.numberFont);
        this.number.setEditable(false);
        this.varName = new TextField(5);
        this.varName.setFont(gFrame.labelFont);
        this.writeDown = new GButton("Write Down");
        this.writeDown.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Measure the angle labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.insets.left = 5;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        gridBagConstraints.anchor = 16;
        gridBagLayout.setConstraints(this.p[2], gridBagConstraints);
        this.dataPanel.add(this.p[2]);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridwidth = 1;
        this.okButton.setLabel("Measure");
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.dataPanel.add(this.okButton);
        gridBagConstraints.insets.left = 5;
        Label label2 = new Label("Result:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.number, gridBagConstraints);
        this.dataPanel.add(this.number);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label3 = new Label("Assign variable:", 0);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.writeDown, gridBagConstraints);
        this.writeDown.setFont(GDialog.buttonFont);
        this.dataPanel.add(this.writeDown);
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.labels[0].toUpperCase(), this.labels[1].toUpperCase(), this.labels[2].toUpperCase(), this.varWrittenDown};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
        ((TextComponent)this.p[2]).setText((String)objectArray[2]);
        this.varWrittenDown = (GVariable)objectArray[3];
    }

    protected boolean onOk() {
        if (this.wasMeasured) {
            return true;
        }
        int n = 0;
        while (n < 3) {
            this.labels[n] = this.p[n].getText().toUpperCase();
            ++n;
        }
        if (this.labels[0].equals("") || this.labels[1].equals("") || this.labels[2].equals("") || this.labels[0].equals(this.labels[1]) || this.labels[0].equals(this.labels[2])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Angle improperly referenced");
            return false;
        }
        Object object = this.solid.measureAngle(this.labels, true);
        if (object instanceof String) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Measure Failed", (String)object);
        } else {
            this.wasMeasured = true;
            this.okButton.setEnabled(false);
            this.canvas.repaint();
            this.angleValue = (Double)object;
            ((TextComponent)this.number).setText(String.valueOf((float)this.angleValue));
            this.number.select(0, GMath.leadingDigits(this.angleValue));
        }
        return false;
    }

    public boolean set(GSolid gSolid, GSolidCanvas gSolidCanvas, int n, Object[] objectArray) {
        this.solid = gSolid;
        this.canvas = gSolidCanvas;
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Measure Angle in Solid " + gSolid.getLabel());
            GEdgeList gEdgeList = gSolid.getSelectedEdges().renderToAngle();
            if (gEdgeList != null) {
                GEdgeNode gEdgeNode = gEdgeList.getHead();
                GEdge gEdge = gEdgeNode.getEdge();
                GEdge gEdge2 = gEdgeNode.getNext().getEdge();
                String string = gEdge.getHead().getLabel();
                String string2 = gEdge.getTail().getLabel();
                String string3 = gEdge2.getHead().getLabel();
                String string4 = gEdge2.getTail().getLabel();
                if (string.equals(string3)) {
                    ((TextComponent)this.p[0]).setText(string);
                    ((TextComponent)this.p[1]).setText(string2);
                    ((TextComponent)this.p[2]).setText(string4);
                } else if (string.equals(string4)) {
                    ((TextComponent)this.p[0]).setText(string);
                    ((TextComponent)this.p[1]).setText(string2);
                    ((TextComponent)this.p[2]).setText(string3);
                } else if (string2.equals(string3)) {
                    ((TextComponent)this.p[0]).setText(string2);
                    ((TextComponent)this.p[1]).setText(string);
                    ((TextComponent)this.p[2]).setText(string4);
                } else if (string2.equals(string4)) {
                    ((TextComponent)this.p[0]).setText(string2);
                    ((TextComponent)this.p[1]).setText(string);
                    ((TextComponent)this.p[2]).setText(string3);
                }
            }
        }
        if (n == 0) {
            this.show();
        } else if (n == 1) {
            this.onOk();
            if (!this.wasMeasured) {
                return false;
            }
            this.show();
        } else if (n == 2) {
            this.onOk();
            if (objectArray[3] != null) {
                this.actionPerformed(new ActionEvent(this.writeDown, 0, null));
            }
        }
        return this.wasMeasured;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.writeDown && this.wasMeasured) {
            String string;
            String string2 = this.varName.getText().trim();
            if (this.varWrittenDown == null) {
                string = GVariable.checkName(string2);
                if (string != null) {
                    new GAlertDialog(GDialog.frame, "warn.gif", "Invalid Variable", string);
                    return;
                }
                this.varWrittenDown = new GVariable(string2, this.angleValue);
            }
            string = this.labels[0];
            this.labels[0] = this.labels[1];
            this.labels[1] = string;
            if (!this.notepad.add(this.varWrittenDown, this.labels, this.solid, 0)) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA Notepad", "Variable " + string2 + " in use");
                this.varWrittenDown = null;
                return;
            }
            ((Component)this).setVisible(false);
        }
    }
}

