/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GCalculator
implements ActionListener {
    private static final char[] ALLOPS = new char[]{'^', '*', '/', '+', '-'};
    private GFrame frame;
    public TextField awtField;
    private GProblem problem;
    private GNotepad notepad;
    private GVariableList variables;
    private int varCount;

    public GCalculator(int n, GFrame gFrame, GNotepad gNotepad) {
        this.awtField = new TextField(n);
        this.frame = gFrame;
        this.notepad = gNotepad;
        this.awtField.setFont(gFrame.numberFont);
    }

    public void flush() {
        ((TextComponent)this.awtField).setText("");
    }

    public void setProblem(GProblem gProblem) {
        this.problem = gProblem;
    }

    protected boolean checkChars(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '^' || c == '*' || c == '/' || c == '+' || c == '-' || c == '(' || c == ')' || c == ' ')) {
                this.awtField.select(n, n + 1);
                new GAlertDialog(this.frame, "warn.gif", "Syntax error", "Invalid character in expression");
                this.awtField.requestFocus();
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean checkParensMatching(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '(') {
                ++n;
            }
            if (c == ')') {
                --n;
            }
            if (n < 0) {
                this.unmatchedParens(n3);
                return false;
            }
            if (n == 1 && c == '(') {
                n2 = n3;
            }
            ++n3;
        }
        if (n > 0) {
            this.unmatchedParens(n2);
            return false;
        }
        return true;
    }

    protected void unmatchedParens(int n) {
        this.awtField.select(n, n + 1);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "Unmatched parenthesis");
        this.awtField.requestFocus();
    }

    protected String canonize(String string) {
        int n;
        string = string.trim();
        while ((n = string.indexOf(32)) >= 0) {
            string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
        }
        if (string.charAt(0) == '-') {
            string = "0" + string;
        }
        while ((n = string.indexOf("(-")) >= 0) {
            string = String.valueOf(string.substring(0, n + 1)) + "0" + string.substring(n + 1);
        }
        return string;
    }

    protected GVariableList checkRegions(String string) {
        string = "(" + string + ")";
        GVariableList gVariableList = new GVariableList();
        int n = 0;
        int n2;
        while ((n2 = this.indexOfDelimeter(string, n + 1)) >= 0) {
            char c = string.charAt(n);
            char c2 = string.charAt(n2);
            if (n2 == n + 1) {
                if (c == '(' && c2 == ')') {
                    this.redundantParens(n - 1, n2);
                    return null;
                }
                if (c == ')' && c2 == '(') {
                    this.missingOp(n - 1, n2);
                    return null;
                }
                if (c != ')' && c2 == ')' || c != '(' && c != ')' && c2 != '(' && c2 != ')') {
                    this.misplacedOp(n - 1);
                    return null;
                }
                if (c == '(' && c2 != '(') {
                    this.misplacedOp(n2 - 1);
                    return null;
                }
            } else {
                String string2 = string.substring(n + 1, n2);
                Object object = this.evalToken(string2);
                if (object != null) {
                    if (object instanceof GVariable) {
                        gVariableList.addToTail((GVariable)object);
                    }
                    if (c == ')') {
                        this.missingOp(n - 1, n2 - 1);
                        return null;
                    }
                    if (c2 == '(') {
                        this.missingOp(n, n2);
                        return null;
                    }
                } else if (this.isFuncName(string2)) {
                    if (c == ')') {
                        this.missingOp(n - 1, n2 - 1);
                        return null;
                    }
                    if (c2 != '(') {
                        this.missingArg(n, n2 - 1, string2);
                        return null;
                    }
                } else {
                    this.badToken(n, n2 - 1);
                    return null;
                }
            }
            n = n2;
        }
        return gVariableList;
    }

    protected boolean isFuncName(String string) {
        return string.equalsIgnoreCase("sqrt") || string.equalsIgnoreCase("cos") || string.equalsIgnoreCase("sin") || string.equalsIgnoreCase("tan") || string.equalsIgnoreCase("asin") || string.equalsIgnoreCase("acos") || string.equalsIgnoreCase("atan");
    }

    protected int indexOf(String string, int n, char[] cArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = string.indexOf(cArray[n3], n);
            if (n4 >= 0) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        if (n2 < Integer.MAX_VALUE) {
            return n2;
        }
        return -1;
    }

    protected int indexOfDelimeter(String string, int n) {
        int n2;
        int n3;
        int n4 = this.indexOf(string, n, ALLOPS);
        if (n4 < 0) {
            n4 = Integer.MAX_VALUE;
        }
        if ((n3 = string.indexOf(40, n)) < 0) {
            n3 = Integer.MAX_VALUE;
        }
        if ((n2 = string.indexOf(41, n)) < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if ((n = Math.min(n4, Math.min(n3, n2))) < Integer.MAX_VALUE) {
            return n;
        }
        return -1;
    }

    protected int lastIndexOf(String string, int n, char[] cArray) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = string.lastIndexOf(cArray[n3], n);
            n2 = Math.max(n2, n4);
            ++n3;
        }
        return n2;
    }

    protected int lastIndexOfDelimeter(String string, int n) {
        int n2 = this.lastIndexOf(string, n, ALLOPS);
        int n3 = string.lastIndexOf(40, n);
        int n4 = string.lastIndexOf(41, n);
        return Math.max(n2, Math.max(n3, n4));
    }

    protected void misplacedOp(int n) {
        this.awtField.select(n, n + 1);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "Misplaced operation sign");
        this.awtField.requestFocus();
    }

    protected void badToken(int n, int n2) {
        this.awtField.select(n, n2);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "Undefined variable, function name or bad number format");
        this.awtField.requestFocus();
    }

    protected void redundantParens(int n, int n2) {
        this.awtField.select(n, n2);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "Redundant parentheses");
        this.awtField.requestFocus();
    }

    protected void missingArg(int n, int n2, String string) {
        this.awtField.select(n, n2);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "No argument given to function " + string);
        this.awtField.requestFocus();
    }

    protected void missingOp(int n, int n2) {
        this.awtField.select(n, n2);
        new GAlertDialog(this.frame, "warn.gif", "Invalid Expression", "Missing operation");
        this.awtField.requestFocus();
    }

    protected void syntaxError() {
        new GAlertDialog(this.frame, "warn.gif", "GEOMETRIA Error", "Syntax error");
        this.awtField.requestFocus();
    }

    protected void sqrtError() {
        new GAlertDialog(this.frame, "warn.gif", "GEOMETRIA Error", "Square root of negative number");
        this.awtField.requestFocus();
    }

    protected void argOutOfBoundsError(String string) {
        new GAlertDialog(this.frame, "warn.gif", "GEOMETRIA Error", "Argument in function " + string + " out of bounds");
        this.awtField.requestFocus();
    }

    protected void negBase() {
        new GAlertDialog(this.frame, "warn.gif", "GEOMETRIA Error", "Negative base in power operation");
        this.awtField.requestFocus();
    }

    protected void zeroDivision() {
        new GAlertDialog(this.frame, "warn.gif", "GEOMETRIA Error", "Division by zero");
        this.awtField.requestFocus();
    }

    protected Object evalToken(String string) {
        GVariable gVariable = this.variables.seek(string);
        if (gVariable != null) {
            return gVariable;
        }
        if (string.equalsIgnoreCase("pi")) {
            return new Double(Math.PI);
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected String newVariable(double d) {
        ++this.varCount;
        GVariable gVariable = new GVariable("$" + this.varCount, d);
        this.variables.addToTail(gVariable);
        return gVariable.getName();
    }

    protected String evalOps(String string, char[] cArray) {
        int n;
        while ((n = this.indexOf(string, 0, cArray)) >= 0) {
            int n2 = this.lastIndexOfDelimeter(string, n - 1);
            Object object = this.evalToken(string.substring(n2 + 1, n));
            if (object == null) {
                this.syntaxError();
                return null;
            }
            double d = object instanceof Double ? ((Double)object).doubleValue() : ((GVariable)object).getValue();
            int n3 = this.indexOfDelimeter(string, n + 1);
            if (n3 < 0) {
                n3 = string.length();
            }
            if ((object = this.evalToken(string.substring(n + 1, n3))) == null) {
                this.syntaxError();
                return null;
            }
            double d2 = object instanceof Double ? ((Double)object).doubleValue() : ((GVariable)object).getValue();
            double d3 = 0.0;
            switch (string.charAt(n)) {
                case '^': {
                    try {
                        d3 = Math.pow(d, d2);
                        break;
                    }
                    catch (ArithmeticException arithmeticException) {
                        this.negBase();
                        return null;
                    }
                }
                case '*': {
                    d3 = d * d2;
                    break;
                }
                case '/': {
                    if (d2 == 0.0) {
                        this.zeroDivision();
                        return null;
                    }
                    d3 = d / d2;
                    break;
                }
                case '+': {
                    d3 = d + d2;
                    break;
                }
                case '-': {
                    d3 = d - d2;
                }
            }
            string = String.valueOf(string.substring(0, n2 + 1)) + this.newVariable(d3) + string.substring(n3);
        }
        return string;
    }

    protected String evalNoParens(String string) {
        char[] cArray = new char[]{'^'};
        char[] cArray2 = new char[]{'*', '/'};
        char[] cArray3 = new char[]{'+', '-'};
        while (this.indexOf(string, 0, ALLOPS) > -1) {
            if ((string = this.evalOps(string, cArray)) == null) {
                return null;
            }
            if ((string = this.evalOps(string, cArray2)) == null) {
                return null;
            }
            if ((string = this.evalOps(string, cArray3)) != null) continue;
            return null;
        }
        return string;
    }

    protected Double evalFunction(String string, double d) {
        Double d2 = null;
        if (string.equalsIgnoreCase("sqrt")) {
            d2 = new Double(Math.sqrt(d));
            if (d2.isNaN()) {
                this.sqrtError();
                return null;
            }
            return d2;
        }
        if (string.equalsIgnoreCase("cos")) {
            return new Double(Math.cos(d * Math.PI / 180.0));
        }
        if (string.equalsIgnoreCase("sin")) {
            return new Double(Math.sin(d * Math.PI / 180.0));
        }
        if (string.equalsIgnoreCase("tan")) {
            int n = (int)d;
            if (d == (double)n && (d - 90.0) % 180.0 == 0.0) {
                this.argOutOfBoundsError("tan");
                return null;
            }
            return new Double(Math.tan(d * Math.PI / 180.0));
        }
        if (string.equalsIgnoreCase("acos")) {
            if (d < -1.0 || d > 1.0) {
                this.argOutOfBoundsError("acos");
                return null;
            }
            return new Double(Math.acos(d) * 180.0 / Math.PI);
        }
        if (string.equalsIgnoreCase("asin")) {
            if (d < -1.0 || d > 1.0) {
                this.argOutOfBoundsError("asin");
                return null;
            }
            return new Double(Math.asin(d) * 180.0 / Math.PI);
        }
        if (string.equalsIgnoreCase("atan")) {
            return new Double(Math.atan(d) * 180.0 / Math.PI);
        }
        return null;
    }

    protected Double evaluate(String string) {
        while (string.lastIndexOf(40) > -1) {
            int n;
            int n2 = string.lastIndexOf(40);
            int n3 = string.indexOf(41, n2 + 1);
            String string2 = this.evalNoParens(string.substring(n2 + 1, n3));
            string = String.valueOf(string.substring(0, n2 + 1)) + string2 + string.substring(n3);
            n3 = string.indexOf(41, n2 + 1);
            int n4 = n = n2 == 0 ? -1 : this.lastIndexOfDelimeter(string, n2 - 1);
            if (n == n2 - 1) {
                string2 = String.valueOf(string.substring(0, n2)) + string.substring(n2 + 1, n3);
                string = n3 == string.length() - 1 ? string2 : String.valueOf(string2) + string.substring(n3 + 1);
                continue;
            }
            n = Math.max(n, string.lastIndexOf(40, n2 - 1));
            String string3 = string.substring(n + 1, n2);
            Object object = this.evalToken(string.substring(n2 + 1, n3));
            if (object == null) {
                this.syntaxError();
                return null;
            }
            double d = object instanceof Double ? ((Double)object).doubleValue() : ((GVariable)object).getValue();
            Double d2 = this.evalFunction(string3, d);
            if (d2 == null) {
                return null;
            }
            string2 = String.valueOf(string.substring(0, n + 1)) + this.newVariable(d2);
            String string4 = string = n3 == string.length() - 1 ? string2 : String.valueOf(string2) + string.substring(n3 + 1);
        }
        Object object = this.evalToken(this.evalNoParens(string));
        if (object == null) {
            this.syntaxError();
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        return new Double(((GVariable)object).getValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.frame.clearButton) {
            this.flush();
            this.awtField.requestFocus();
            return;
        }
        String string = this.awtField.getText();
        if (string.length() == 0) {
            return;
        }
        this.variables = this.notepad.getVariableList();
        this.varCount = 0;
        if (!this.checkChars(string) || !this.checkParensMatching(string)) {
            return;
        }
        string = this.canonize(string);
        ((TextComponent)this.awtField).setText(string);
        GVariableList gVariableList = this.checkRegions(string);
        if (gVariableList == null) {
            return;
        }
        Double d = this.evaluate(string);
        if (d == null) {
            return;
        }
        if (object == this.frame.evalButton) {
            ((TextComponent)this.awtField).setText(String.valueOf((float)d.doubleValue()));
            return;
        }
        if (object == this.frame.writeDownButton) {
            if (this.problem == null) {
                new GAlertDialog(this.frame, "warn.gif", "No Problem", "No problem loaded");
                return;
            }
            if (!this.problem.logAlert("write to notepad")) {
                new GVarNameDialog(this.frame, this.notepad, this, new GExpression(gVariableList, string), d, this.problem.log);
            }
        }
    }
}

