/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GDistanceDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "distance.gif";
    public static final Dimension ICONDIM = new Dimension(100, 16);
    private TextField p1;
    private TextField p2;
    private TextField number;
    private TextField varName;
    private GButton writeDown;
    private GSolid solid;
    private GSolidCanvas canvas;
    private GNotepad notepad;
    private boolean wasMeasured;
    private GVariable varWrittenDown;
    private double scaleFactor;
    private double distanceValue;
    private String[] labels;

    public GDistanceDialog(GFrame gFrame, GNotepad gNotepad) {
        super(gFrame, "Measure Distance");
        this.helpTopic = "measure distance";
        this.notepad = gNotepad;
        this.labels = new String[2];
        this.p1 = new TextField(3);
        this.p1.setFont(gFrame.labelFont);
        this.p2 = new TextField(3);
        this.p2.setFont(gFrame.labelFont);
        this.number = new TextField(7);
        this.number.setFont(gFrame.numberFont);
        this.number.setEditable(false);
        this.varName = new TextField(5);
        this.varName.setFont(gFrame.labelFont);
        this.writeDown = new GButton("Write Down");
        this.writeDown.addActionListener(this);
        this.layComponents();
        this.pack();
        this.positionLeft();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label = new Label("Measure the distance between points:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        this.dataPanel.add(this.p1);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 5;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p2, gridBagConstraints);
        this.dataPanel.add(this.p2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridwidth = 1;
        this.okButton.setLabel("Measure");
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.dataPanel.add(this.okButton);
        gridBagConstraints.insets.left = 5;
        Label label2 = new Label("Result:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.number, gridBagConstraints);
        this.dataPanel.add(this.number);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        Label label3 = new Label("Assign variable:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.writeDown, gridBagConstraints);
        this.writeDown.setFont(GDialog.buttonFont);
        this.dataPanel.add(this.writeDown);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.labels[0].toUpperCase(), this.labels[1].toUpperCase(), this.varWrittenDown};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p1).setText((String)objectArray[0]);
        ((TextComponent)this.p2).setText((String)objectArray[1]);
        this.varWrittenDown = (GVariable)objectArray[2];
    }

    protected boolean onOk() {
        if (this.wasMeasured) {
            return true;
        }
        this.labels[0] = this.p1.getText().toUpperCase();
        this.labels[1] = this.p2.getText().toUpperCase();
        if (this.labels[0].equals("") || this.labels[1].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Distance improperly referenced");
            return false;
        }
        Object object = this.solid.measureDistance(this.labels, true);
        if (object instanceof String) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Measure Failed", (String)object);
        } else {
            this.wasMeasured = true;
            this.okButton.setEnabled(false);
            this.canvas.repaint();
            this.distanceValue = this.scaleFactor * (Double)object;
            ((TextComponent)this.number).setText(String.valueOf((float)this.distanceValue));
            this.number.select(0, GMath.leadingDigits(this.distanceValue));
        }
        return false;
    }

    public boolean set(GSolid gSolid, GSolidCanvas gSolidCanvas, double d, int n, Object[] objectArray) {
        this.solid = gSolid;
        this.canvas = gSolidCanvas;
        this.scaleFactor = d;
        if (this.scaleFactor == 1.0 && GDialog.frame instanceof GRFrame) {
            GDialog.frame.getToolkit().beep();
            GDialog.frame.getToolkit().beep();
        }
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            this.setTitle("Measure Distance in Solid " + gSolid.getLabel());
            GEdgeList gEdgeList = gSolid.getSelectedEdges();
            if (gEdgeList.getDim() > 0) {
                GEdge gEdge = gEdgeList.getHead().getEdge();
                ((TextComponent)this.p1).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p2).setText(gEdge.getTail().getLabel());
            } else {
                GVertexList gVertexList = gSolid.getSelectedVertices();
                if (gVertexList.getDim() > 1) {
                    GVertexNode gVertexNode = gVertexList.getHead();
                    ((TextComponent)this.p1).setText(gVertexNode.getVertex().getLabel());
                    ((TextComponent)this.p2).setText(gVertexNode.getNext().getVertex().getLabel());
                }
            }
        }
        if (n == 0) {
            this.show();
        } else if (n == 1) {
            this.onOk();
            if (!this.wasMeasured) {
                return false;
            }
            this.show();
        } else if (n == 2) {
            this.onOk();
            if (objectArray[2] != null) {
                this.actionPerformed(new ActionEvent(this.writeDown, 1001, null));
            }
        }
        return this.wasMeasured;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.writeDown && this.wasMeasured) {
            String string = this.varName.getText().trim();
            if (this.varWrittenDown == null) {
                String string2 = GVariable.checkName(string);
                if (string2 != null) {
                    new GAlertDialog(GDialog.frame, "warn.gif", "Invalid Variable", string2);
                    return;
                }
                this.varWrittenDown = new GVariable(string, this.distanceValue);
            }
            if (!this.notepad.add(this.varWrittenDown, this.labels, this.solid, 1)) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA Notepad", "Variable " + string + " in use");
                this.varWrittenDown = null;
                return;
            }
            ((Component)this).setVisible(false);
        }
    }
}

