/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GEdge
implements Serializable {
    public GVertexList vertexList;
    public transient GEdge twin;
    public transient GFacet wing1;
    public transient GFacet wing2;
    private transient boolean selected;
    private transient boolean marked;

    public GEdge(GVertex gVertex, GVertex gVertex2) {
        this.vertexList = new GVertexList(gVertex, gVertex2);
    }

    public GEdge(GVertex gVertex, GVertex gVertex2, GFacet gFacet) {
        this.vertexList = new GVertexList(gVertex, gVertex2);
        this.wing1 = gFacet;
    }

    public GEdge(GVertexList gVertexList, GFacet gFacet) {
        this.vertexList = gVertexList;
        this.wing1 = gFacet;
    }

    public void print() {
        System.out.println(String.valueOf(this.getHead().getLabel()) + this.getTail().getLabel());
    }

    public GEdge copy() {
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            gVertexList.addToTail(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        return new GEdge(gVertexList, this.wing1);
    }

    public void printAll() {
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode != null) {
            System.out.print(gVertexNode.getVertex().getLabel());
            gVertexNode = gVertexNode.getNext();
        }
        System.out.println();
    }

    public GVertex getHead() {
        return this.vertexList.getHead().getVertex();
    }

    public GVertex getTail() {
        return this.vertexList.getTail().getVertex();
    }

    public GPoint3D toVector() {
        return GMath.subtract(this.getTail().xyzCrds, this.getHead().xyzCrds);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void switchSelection() {
        boolean bl = this.selected = !this.selected;
        if (this.twin != null) {
            this.twin.selected = this.selected;
        }
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (this.twin != null) {
            this.twin.selected = bl;
        }
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
        if (this.twin != null) {
            this.twin.marked = bl;
        }
    }

    public double getLength() {
        return GMath.dist(this.getHead().xyzCrds, this.getTail().xyzCrds);
    }

    public GEdge engross(GVertex gVertex) {
        GPoint3D gPoint3D = gVertex.xyzCrds;
        GVertex gVertex2 = this.getHead();
        GVertex gVertex3 = this.getTail();
        if (!GMath.areCollinear(gVertex2.xyzCrds, gVertex3.xyzCrds, gPoint3D)) {
            return null;
        }
        double d = GMath.simpleRatio(gVertex2.xyzCrds, gVertex3.xyzCrds, gPoint3D);
        if (d > 0.0) {
            return this;
        }
        if (d > -1.0) {
            return new GEdge(gVertex, gVertex3);
        }
        return new GEdge(gVertex2, gVertex);
    }

    public void reverse() {
        this.vertexList = this.vertexList.reverse();
    }

    public GSegment toSegment() {
        return new GSegment(this.getHead().xyzCrds, this.getTail().xyzCrds);
    }

    public void addVertex(GVertex gVertex) {
        GPoint3D gPoint3D = gVertex.xyzCrds;
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode.getNext() != null) {
            GPoint3D gPoint3D2 = gVertexNode.getVertex().xyzCrds;
            GPoint3D gPoint3D3 = gVertexNode.getNext().getVertex().xyzCrds;
            double d = GMath.simpleRatio(gPoint3D2, gPoint3D3, gPoint3D);
            if (d < 0.0 && d > -1.0) {
                this.vertexList.addToHead(gVertex);
                return;
            }
            if (d > 0.0) {
                this.vertexList.insertBefore(gVertex, gVertexNode.getNext());
                return;
            }
            gVertexNode = gVertexNode.getNext();
        }
        this.vertexList.addToTail(gVertex);
    }

    public boolean passesThrough(GPoint3D gPoint3D) {
        GPoint3D gPoint3D2 = this.getHead().xyzCrds;
        GPoint3D gPoint3D3 = this.getTail().xyzCrds;
        return GMath.isBetween(gPoint3D2, gPoint3D3, gPoint3D);
    }

    public GEdge[] cutBetween(GVertex gVertex, GVertex gVertex2) {
        GVertexNode gVertexNode = null;
        GVertexNode gVertexNode2 = null;
        GVertexNode gVertexNode3 = this.vertexList.getHead();
        GVertexNode gVertexNode4 = this.vertexList.getTail();
        GVertexNode gVertexNode5 = gVertexNode3;
        while (gVertexNode5 != null) {
            if (gVertexNode5.getVertex() == gVertex || gVertexNode5.getVertex() == gVertex2) {
                if (gVertexNode == null) {
                    gVertexNode = gVertexNode5;
                } else {
                    gVertexNode2 = gVertexNode5;
                    break;
                }
            }
            gVertexNode5 = gVertexNode5.getNext();
        }
        if (gVertexNode == null || gVertexNode2 == null || gVertexNode == gVertexNode2) {
            return null;
        }
        GEdge[] gEdgeArray = new GEdge[2];
        if (gVertexNode != gVertexNode3) {
            gEdgeArray[0] = new GEdge(this.vertexList.crop(gVertexNode3, gVertexNode), this.wing1);
        }
        if (gVertexNode2 != gVertexNode4) {
            gEdgeArray[1] = new GEdge(this.vertexList.crop(gVertexNode2, gVertexNode4), this.wing1);
        }
        return gEdgeArray;
    }

    public GEdge cutOffTo(GVertex gVertex) {
        if (gVertex == this.getTail()) {
            return null;
        }
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode.getVertex() != gVertex) {
            gVertexNode = gVertexNode.getNext();
        }
        while (gVertexNode != null) {
            gVertexList.addToTail(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        return new GEdge(gVertexList, this.wing1);
    }

    public GEdge cutOffFrom(GVertex gVertex) {
        if (gVertex == this.getHead()) {
            return null;
        }
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.vertexList.getHead();
        while (gVertexNode.getVertex() != gVertex) {
            gVertexList.addToTail(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        gVertexList.addToTail(gVertex);
        return new GEdge(gVertexList, this.wing1);
    }

    public GPointObject intersectPlane(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        GPoint3D gPoint3D3 = GMath.intersect(this, gPoint3D, gPoint3D2);
        if (gPoint3D3 == null) {
            return null;
        }
        GVertex gVertex = this.vertexList.seek(gPoint3D3, this.getLength());
        if (gVertex != null) {
            return gVertex;
        }
        return gPoint3D3;
    }

    public GPointObject[] intersectSphere(GPoint3D gPoint3D, double d) {
        GPointObject[] gPointObjectArray = new GPointObject[2];
        GPoint3D[] gPoint3DArray = GMath.intersectSphere(this, gPoint3D, d);
        int n = 0;
        while (n < 2) {
            if (gPoint3DArray[n] != null) {
                GVertex gVertex = this.vertexList.seek(gPoint3DArray[n], this.getLength());
                gPointObjectArray[n] = gVertex != null ? gVertex : gPoint3DArray[n];
            }
            ++n;
        }
        if (gPointObjectArray[0] == null) {
            gPointObjectArray[0] = gPointObjectArray[1];
            gPointObjectArray[1] = null;
        }
        return gPointObjectArray;
    }
}

