/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public class GFacetAreaDialog
extends GOkCancelHelpDialog {
    private TextField number;
    private TextField varName;
    private List facets;
    private GButton writeDown;
    private GSolid solid;
    private GNotepad notepad;
    private double areaValue;
    private boolean wasMeasured;

    public GFacetAreaDialog(GFrame gFrame, GNotepad gNotepad, GSolid gSolid) {
        super(gFrame, "Facet Area in Solid " + gSolid.getLabel());
        this.helpTopic = "measure area";
        this.notepad = gNotepad;
        this.solid = gSolid;
        this.number = new TextField(7);
        this.number.setFont(gFrame.numberFont);
        this.number.setEditable(false);
        this.varName = new TextField(5);
        this.varName.setFont(gFrame.labelFont);
        this.facets = new List(4);
        this.facets.setFont(gFrame.labelFont);
        this.writeDown = new GButton("Write Down");
        this.writeDown.setFont(GDialog.buttonFont);
        this.writeDown.addActionListener(this);
        this.layComponents();
        this.loadFacets();
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        Label label = new Label("Select facet:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.facets, gridBagConstraints);
        this.dataPanel.add(this.facets);
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        this.okButton.setLabel("Measure");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.dataPanel.add(this.okButton);
        gridBagConstraints.insets.left = 5;
        Label label2 = new Label("Result:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.number, gridBagConstraints);
        this.dataPanel.add(this.number);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 2;
        Label label3 = new Label("Assign variable:", 0);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.varName, gridBagConstraints);
        this.dataPanel.add(this.varName);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.writeDown, gridBagConstraints);
        this.dataPanel.add(this.writeDown);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        if (this.wasMeasured) {
            return true;
        }
        String string = this.facets.getSelectedItem();
        if (string == null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Selection", "Select a facet");
            return false;
        }
        this.areaValue = this.solid.facetList.seek(string).computeArea();
        this.wasMeasured = true;
        this.okButton.setEnabled(false);
        ((TextComponent)this.number).setText(String.valueOf((float)this.areaValue));
        this.number.select(0, GMath.leadingDigits(this.areaValue));
        return false;
    }

    public void loadFacets() {
        GFacetNode gFacetNode = this.solid.facetList.getHead();
        while (gFacetNode != null) {
            GFacet gFacet = gFacetNode.getFacet();
            this.facets.add(gFacet.toString());
            if (gFacet.isSelected()) {
                this.facets.select(this.facets.getItemCount() - 1);
            }
            gFacetNode = gFacetNode.getNext();
        }
        this.facets.makeVisible(this.facets.getSelectedIndex());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if (actionEvent.getSource() == this.writeDown && this.wasMeasured) {
            String string = this.varName.getText().trim();
            String string2 = GVariable.checkName(string);
            if (string2 != null) {
                new GAlertDialog(GDialog.frame, "warn.gif", "Invalid Variable", string2);
                return;
            }
            String[] stringArray = new String[]{this.facets.getSelectedItem()};
            if (!this.notepad.add(new GVariable(string, this.areaValue), stringArray, this.solid, 2)) {
                new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA Notepad", "Variable " + string + " in use");
                return;
            }
            ((Component)this).setVisible(false);
        }
    }
}

