/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class GMarkSpectrum
extends Canvas {
    private Color basicColor;
    private Color markedColor;
    private static final int INSET = 10;
    private int markedY;

    public GMarkSpectrum(Color color) {
        this.basicColor = color;
        this.markedColor = color;
    }

    public void setBasicColor(Color color) {
        this.basicColor = color;
        this.mark(-1);
    }

    public void mark(int n) {
        int n2 = 7;
        int n3 = this.getSize().height;
        this.markedY = n < n2 || n > n3 - n2 ? n3 / 2 : n;
        int n4 = this.markedY - this.getSize().height / 2;
        int n5 = Math.min(255, Math.abs(this.basicColor.getRed() - n4));
        int n6 = Math.min(255, Math.abs(this.basicColor.getGreen() - n4));
        int n7 = Math.min(255, Math.abs(this.basicColor.getBlue() - n4));
        this.markedColor = new Color(n5, n6, n7);
    }

    public Color getMarkedColor() {
        return this.markedColor;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.getSize().width - 10;
        int n3 = this.getSize().height;
        int n4 = 0;
        while (n4 < n3) {
            n = n3 / 2 - n4;
            int n5 = Math.min(255, Math.abs(this.basicColor.getRed() + n));
            int n6 = Math.min(255, Math.abs(this.basicColor.getGreen() + n));
            int n7 = Math.min(255, Math.abs(this.basicColor.getBlue() + n));
            graphics.setColor(new Color(n5, n6, n7));
            graphics.drawLine(10, n4, n2 + 10, n4);
            ++n4;
        }
        GCanvas3D.drawFrame(graphics, 10, 0, n2, n3);
        n = 7;
        int[] nArray = new int[3];
        nArray[0] = n;
        int[] nArray2 = nArray;
        int[] nArray3 = new int[]{this.markedY, this.markedY - n, this.markedY + n};
        Polygon polygon = new Polygon(nArray2, nArray3, 3);
        graphics.setColor(Color.darkGray);
        graphics.fillPolygon(polygon);
    }
}

