/*
 * Decompiled with CFR 0.152.
 */
import java.awt.List;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class GNotepad
implements Serializable,
MouseListener,
ActionListener,
KeyListener {
    public static final int NOSPEC = -1;
    public static final int ANGLE = 0;
    public static final int DISTANCE = 1;
    public static final int AREA = 2;
    public static final int VOLUME = 3;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int MIDDLE = 2;
    public static final int POPUPMENU_GEN = 1;
    public static final int LOG_GEN = 2;
    private static GFrame frame;
    public static List awtList;
    private GProblem problem;
    public GNPRecordList recordList;
    private static GPopupMenuNP popupMenu;

    public GNotepad(GFrame gFrame, int n) {
        frame = gFrame;
        awtList = new List(n, true);
        this.recordList = new GNPRecordList();
        popupMenu = new GPopupMenuNP(this);
        frame.add(popupMenu);
        awtList.addMouseListener(this);
        awtList.addKeyListener(this);
        awtList.setFont(gFrame.numberFont);
    }

    public void print() {
        this.recordList.print();
    }

    public void flush() {
        this.recordList.flush();
        awtList.removeAll();
    }

    public void setProblem(GProblem gProblem) {
        this.problem = gProblem;
        this.recordList = gProblem.notepad.recordList;
        this.problem.notepad = this;
    }

    public boolean add(GVariable gVariable, String[] stringArray, GSolid gSolid, int n) {
        if (this.recordList.seekVarDefinition(gVariable.getName()) != null) {
            return false;
        }
        GNPRecord gNPRecord = null;
        switch (n) {
            case 1: {
                gNPRecord = new GNPRecord(gVariable, "|" + stringArray[0] + stringArray[1] + "|", gSolid);
                break;
            }
            case 0: {
                gNPRecord = new GNPRecord(gVariable, "<" + stringArray[0] + stringArray[1] + stringArray[2], gSolid);
                break;
            }
            case 2: {
                gNPRecord = new GNPRecord(gVariable, "A[" + stringArray[0] + "]", gSolid);
                break;
            }
            case 3: {
                gNPRecord = new GNPRecord(gVariable, "V[" + stringArray[0] + "]", gSolid);
            }
        }
        this.recordList.addToTail(gNPRecord);
        awtList.add(gNPRecord.toString());
        awtList.makeVisible(awtList.getItemCount() - 1);
        this.problem.setModified(true);
        return true;
    }

    public boolean add(GVariable gVariable, GExpression gExpression, GCalculator gCalculator, int n) {
        if (this.recordList.seekVarDefinition(gVariable.getName()) != null) {
            return false;
        }
        GNPRecord gNPRecord = new GNPRecord(gVariable, gExpression, gCalculator);
        this.recordList.addToTail(gNPRecord);
        awtList.add(gNPRecord.toString());
        awtList.makeVisible(awtList.getItemCount() - 1);
        if (n != 2) {
            this.problem.setModified(true);
        }
        return true;
    }

    public boolean changeVertexLabel(String string, String string2, GSolid gSolid) {
        boolean bl = false;
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (gNPRecord.getOrigin() == gSolid) {
                bl = gNPRecord.changeVertexLabel(string, string2) || bl;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        if (bl) {
            this.redraw();
            new GAlertDialog(frame, "warn.gif", "GEOMETRIA Warning", "Notepad records have been updated");
        }
        return bl;
    }

    public void redraw() {
        awtList.removeAll();
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            awtList.add(gNPRecordNode.getRecord().toString());
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public boolean removeVertexLabel(String string, GSolid gSolid) {
        boolean bl = false;
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (gNPRecord.getOrigin() == gSolid) {
                bl = gNPRecord.removeVertexLabel(string) || bl;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        if (bl) {
            this.redraw();
            new GAlertDialog(frame, "warn.gif", "GEOMETRIA", "Notepad records have been updated");
        }
        return bl;
    }

    public boolean removeSolid(GSolid gSolid, boolean bl) {
        boolean bl2 = false;
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (gNPRecord.getOrigin() == gSolid) {
                gNPRecord.flushRSide();
                gNPRecord.flushOrigin();
                bl2 = true;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        if (bl2) {
            this.redraw();
            if (bl) {
                new GAlertDialog(frame, "warn.gif", "GEOMETRIA", "Notepad records have been updated");
            }
        }
        return bl2;
    }

    public boolean update(GSolid gSolid, GSolid gSolid2, boolean bl) {
        boolean bl2 = false;
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (gNPRecord.getOrigin() == gSolid) {
                gNPRecord.setOrigin(gSolid2);
                GVariable gVariable = gNPRecord.getLSide();
                String string = (String)gNPRecord.getRSide();
                Object object = null;
                switch (string.charAt(0)) {
                    case '|': {
                        String[] stringArray = new String[]{string.substring(1, 2), string.substring(2, 3)};
                        object = gSolid2.measureDistance(stringArray, false);
                        break;
                    }
                    case '<': {
                        String[] stringArray = new String[]{string.substring(2, 3), string.substring(1, 2), string.substring(3, 4)};
                        object = gSolid2.measureAngle(stringArray, false);
                        break;
                    }
                    case 'A': {
                        String string2 = string.substring(2, string.length() - 1);
                        GFacet gFacet = gSolid2.facetList.seek(string2);
                        object = gFacet != null ? new Double(gFacet.computeArea()) : new String();
                    }
                    case 'V': {
                        String string3 = string.substring(2, string.length() - 1);
                        object = string3.equals(gSolid2.toString()) ? new Double(gSolid2.computeVolume()) : new String();
                    }
                }
                if (object instanceof Double) {
                    gVariable.setValue((Double)object);
                } else if (object instanceof String) {
                    gNPRecord.flushRSide();
                    gNPRecord.setOrigin(null);
                    bl2 = true;
                }
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        if (bl2) {
            this.redraw();
            if (bl) {
                new GAlertDialog(frame, "warn.gif", "GEOMETRIA", "Notepad records have been updated");
            }
        }
        return bl2;
    }

    public GVariableList getVariableList() {
        GVariableList gVariableList = new GVariableList();
        GNPRecordNode gNPRecordNode = this.recordList.getHead();
        while (gNPRecordNode != null) {
            gVariableList.addToTail(gNPRecordNode.getRecord().getLSide());
            gNPRecordNode = gNPRecordNode.getNext();
        }
        return gVariableList;
    }

    public void deleteRecords(int n, Object[] objectArray) {
        GNPRecordList gNPRecordList;
        if (n != 2 && this.problem.logAlert("delete notepad records")) {
            return;
        }
        if (n == 2) {
            gNPRecordList = this.recordList.seekVarDefinitions((GVariable[])objectArray);
        } else {
            Serializable serializable;
            Serializable serializable2;
            gNPRecordList = this.recordList.seek(awtList.getSelectedItems());
            int n2 = gNPRecordList.getDim();
            if (n2 > 1) {
                serializable2 = new GYNPromptDialog(frame, "Delete all selected records?");
                if (((GDialog)serializable2).result == 3) {
                    return;
                }
            }
            this.recordList.seekDependencies(gNPRecordList);
            serializable2 = gNPRecordList.getHead();
            while (serializable2 != null) {
                serializable = ((GNPRecordNode)serializable2).getRecord();
                int n3 = 0;
                while (n3 < awtList.getItemCount()) {
                    if (awtList.getItem(n3).equals(((GNPRecord)serializable).toString())) {
                        awtList.select(n3);
                    }
                    ++n3;
                }
                serializable2 = ((GNPRecordNode)serializable2).getNext();
            }
            if (gNPRecordList.getDim() > n2) {
                serializable = new GYNPromptDialog(frame, "A list of dependencies has been added. Delete all selected records?");
                if (((GDialog)serializable).result == 3) {
                    this.deselectAll();
                    return;
                }
            }
        }
        this.recordList.remove(gNPRecordList);
        this.redraw();
        this.deselectAll();
        if (n != 2) {
            this.problem.setModified(true);
            if (this.problem.log != null) {
                this.problem.log.add("Notepad: Delete", gNPRecordList.getDefinedVars(), null);
            }
        }
    }

    public int whichButton(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            return 1;
        }
        if (mouseEvent.isAltDown()) {
            return 2;
        }
        return 0;
    }

    public Object seekDoubleObject(String string) {
        GNPRecord gNPRecord = this.recordList.seekVarDefinition(string);
        if (gNPRecord != null) {
            return gNPRecord.getLSide();
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected void deselectAll() {
        int[] nArray = awtList.getSelectedIndexes();
        int n = 0;
        while (n < nArray.length) {
            awtList.deselect(nArray[n]);
            ++n;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if ((n == 10 || n == 32) && awtList.getSelectedIndexes().length == 1) {
            ActionEvent actionEvent = new ActionEvent(GNotepad.popupMenu.propsPMenuItem, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1 && awtList.getSelectedIndexes().length == 1) {
            ActionEvent actionEvent = new ActionEvent(GNotepad.popupMenu.propsPMenuItem, 0, null);
            this.actionPerformed(actionEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.whichButton(mouseEvent) == 1) {
            Point point = mouseEvent.getPoint();
            popupMenu = new GPopupMenuNP(this);
            frame.add(popupMenu);
            if (popupMenu.getItemCount() > 0) {
                popupMenu.show(awtList, point.x, point.y);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        if (gMenuItem == GNotepad.popupMenu.clearPMenuItem) {
            this.deselectAll();
            return;
        }
        if (gMenuItem == GNotepad.popupMenu.propsPMenuItem) {
            new GNPRecordPropsDialog(frame, this.recordList.seek(awtList.getSelectedItems()[0]));
            return;
        }
        if (gMenuItem == GNotepad.popupMenu.deletePMenuItem) {
            this.deleteRecords(1, null);
        }
    }
}

