/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GRFrame
extends GFrame {
    public static final String TITLE = "GEOMETRIA Resolver";
    public static final Dimension HYPOTHESIS_AREA = new Dimension(225, 80);
    public static final Color HYPOTHESIS_BACKGROUND = new Color(210, 210, 210);
    private GTextCanvas hypothesisView;
    private ScrollPane hScroller;

    public GRFrame() {
        this.setTitle(TITLE);
        GRMenuBar gRMenuBar = new GRMenuBar(this);
        this.menuBar = gRMenuBar;
        this.setMenuBar(gRMenuBar);
        this.hypothesisView = new GTextCanvas(this, HYPOTHESIS_BACKGROUND, new Dimension(50, 50), "", false, new Insets(5, 5, 5, 5));
        this.layComponents();
        this.hypothesisView.setDim(this.getHypothesisTextArea());
        this.menuBar.update(null, null);
        this.show();
    }

    protected Component decorateHypothesisView() {
        this.hScroller = new ScrollPane();
        this.hScroller.add(this.hypothesisView);
        this.hScroller.setSize(GRFrame.HYPOTHESIS_AREA.width, GRFrame.HYPOTHESIS_AREA.height);
        this.hScroller.getVAdjustable().setUnitIncrement(10);
        this.hScroller.getHAdjustable().setUnitIncrement(10);
        this.hScroller.setBackground(HYPOTHESIS_BACKGROUND);
        return this.hScroller;
    }

    public Dimension getHypothesisTextArea() {
        int n = GRFrame.HYPOTHESIS_AREA.width - this.hScroller.getVScrollbarWidth();
        int n2 = GRFrame.HYPOTHESIS_AREA.height - this.hScroller.getHScrollbarHeight();
        return new Dimension(n, n2);
    }

    public void layoutHypothesisView() {
        this.hScroller.doLayout();
    }

    protected void openProblem() {
        GFileDialog gFileDialog = new GFileDialog(this, "Open Problem", this.problemDir, 0);
        this.problemDir = gFileDialog.getDirectory();
        String string = gFileDialog.getFile();
        if (this.problemDir != null && this.problemDir.length() != 0 && string != null && string.length() != 0) {
            FileInputStream fileInputStream;
            Object object;
            try {
                object = new File(this.problemDir, string);
                fileInputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA Warning", "File not found");
                return;
            }
            try {
                object = new ObjectInputStream(fileInputStream);
                Object object2 = ((ObjectInputStream)object).readObject();
                if (!(object2 instanceof GCProblem)) {
                    new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File contains no GEOMETRIA problem");
                    return;
                }
                GProblem gProblem = (GProblem)object2;
                if (!gProblem.isValidated()) {
                    new GAlertDialog(this, "warn.gif", "GEOMETRIA Warning", "Cannot open " + string + " in Resolver: not validated");
                    return;
                }
                if (this.problem != null) {
                    this.problem.close();
                }
                GProblem gProblem2 = this.problem;
                this.problem = new GRProblem(this, gProblem, this.menuBar, this.calculator, this.notepad);
                this.problem.setName(string);
                this.menuBar.initWindowMenu();
                this.setProblem(gProblem2, this.problem);
                ((GRProblem)this.problem).init(true);
                if (this.problem.isRandomized()) {
                    this.problem.setScaleFactor(1.5 * Math.random() + 0.5);
                }
                this.hypothesisView.setText(gProblem.getHypothesis());
                this.layoutHypothesisView();
                this.hypothesisView.repaint();
                this.calculator.flush();
                this.notepad.flush();
                this.setTitle("GEOMETRIA Resolver: " + this.problem.getName());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.toString());
                return;
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA Warning", "File contains no GEOMETRIA problem");
                return;
            }
        }
    }

    protected void openResolution() {
        GFileDialog gFileDialog = new GFileDialog(this, "Open Resolution", this.resDir, 0);
        this.resDir = gFileDialog.getDirectory();
        String string = gFileDialog.getFile();
        if (this.resDir != null && this.resDir.length() != 0 && string != null && string.length() != 0) {
            FileInputStream fileInputStream;
            Object object;
            try {
                object = new File(this.resDir, string);
                fileInputStream = new FileInputStream((File)object);
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File not found");
                return;
            }
            try {
                object = new ObjectInputStream(fileInputStream);
                GProblem gProblem = this.problem;
                Object object2 = ((ObjectInputStream)object).readObject();
                if (!(object2 instanceof GRProblem)) {
                    new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File contains no GEOMETRIA resolution");
                    return;
                }
                GRProblem gRProblem = (GRProblem)object2;
                if (this.problem == null) {
                    this.problem = new GRProblem(this, gRProblem, this.menuBar, this.calculator, this.notepad);
                } else {
                    this.problem.close();
                }
                this.problem = gRProblem;
                this.problem.setName(string);
                this.menuBar.initWindowMenu();
                this.setProblem(gProblem, this.problem);
                ((GRProblem)this.problem).init(false);
                this.hypothesisView.setText(gRProblem.getHypothesis());
                this.layoutHypothesisView();
                this.hypothesisView.repaint();
                this.calculator.flush();
                this.notepad.redraw();
                this.setTitle("GEOMETRIA Resolver: " + this.problem.getName());
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException.toString());
                return;
            }
            catch (IOException iOException) {
                new GAlertDialog(this, "warn.gif", "GEOMETRIA", "File contains no GEOMETRIA problem resolution");
                return;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        GMenuItem gMenuItem = (GMenuItem)actionEvent.getSource();
        GMenu gMenu = (GMenu)gMenuItem.getParent();
        if (gMenu == this.menuBar.fileMenu && gMenuItem == ((GRMenuBar)this.menuBar).openResolutionMenuItem && (this.problem == null || this.problem.onClose())) {
            this.openResolution();
        }
    }
}

