/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class GStretchDialog
extends GOkCancelHelpDialog
implements TextListener,
FocusListener {
    public static final String STRETCHX_ICON = "stretchx.gif";
    public static final String STRETCHY_ICON = "stretchy.gif";
    public static final String STRETCHZ_ICON = "stretchz.gif";
    public static final Dimension ICONDIM = new Dimension(40, 40);
    private TextField xRatio;
    private TextField yRatio;
    private TextField zRatio;
    private Checkbox sameRatio;
    private boolean xRatioGotFocus;
    private boolean yRatioGotFocus;
    private boolean zRatioGotFocus;

    public GStretchDialog(GFrame gFrame, String string) {
        super(gFrame, "Stretch");
        this.helpTopic = "stretch solid";
        this.setTitle("Stretch " + string);
        this.xRatio = new TextField("100", 5);
        this.xRatio.setFont(gFrame.numberFont);
        this.xRatio.addFocusListener(this);
        this.yRatio = new TextField("100", 5);
        this.yRatio.setFont(gFrame.numberFont);
        this.yRatio.addFocusListener(this);
        this.zRatio = new TextField("100", 5);
        this.zRatio.setFont(gFrame.numberFont);
        this.zRatio.addFocusListener(this);
        this.sameRatio = new Checkbox("Same ratio", false);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.gridwidth = 1;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + STRETCHX_ICON);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.fill = 2;
        Label label = new Label("Along x axis:", 2);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.xRatio, gridBagConstraints);
        ((TextComponent)this.xRatio).setText("100");
        this.dataPanel.add(this.xRatio);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label2 = new Label("%");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridwidth = 1;
        Image image2 = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + STRETCHY_ICON);
        GIconCanvas gIconCanvas2 = new GIconCanvas(image2, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas2, gridBagConstraints);
        this.dataPanel.add(gIconCanvas2);
        gridBagConstraints.fill = 2;
        Label label3 = new Label("Along y axis:", 2);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.yRatio, gridBagConstraints);
        ((TextComponent)this.yRatio).setText("100");
        this.dataPanel.add(this.yRatio);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label4 = new Label("%");
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.dataPanel.add(label4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridwidth = 1;
        Image image3 = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + STRETCHZ_ICON);
        GIconCanvas gIconCanvas3 = new GIconCanvas(image3, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas3, gridBagConstraints);
        this.dataPanel.add(gIconCanvas3);
        gridBagConstraints.fill = 2;
        Label label5 = new Label("Along z axis:", 2);
        gridBagLayout.setConstraints(label5, gridBagConstraints);
        this.dataPanel.add(label5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.zRatio, gridBagConstraints);
        ((TextComponent)this.zRatio).setText("100");
        this.dataPanel.add(this.zRatio);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        Label label6 = new Label("%");
        gridBagLayout.setConstraints(label6, gridBagConstraints);
        this.dataPanel.add(label6);
        gridBagConstraints.insets.left = 10;
        gridBagLayout.setConstraints(this.sameRatio, gridBagConstraints);
        this.dataPanel.add(this.sameRatio);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        GPoint3D gPoint3D;
        try {
            gPoint3D = this.getRatios();
        }
        catch (NumberFormatException numberFormatException) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Wrong Number Format", "Couldn't read ratios");
            return false;
        }
        if (gPoint3D.X <= 0.0 || gPoint3D.Y <= 0.0 || gPoint3D.Z <= 0.0) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Wrong number format", "Ratios must be positive numbers");
            return false;
        }
        return true;
    }

    public GPoint3D getRatios() {
        double d = Double.valueOf(this.xRatio.getText());
        double d2 = Double.valueOf(this.yRatio.getText());
        double d3 = Double.valueOf(this.zRatio.getText());
        return new GPoint3D(d, d2, d3);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.sameRatio.getState()) {
            return;
        }
        TextField textField = (TextField)textEvent.getSource();
        String string = textField.getText();
        if (textField != this.xRatio) {
            ((TextComponent)this.xRatio).setText(string);
        }
        if (textField != this.yRatio) {
            ((TextComponent)this.yRatio).setText(string);
        }
        if (textField != this.zRatio) {
            ((TextComponent)this.zRatio).setText(string);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        TextField textField = (TextField)focusEvent.getSource();
        textField.addTextListener(this);
    }

    public void focusLost(FocusEvent focusEvent) {
        TextField textField = (TextField)focusEvent.getSource();
        textField.removeTextListener(this);
    }
}

