/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class GTextCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static Color defaultColor;
    public static Font defaultFont;
    public static Font boldFont;
    public static Font italicFont;
    protected GFrame frame;
    protected Color bkground;
    protected String text;
    protected Insets insets;
    protected Point cursor;
    protected GTextTokenList tokenList;
    protected GTextToken activeToken;
    protected Dimension dim;
    protected Dimension textSize;
    protected boolean vCentered;

    public GTextCanvas(GFrame gFrame, Color color, Dimension dimension, String string, boolean bl, Insets insets) {
        this.frame = gFrame;
        this.insets = insets;
        defaultColor = Color.black;
        defaultFont = gFrame.textFont;
        boldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        italicFont = new Font(defaultFont.getName(), 2, defaultFont.getSize());
        this.bkground = color;
        this.vCentered = bl;
        this.tokenList = new GTextTokenList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setDim(dimension);
        this.setText(string);
    }

    public void setDim(Dimension dimension) {
        this.dim = dimension;
        this.textSize = new Dimension(dimension.width - (this.insets.left + this.insets.right), dimension.height - (this.insets.top + this.insets.bottom));
    }

    public void setText(String string) {
        this.text = string.trim();
        if (this.frame.getGraphics() != null) {
            this.textSize.height = this.layText(this.frame.getGraphics());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.dim.width, Math.max(this.dim.height, this.textSize.height + this.insets.top + this.insets.bottom));
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.bkground);
        graphics.translate(this.insets.left, this.insets.top);
        int n = this.dim.height - this.textSize.height - (this.insets.top + this.insets.bottom);
        if (this.vCentered && n > 0) {
            graphics.translate(0, n / 2);
        }
        this.drawText(graphics);
    }

    protected int layText(Graphics graphics) {
        this.tokenList = new GTextTokenList();
        this.cursor = new Point(0, graphics.getFontMetrics(defaultFont).getAscent());
        int n = this.nextBreakPos(this.text, 0);
        if (n < 0) {
            this.layParagraph(graphics, this.text);
            return this.cursor.y + graphics.getFontMetrics().getDescent();
        }
        if (n > 0) {
            this.layParagraph(graphics, this.text.substring(0, n));
            this.caretReturn(graphics, this.text.indexOf("<p>") == n);
        }
        n = this.text.indexOf(">", n) + 1;
        while (true) {
            int n2;
            if ((n2 = this.nextBreakPos(this.text, n)) < 0) {
                this.layParagraph(graphics, this.text.substring(n));
                return this.cursor.y + graphics.getFontMetrics().getDescent();
            }
            this.layParagraph(graphics, this.text.substring(n, n2));
            this.caretReturn(graphics, this.text.indexOf("<p>", n2) == n2);
            n = this.text.indexOf(">", n2) + 1;
        }
    }

    protected void layParagraph(Graphics graphics, String string) {
        if ((string = string.trim()).length() == 0) {
            return;
        }
        graphics.setFont(defaultFont);
        graphics.setColor(Color.black);
        String string2 = null;
        int n = string.indexOf("<");
        if (n < 0) {
            this.layString(graphics, string, null);
            return;
        }
        if (n > 0) {
            this.layString(graphics, string.substring(0, n), null);
        }
        while (true) {
            int n2;
            int n3;
            String string3;
            if ((string3 = string.substring(n + 1, n3 = string.indexOf(">", n)).trim()).equals("b")) {
                graphics.setFont(boldFont);
            } else if (string3.equals("i")) {
                graphics.setFont(italicFont);
            } else if (string3.equals("/b") || string3.equals("/i")) {
                graphics.setFont(new Font(graphics.getFont().getName(), 0, graphics.getFont().getSize()));
            } else if (string3.indexOf("href") > 0) {
                n2 = string3.indexOf("=");
                string2 = string3.substring(n2 + 1).trim();
            } else if (string3.startsWith("/a")) {
                string2 = null;
            } else if (string3.startsWith("font")) {
                n2 = string3.indexOf("=");
                String string4 = string3.substring(n2 + 1).trim();
                graphics.setColor(this.colorByName(string4));
            } else if (string3.startsWith("/font")) {
                graphics.setColor(defaultColor);
            }
            n = n3 + 1;
            n3 = string.indexOf("<", n);
            if (n3 < 0) {
                this.layString(graphics, string.substring(n), string2);
                return;
            }
            this.layString(graphics, string.substring(n, n3), string2);
            n = n3;
        }
    }

    protected void layString(Graphics graphics, String string, String string2) {
        if (string.length() == 0) {
            return;
        }
        string = this.comb(string);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            String string3 = new String();
            boolean bl2 = false;
            while (true) {
                String string4;
                int n2 = this.textSize.width - this.cursor.x;
                int n3 = string.indexOf(" ", n);
                String string5 = string4 = n3 < 0 ? string.substring(n) : string.substring(n, n3);
                if (fontMetrics.stringWidth(String.valueOf(string3) + string4) > n2) {
                    if (this.cursor.x == 0 && string3.length() == 0) {
                        this.textSize.width = fontMetrics.stringWidth(string4);
                    } else {
                        bl2 = true;
                        break;
                    }
                }
                string3 = String.valueOf(string3) + string4;
                if (n3 < 0) {
                    bl = true;
                    break;
                }
                string3 = String.valueOf(string3) + " ";
                n = n3 + 1;
            }
            if (string3.length() > 0) {
                GTextToken gTextToken = new GTextToken(graphics, string3, new Point(this.cursor), string2);
                this.tokenList.addToTail(gTextToken);
            }
            if (bl2) {
                this.cursor.x = 0;
                this.cursor.y += fontMetrics.getHeight();
                continue;
            }
            this.cursor.x += fontMetrics.stringWidth(string3);
        }
    }

    protected void drawText(Graphics graphics) {
        if (this.tokenList == null) {
            return;
        }
        GTextTokenNode gTextTokenNode = this.tokenList.getHead();
        while (gTextTokenNode != null) {
            gTextTokenNode.getToken().paint(graphics);
            gTextTokenNode = gTextTokenNode.getNext();
        }
    }

    protected int nextBreakPos(String string, int n) {
        int n2 = string.indexOf("<p>", n);
        int n3 = string.indexOf("<br>", n);
        if (n2 < 0) {
            return n3;
        }
        if (n3 < 0) {
            return n2;
        }
        return Math.min(n2, n3);
    }

    protected void caretReturn(Graphics graphics, boolean bl) {
        this.cursor.x = 0;
        int n = graphics.getFontMetrics().getHeight();
        this.cursor.y = this.cursor.y + (bl ? 2 * n : n);
    }

    protected String comb(String string) {
        string = string.replace('\r', ' ');
        int n = (string = string.replace('\n', ' ')).indexOf("&lt;");
        if (n >= 0) {
            string = String.valueOf(string.substring(0, n)) + '<' + string.substring(n + 4);
            string = this.comb(string);
        }
        if ((n = string.indexOf("&gt;")) >= 0) {
            string = String.valueOf(string.substring(0, n)) + '>' + string.substring(n + 4);
            string = this.comb(string);
        }
        return string;
    }

    protected Color colorByName(String string) {
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("darkGreen")) {
            return new Color(0, 128, 0);
        }
        return Color.black;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.translate(-this.insets.left, -this.insets.top);
        this.activeToken = this.tokenList.seek(point);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.translate(-this.insets.left, -this.insets.top);
        this.activeToken = this.tokenList.seek(point);
    }
}

