/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GVertex
extends GPointObject
implements Serializable {
    public GPoint3D xyzCrds;
    private String label;
    private boolean proper;
    public transient GPoint3D uvwCrds;
    private transient GVertex peer;
    public transient GEdgeList edgeStar;
    private transient boolean selected;
    private transient boolean marked;

    public GVertex(GPoint3D gPoint3D, String string, boolean bl) {
        this.xyzCrds = gPoint3D;
        this.uvwCrds = new GPoint3D();
        this.label = string;
        this.proper = bl;
        this.edgeStar = new GEdgeList();
    }

    public void print() {
        System.out.println(String.valueOf(this.label) + " : X=" + this.xyzCrds.X + " " + "Y=" + this.xyzCrds.Y + " " + "Z=" + this.xyzCrds.Z + " " + this.proper);
    }

    public GPoint3D toPoint3D() {
        return this.xyzCrds;
    }

    public boolean isProper() {
        return this.proper;
    }

    public void setProper(boolean bl) {
        this.proper = bl;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public GVertex getPeer() {
        return this.peer;
    }

    public void setPeer(GVertex gVertex) {
        this.peer = gVertex;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void switchSelection() {
        this.selected = !this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setMarked(boolean bl) {
        this.marked = bl;
    }

    public GPoint3D project(GProjSystem gProjSystem) {
        this.uvwCrds = gProjSystem.xyzToUVW(this.xyzCrds);
        return this.uvwCrds;
    }

    public void stretch(GPoint3D gPoint3D) {
        this.xyzCrds.X *= gPoint3D.X * 0.01;
        this.xyzCrds.Y *= gPoint3D.Y * 0.01;
        this.xyzCrds.Z *= gPoint3D.Z * 0.01;
    }

    public void skew(GPoint3D gPoint3D) {
        if (gPoint3D.X != 0.0) {
            this.xyzCrds.X += this.xyzCrds.Z * Math.tan(gPoint3D.X * Math.PI / 180.0);
            return;
        }
        this.xyzCrds.Y += this.xyzCrds.Z * Math.tan(gPoint3D.Y * Math.PI / 180.0);
    }

    public int getAttitude(GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        double d = GMath.norm(gPoint3D2);
        GPoint3D gPoint3D3 = GMath.subtract(this.xyzCrds, gPoint3D);
        double d2 = GMath.scalarP(gPoint3D3, gPoint3D2) / d;
        if (d2 > 1.0E-5) {
            return 1;
        }
        if (d2 < -1.0E-5) {
            return -1;
        }
        return 0;
    }

    public void move(double[][] dArray, double[][] dArray2, GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        double[][] dArray3 = GMath.times(dArray, GMath.invert(dArray2));
        this.xyzCrds = GMath.add(GMath.times(dArray3, GMath.subtract(this.xyzCrds, gPoint3D2)), gPoint3D);
    }
}

