/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import Typing.ArticlePane;
import Typing.Help;
import Typing.LafDialog;
import Typing.TypingPractice;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;

public class ControlPanel
extends JPanel {
    private JButton find;
    private JButton add;
    private JButton update;
    private JButton delete;
    private JButton cancel;
    private JButton help;
    private JButton save;
    private JButton first;
    private JButton previous;
    private JButton next;
    private JButton last;
    private JButton style;
    private String[] name = new String[]{"Add", "Modify", "Save", "Cancel", "Delete", "Find", "First", "Previous", "Next", "Last", "Style", "Help"};
    private JButton[] button = new JButton[12];
    private JToolBar toolBar;
    private TypingPractice mainFrame;
    private ArticlePane fields;
    private Connection connect;
    private Statement stmt;
    private ResultSet rs;
    private JCheckBoxMenuItem showText;
    private JCheckBoxMenuItem showToolTips;
    private boolean buttonTextFlag;
    private boolean toolTipsFlag;
    private JSeparator vs1;
    private JSeparator vs2;
    private JSeparator vs3;
    private JSeparator vs4;
    private JSeparator vs5;
    private LafDialog lafDialog;
    Help myHelp = new Help();
    JPopupMenu popup;
    JPanel statusBar;
    JLabel status;

    public ControlPanel(Connection connection, ArticlePane articlePane, TypingPractice typingPractice, boolean bl, boolean bl2, String string) {
        this.mainFrame = typingPractice;
        this.fields = articlePane;
        this.connect = connection;
        this.buttonTextFlag = bl;
        this.toolTipsFlag = bl2;
        this.setLayout(new BorderLayout());
        this.statusBar = new JPanel(new BorderLayout());
        this.status = new JLabel();
        this.status.setBorder(new SoftBevelBorder(1));
        this.status.setForeground(Color.black);
        this.statusBar.add((Component)this.status, "Center");
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(true);
        this.lafDialog = new LafDialog(this.mainFrame, string);
        this.vs1 = new JSeparator(1);
        this.vs1.setMaximumSize(new Dimension(this.vs1.getPreferredSize().width, 50));
        this.vs2 = new JSeparator(1);
        this.vs2.setMaximumSize(new Dimension(this.vs2.getPreferredSize().width, 50));
        this.vs3 = new JSeparator(1);
        this.vs3.setMaximumSize(new Dimension(this.vs3.getPreferredSize().width, 50));
        this.vs4 = new JSeparator(1);
        this.vs4.setMaximumSize(new Dimension(this.vs4.getPreferredSize().width, 50));
        this.vs5 = new JSeparator(1);
        this.vs5.setMaximumSize(new Dimension(this.vs5.getPreferredSize().width, 50));
        ButtonHandler buttonHandler = new ButtonHandler();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.checkTrigger(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkTrigger(mouseEvent);
            }

            private void checkTrigger(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ControlPanel.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getSource() == ControlPanel.this.showText) {
                    if (itemEvent.getStateChange() == 1) {
                        ControlPanel.this.setShowButtonText(true);
                    } else {
                        ControlPanel.this.setShowButtonText(false);
                    }
                } else if (itemEvent.getSource() == ControlPanel.this.showToolTips) {
                    if (itemEvent.getStateChange() == 1) {
                        ControlPanel.this.setShowToolTipText(true);
                    } else {
                        ControlPanel.this.setShowToolTipText(false);
                    }
                }
            }
        };
        this.showText = new JCheckBoxMenuItem("Show Text");
        this.showText.addItemListener(itemListener);
        this.showToolTips = new JCheckBoxMenuItem("Show Tool Tips");
        this.showToolTips.addItemListener(itemListener);
        this.popup = new JPopupMenu();
        this.popup.add(this.showText);
        this.popup.add(Box.createHorizontalStrut(20));
        this.popup.add(this.showToolTips);
        Dimension dimension = new Dimension(60, 60);
        Dimension dimension2 = new Dimension(60, 60);
        Dimension dimension3 = new Dimension(60, 60);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEtchedBorder());
        this.add = new JButton(this.name[0], this.createImageIcon("add.gif"));
        Font font = this.add.getFont();
        font = font.deriveFont(0, 11.0f);
        this.add.setPreferredSize(dimension);
        this.add.setMaximumSize(dimension2);
        this.add.setMinimumSize(dimension3);
        this.add.setFont(font);
        this.add.setVerticalTextPosition(3);
        this.add.setHorizontalTextPosition(0);
        this.add.setToolTipText("New article");
        this.add.addActionListener(buttonHandler);
        this.add.addMouseListener(mouseAdapter);
        this.button[0] = this.add;
        this.toolBar.add(this.add);
        this.update = new JButton(this.name[1], this.createImageIcon("update.gif"));
        this.update.setPreferredSize(dimension);
        this.update.setMaximumSize(dimension2);
        this.update.setMinimumSize(dimension3);
        this.update.setFont(font);
        this.update.setVerticalTextPosition(3);
        this.update.setHorizontalTextPosition(0);
        this.update.setToolTipText("Update article");
        this.update.addActionListener(buttonHandler);
        this.update.addMouseListener(mouseAdapter);
        this.button[1] = this.update;
        this.toolBar.add(this.update);
        this.save = new JButton(this.name[2], this.createImageIcon("save.gif"));
        this.save.setPreferredSize(dimension);
        this.save.setMaximumSize(dimension2);
        this.save.setMinimumSize(dimension3);
        this.save.setFont(font);
        this.save.setVerticalTextPosition(3);
        this.save.setHorizontalTextPosition(0);
        this.save.setToolTipText("Save article");
        this.save.addActionListener(buttonHandler);
        this.save.addMouseListener(mouseAdapter);
        this.button[2] = this.save;
        this.toolBar.add(this.save);
        this.toolBar.add(this.vs1);
        this.cancel = new JButton(this.name[3], this.createImageIcon("cancel.gif"));
        this.cancel.setPreferredSize(dimension);
        this.cancel.setMaximumSize(dimension2);
        this.cancel.setMinimumSize(dimension3);
        this.cancel.setFont(font);
        this.cancel.setVerticalTextPosition(3);
        this.cancel.setHorizontalTextPosition(0);
        this.cancel.setToolTipText("Cancel");
        this.cancel.addActionListener(buttonHandler);
        this.cancel.addMouseListener(mouseAdapter);
        this.button[3] = this.cancel;
        this.toolBar.add(this.cancel);
        this.delete = new JButton(this.name[4], this.createImageIcon("delete.gif"));
        this.delete.setPreferredSize(dimension);
        this.delete.setMaximumSize(dimension2);
        this.delete.setMinimumSize(dimension3);
        this.delete.setFont(font);
        this.delete.setVerticalTextPosition(3);
        this.delete.setHorizontalTextPosition(0);
        this.delete.setToolTipText("Delete article");
        this.delete.addActionListener(buttonHandler);
        this.delete.addMouseListener(mouseAdapter);
        this.button[4] = this.delete;
        this.toolBar.add(this.delete);
        this.toolBar.add(this.vs2);
        this.find = new JButton(this.name[5], this.createImageIcon("find.gif"));
        this.find.setPreferredSize(dimension);
        this.find.setMaximumSize(dimension2);
        this.find.setMinimumSize(dimension3);
        this.find.setFont(font);
        this.find.setVerticalTextPosition(3);
        this.find.setHorizontalTextPosition(0);
        this.find.addActionListener(buttonHandler);
        this.find.addMouseListener(mouseAdapter);
        this.find.setToolTipText("Find article");
        this.button[5] = this.find;
        this.toolBar.add(this.find);
        this.first = new JButton(this.name[6], this.createImageIcon("first.gif"));
        this.first.setPreferredSize(dimension);
        this.first.setMaximumSize(dimension2);
        this.first.setMinimumSize(dimension3);
        this.first.setFont(font);
        this.first.setVerticalTextPosition(3);
        this.first.setHorizontalTextPosition(0);
        this.first.setToolTipText("First");
        this.first.addActionListener(buttonHandler);
        this.first.addMouseListener(mouseAdapter);
        this.button[6] = this.first;
        this.toolBar.add(this.first);
        this.previous = new JButton(this.name[7], this.createImageIcon("previous.gif"));
        this.previous.setPreferredSize(dimension);
        this.previous.setMaximumSize(dimension2);
        this.previous.setMinimumSize(dimension3);
        this.previous.setFont(font);
        this.previous.setVerticalTextPosition(3);
        this.previous.setHorizontalTextPosition(0);
        this.previous.setToolTipText("Previous");
        this.previous.addActionListener(buttonHandler);
        this.previous.addMouseListener(mouseAdapter);
        this.button[7] = this.previous;
        this.toolBar.add(this.previous);
        this.next = new JButton(this.name[8], this.createImageIcon("next.gif"));
        this.next.setPreferredSize(dimension);
        this.next.setMaximumSize(dimension2);
        this.next.setMinimumSize(dimension3);
        this.next.setFont(font);
        this.next.setVerticalTextPosition(3);
        this.next.setHorizontalTextPosition(0);
        this.next.setToolTipText("Next");
        this.next.addActionListener(buttonHandler);
        this.next.addMouseListener(mouseAdapter);
        this.button[8] = this.next;
        this.toolBar.add(this.next);
        this.last = new JButton(this.name[9], this.createImageIcon("last.gif"));
        this.last.setPreferredSize(dimension);
        this.last.setMaximumSize(dimension2);
        this.last.setMinimumSize(dimension3);
        this.last.setFont(font);
        this.last.setVerticalTextPosition(3);
        this.last.setHorizontalTextPosition(0);
        this.last.setToolTipText("Last");
        this.last.addActionListener(buttonHandler);
        this.last.addMouseListener(mouseAdapter);
        this.button[9] = this.last;
        this.toolBar.add(this.last);
        this.toolBar.add(this.vs3);
        this.style = new JButton(this.name[10], this.createImageIcon("style.gif"));
        this.style.setPreferredSize(dimension);
        this.style.setMaximumSize(dimension2);
        this.style.setMinimumSize(dimension3);
        this.style.setVerticalTextPosition(3);
        this.style.setHorizontalTextPosition(0);
        this.style.setFont(font);
        this.style.setToolTipText("Look And Feel");
        this.style.addActionListener(buttonHandler);
        this.style.addMouseListener(mouseAdapter);
        this.button[10] = this.style;
        this.toolBar.add(this.style);
        this.toolBar.add(this.vs4);
        this.help = new JButton(this.name[11], this.createImageIcon("help.gif"));
        this.help.setPreferredSize(dimension);
        this.help.setMaximumSize(dimension2);
        this.help.setMinimumSize(dimension3);
        this.help.setVerticalTextPosition(3);
        this.help.setHorizontalTextPosition(0);
        this.help.setFont(font);
        this.help.setToolTipText("Help");
        this.help.addMouseListener(mouseAdapter);
        this.button[11] = this.help;
        this.help.addActionListener(buttonHandler);
        this.toolBar.add(this.help);
        this.toolBar.add(this.vs5);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.toolBar.addMouseListener(mouseAdapter);
        this.add((Component)this.toolBar, "North");
        this.setBorder(new EtchedBorder(1));
        this.fields.enableEditFields(false);
        this.save.setEnabled(false);
        this.cancel.setEnabled(false);
        if (this.buttonTextFlag) {
            this.setShowButtonText(true);
            this.setButtonTextItemSelected(true);
        } else {
            this.setShowButtonText(false);
            this.setButtonTextItemSelected(false);
        }
        if (this.toolTipsFlag) {
            this.setShowToolTipText(true);
            this.setToolTipsItemSelected(true);
        } else {
            this.setShowToolTipText(false);
            this.setToolTipsItemSelected(false);
        }
        try {
            this.stmt = this.connect.createStatement(1004, 1007);
            this.rs = this.stmt.executeQuery("SELECT * FROM topic");
            if (this.rs.next()) {
                this.display(this.rs);
                if (this.isOnlyOneData()) {
                    this.enableBowserBar(false);
                } else {
                    this.enableForwardBar(false);
                }
            } else {
                this.update.setEnabled(false);
                this.delete.setEnabled(false);
                this.enableBowserBar(false);
            }
            this.status.setText("Database connection successful !!!");
        }
        catch (Exception exception) {
            this.status.setText("Database connection fail !!!");
        }
    }

    public void display(ResultSet resultSet) {
        try {
            this.fields.noField.setText(resultSet.getString(1));
            this.fields.contentArea.setText(resultSet.getString(2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setShowButtonText(boolean bl) {
        this.buttonTextFlag = bl;
        if (bl) {
            int n = 0;
            while (n < this.button.length) {
                this.button[n].setText(this.name[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.button.length) {
                this.button[n].setText("");
                ++n;
            }
        }
    }

    public void setShowToolTipText(boolean bl) {
        this.toolTipsFlag = bl;
        ToolTipManager.sharedInstance().setEnabled(bl);
    }

    public boolean getShowTextItemState() {
        return this.buttonTextFlag;
    }

    public boolean getShowToolTipsItemState() {
        return this.toolTipsFlag;
    }

    public String getLookAndFeelState() {
        return this.lafDialog.getCurrentLookAndFeel();
    }

    public LafDialog getLafDialog() {
        return this.lafDialog;
    }

    public void setButtonTextItemSelected(boolean bl) {
        this.showText.setSelected(bl);
    }

    public void setToolTipsItemSelected(boolean bl) {
        this.showToolTips.setSelected(bl);
    }

    private void updateResultSet() throws SQLException {
        this.rs = this.stmt.executeQuery("SELECT * from topic ");
    }

    private void positionCurrentRow(String string) {
        try {
            this.rs.afterLast();
            while (this.rs.previous()) {
                String string2 = this.rs.getString(1);
                if (!string2.equalsIgnoreCase(string)) continue;
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void enableBowserBar(boolean bl) {
        this.first.setEnabled(bl);
        this.previous.setEnabled(bl);
        this.next.setEnabled(bl);
        this.last.setEnabled(bl);
    }

    private void enableForwardBar(boolean bl) {
        this.first.setEnabled(bl);
        this.previous.setEnabled(bl);
    }

    private void enableBackwardBar(boolean bl) {
        this.next.setEnabled(bl);
        this.last.setEnabled(bl);
    }

    private boolean isOnlyOneData() throws SQLException {
        return this.rs.isLast() && this.rs.isFirst();
    }

    private boolean hasData() throws SQLException {
        Statement statement = this.connect.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * from topic ");
        return resultSet.next();
    }

    private ImageIcon createImageIcon(String string) {
        String string2 = "images/" + string;
        return new ImageIcon(this.getClass().getResource(string2));
    }

    private String checkString(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = "'";
        n = string.indexOf(string2);
        while (n >= 0) {
            stringBuffer.insert(n, string2);
            string = stringBuffer.toString();
            n += 2;
            n = string.indexOf(string2, n);
        }
        return string;
    }

    private class ButtonHandler
    implements ActionListener {
        boolean updateStatus = false;

        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block72: {
                ControlPanel.this.status.setText(" ");
                if (actionEvent.getSource() == ControlPanel.this.add) {
                    ControlPanel.this.save.setEnabled(true);
                    ControlPanel.this.cancel.setEnabled(true);
                    ControlPanel.this.add.setEnabled(false);
                    ControlPanel.this.update.setEnabled(false);
                    ControlPanel.this.delete.setEnabled(false);
                    ControlPanel.this.enableBowserBar(false);
                    ControlPanel.this.fields.enableEditFields(true);
                    ((ControlPanel)ControlPanel.this).fields.noField.setText("");
                    ((ControlPanel)ControlPanel.this).fields.contentArea.setText("");
                    ((ControlPanel)ControlPanel.this).fields.noField.requestFocus();
                } else if (actionEvent.getSource() == ControlPanel.this.save) {
                    try {
                        Statement statement = ControlPanel.this.connect.createStatement();
                        if (!this.updateStatus) {
                            if (((ControlPanel)ControlPanel.this).fields.noField.getText().equals("")) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Enter at least Subject number", "Warning", 1);
                                ((ControlPanel)ControlPanel.this).fields.noField.requestFocus();
                                return;
                            }
                            String string = ((ControlPanel)ControlPanel.this).fields.contentArea.getText();
                            string = ControlPanel.this.checkString(string);
                            String string2 = "INSERT INTO topic VALUES ('" + ((ControlPanel)ControlPanel.this).fields.noField.getText().trim() + "','" + string + "')";
                            int n = statement.executeUpdate(string2);
                            ControlPanel.this.connect.commit();
                            ControlPanel.this.updateResultSet();
                            ControlPanel.this.positionCurrentRow(((ControlPanel)ControlPanel.this).fields.noField.getText());
                            ControlPanel.this.display(ControlPanel.this.rs);
                            statement.close();
                            ControlPanel.this.delete.setEnabled(true);
                            ControlPanel.this.status.setText("Adding successful .");
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ ButtonHandler this$1;
                                {
                                    this.this$1 = buttonHandler;
                                }

                                public void run() {
                                    try {
                                        if (ControlPanel.access$1700(ButtonHandler.access$1600(this.this$1))) {
                                            ControlPanel.access$800(ButtonHandler.access$1600(this.this$1), false);
                                        } else if (!ControlPanel.access$1400(ButtonHandler.access$1600(this.this$1)).isLast()) {
                                            ControlPanel.access$800(ButtonHandler.access$1600(this.this$1), true);
                                        } else {
                                            ControlPanel.access$1800(ButtonHandler.access$1600(this.this$1), true);
                                            ControlPanel.access$1900(ButtonHandler.access$1600(this.this$1), false);
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        // empty catch block
                                    }
                                }
                            });
                        } else {
                            if (((ControlPanel)ControlPanel.this).fields.noField.getText().equals("")) {
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Enter at least Subject number", "Warning", 1);
                                ((ControlPanel)ControlPanel.this).fields.noField.requestFocus();
                                return;
                            }
                            String string = ((ControlPanel)ControlPanel.this).fields.contentArea.getText();
                            string = ControlPanel.this.checkString(string);
                            String string3 = "UPDATE topic SET article = '" + string + "' WHERE subject_no='" + ((ControlPanel)ControlPanel.this).fields.noField.getText() + "'";
                            int n = statement.executeUpdate(string3);
                            ControlPanel.this.connect.commit();
                            ControlPanel.this.updateResultSet();
                            ControlPanel.this.positionCurrentRow(((ControlPanel)ControlPanel.this).fields.noField.getText());
                            this.updateStatus = !this.updateStatus;
                            statement.close();
                            ControlPanel.this.delete.setEnabled(true);
                            ControlPanel.this.status.setText("Update successful .");
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ ButtonHandler this$1;
                                {
                                    this.this$1 = buttonHandler;
                                }

                                public void run() {
                                    try {
                                        if (ControlPanel.access$1700(ButtonHandler.access$1600(this.this$1))) {
                                            ControlPanel.access$800(ButtonHandler.access$1600(this.this$1), false);
                                        } else if (ControlPanel.access$1400(ButtonHandler.access$1600(this.this$1)).isLast()) {
                                            ControlPanel.access$1900(ButtonHandler.access$1600(this.this$1), false);
                                            ControlPanel.access$1800(ButtonHandler.access$1600(this.this$1), true);
                                        } else if (ControlPanel.access$1400(ButtonHandler.access$1600(this.this$1)).isFirst()) {
                                            ControlPanel.access$1800(ButtonHandler.access$1600(this.this$1), false);
                                            ControlPanel.access$1900(ButtonHandler.access$1600(this.this$1), true);
                                        } else {
                                            ControlPanel.access$800(ButtonHandler.access$1600(this.this$1), true);
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        if (!ControlPanel.this.update.isEnabled()) {
                            ControlPanel.this.update.setEnabled(true);
                        }
                        ControlPanel.this.save.setEnabled(false);
                        ControlPanel.this.add.setEnabled(true);
                        ControlPanel.this.fields.enableEditFields(false);
                        ControlPanel.this.cancel.setEnabled(false);
                    }
                    catch (Exception exception) {
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Should not permit duplicates at subject field\nor other critical error.\nAdd record fail !!!", "ERROR", 0);
                        ((ControlPanel)ControlPanel.this).fields.noField.requestFocus();
                        ((ControlPanel)ControlPanel.this).fields.noField.setSelectionStart(0);
                        ((ControlPanel)ControlPanel.this).fields.noField.setSelectionEnd(((ControlPanel)ControlPanel.this).fields.noField.getText().length());
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.update) {
                    this.updateStatus = !this.updateStatus;
                    ControlPanel.this.update.setEnabled(false);
                    ControlPanel.this.save.setEnabled(true);
                    ControlPanel.this.cancel.setEnabled(true);
                    ((ControlPanel)ControlPanel.this).fields.contentArea.setEditable(true);
                    ((ControlPanel)ControlPanel.this).fields.contentArea.requestFocus();
                    ControlPanel.this.add.setEnabled(false);
                    ControlPanel.this.delete.setEnabled(false);
                    ControlPanel.this.enableBowserBar(false);
                } else if (actionEvent.getSource() == ControlPanel.this.delete) {
                    int n = JOptionPane.showConfirmDialog(ControlPanel.this.mainFrame, "Are you sure delete ?", "Confirm Dialog", 0);
                    if (n == 1) {
                        return;
                    }
                    try {
                        Statement statement = ControlPanel.this.connect.createStatement();
                        String string = "DELETE FROM topic WHERE SUBJECT_NO='" + ((ControlPanel)ControlPanel.this).fields.noField.getText() + "'";
                        int n2 = statement.executeUpdate(string);
                        ControlPanel.this.status.setText("Delete successful .");
                        if (ControlPanel.this.isOnlyOneData()) {
                            ((ControlPanel)ControlPanel.this).fields.noField.setText("");
                            ((ControlPanel)ControlPanel.this).fields.contentArea.setText("");
                            ControlPanel.this.connect.commit();
                            ControlPanel.this.updateResultSet();
                            ControlPanel.this.delete.setEnabled(false);
                            ControlPanel.this.enableBowserBar(false);
                        } else if (ControlPanel.this.rs.isLast()) {
                            ControlPanel.this.rs.previous();
                            String string4 = ControlPanel.this.rs.getString(1);
                            ControlPanel.this.connect.commit();
                            ControlPanel.this.updateResultSet();
                            ControlPanel.this.positionCurrentRow(string4);
                            ControlPanel.this.display(ControlPanel.this.rs);
                            if (ControlPanel.this.isOnlyOneData()) {
                                ControlPanel.this.enableBowserBar(false);
                            } else {
                                ControlPanel.this.enableBackwardBar(false);
                            }
                        } else {
                            ControlPanel.this.rs.next();
                            if (ControlPanel.this.rs.isLast()) {
                                ControlPanel.this.enableBackwardBar(false);
                            }
                            String string5 = ControlPanel.this.rs.getString(1);
                            ControlPanel.this.connect.commit();
                            ControlPanel.this.updateResultSet();
                            ControlPanel.this.positionCurrentRow(string5);
                            ControlPanel.this.display(ControlPanel.this.rs);
                        }
                        if (!ControlPanel.this.hasData()) {
                            ControlPanel.this.update.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.cancel) {
                    ((ControlPanel)ControlPanel.this).fields.noField.setText("");
                    ((ControlPanel)ControlPanel.this).fields.contentArea.setText("");
                    ControlPanel.this.add.setEnabled(true);
                    ControlPanel.this.save.setEnabled(false);
                    ControlPanel.this.cancel.setEnabled(false);
                    ControlPanel.this.fields.enableEditFields(false);
                    try {
                        if (ControlPanel.this.isOnlyOneData()) {
                            ControlPanel.this.enableBowserBar(false);
                        } else if (ControlPanel.this.rs.isLast()) {
                            ControlPanel.this.enableBackwardBar(false);
                            ControlPanel.this.enableForwardBar(true);
                        } else if (ControlPanel.this.rs.isFirst()) {
                            ControlPanel.this.rs.absolute(1);
                            ControlPanel.this.enableForwardBar(false);
                            ControlPanel.this.enableBackwardBar(true);
                        } else {
                            ControlPanel.this.enableBowserBar(true);
                        }
                        if (!ControlPanel.this.hasData()) {
                            ControlPanel.this.delete.setEnabled(false);
                            ControlPanel.this.enableBowserBar(false);
                            ControlPanel.this.update.setEnabled(false);
                            break block72;
                        }
                        ControlPanel.this.display(ControlPanel.this.rs);
                        ControlPanel.this.delete.setEnabled(true);
                        ControlPanel.this.update.setEnabled(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.find) {
                    String string;
                    while (true) {
                        if ((string = JOptionPane.showInputDialog(ControlPanel.this.mainFrame, (Object)"Please enter subject number :")) == null) {
                            return;
                        }
                        if (!string.equals("")) break;
                        Toolkit.getDefaultToolkit().beep();
                        JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Field no data !", "Error", 0);
                    }
                    try {
                        if (!ControlPanel.this.hasData()) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Database no data.");
                            return;
                        }
                        int n = ControlPanel.this.rs.getRow();
                        boolean bl = false;
                        ControlPanel.this.rs.beforeFirst();
                        while (ControlPanel.this.rs.next()) {
                            String string6 = ControlPanel.this.rs.getString(1);
                            if (!string6.equals(string)) continue;
                            String string7 = ControlPanel.this.rs.getString(2);
                            ControlPanel.this.display(ControlPanel.this.rs);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(ControlPanel.this.mainFrame, "Not found !");
                            ControlPanel.this.rs.absolute(n);
                            break block72;
                        }
                        if (ControlPanel.this.isOnlyOneData()) {
                            ControlPanel.this.enableBowserBar(false);
                            break block72;
                        }
                        if (ControlPanel.this.rs.isLast()) {
                            ControlPanel.this.enableBackwardBar(false);
                            ControlPanel.this.enableForwardBar(true);
                            break block72;
                        }
                        if (ControlPanel.this.rs.isFirst()) {
                            ControlPanel.this.enableForwardBar(false);
                            ControlPanel.this.enableBackwardBar(true);
                            break block72;
                        }
                        ControlPanel.this.enableBowserBar(true);
                    }
                    catch (SQLException sQLException) {}
                } else if (actionEvent.getSource() == ControlPanel.this.first) {
                    try {
                        ControlPanel.this.rs.first();
                        ControlPanel.this.enableForwardBar(false);
                        ControlPanel.this.enableBackwardBar(true);
                        ControlPanel.this.display(ControlPanel.this.rs);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.previous) {
                    try {
                        ControlPanel.this.enableBackwardBar(true);
                        if (ControlPanel.this.rs.previous()) {
                            if (ControlPanel.this.rs.isFirst()) {
                                ControlPanel.this.enableForwardBar(false);
                            }
                            ControlPanel.this.display(ControlPanel.this.rs);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.next) {
                    try {
                        ControlPanel.this.enableForwardBar(true);
                        if (ControlPanel.this.rs.next()) {
                            if (ControlPanel.this.rs.isLast()) {
                                ControlPanel.this.enableBackwardBar(false);
                            }
                            ControlPanel.this.display(ControlPanel.this.rs);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.last) {
                    try {
                        ControlPanel.this.rs.last();
                        ControlPanel.this.enableBackwardBar(false);
                        ControlPanel.this.enableForwardBar(true);
                        ControlPanel.this.display(ControlPanel.this.rs);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (actionEvent.getSource() == ControlPanel.this.style) {
                    ControlPanel.this.lafDialog.setVisible(true);
                } else if (actionEvent.getSource() == ControlPanel.this.help) {
                    ControlPanel.this.myHelp.show();
                }
            }
        }

        static /* synthetic */ ControlPanel access$1600(ButtonHandler buttonHandler) {
            return buttonHandler.ControlPanel.this;
        }
    }
}

