/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GAnswer
implements Serializable {
    public static final int NO_ID = -1;
    public static final int NUMBER_TYPE = 0;
    public static final int STATIC_TYPE = 1;
    public static final int CONDSECT_TYPE = 2;
    public static final int RATIO_ANGLE = 0;
    public static final int LENGTH = 1;
    public static final int AREA = 2;
    public static final int VOLUME = 3;
    public static final String[] numberDimWording = new String[]{"Ratio, Angle", "Length", "Area", "Volume"};
    public static final int POINT = 0;
    public static final int LINE = 1;
    public static final int BROKEN_LINE = 2;
    public static final int SECTION = 3;
    public static final String[] staticDimWording = new String[]{"Point", "Line", "Broken Line", "Section"};
    public static final int N_A = 0;
    public static final int THROUGH_POINT = 1;
    public static final int THROUGH_LINE = 2;
    public static final int NOT_THROUGH_POINT = 3;
    public static final int NOT_THROUGH_LINE = 4;
    public static final int THROUGH_NOVERTEX = 5;
    public static final int THROUGH_NOEDGE = 6;
    public static final int PARAL_LINE = 7;
    public static final int PARAL_PLANE = 8;
    public static final int PERP_LINE = 9;
    public static final int PERP_PLANE = 10;
    public static final String[] sectPassWording = new String[]{"N/A", "Through Point", "Through Line", "Not Through Point", "Not Through Line", "Through No Vertex", "Through No Edge", "Parallel To Line", "Parallel To Plane", "Perp To Line", "Perp To Plane"};
    public static final boolean[] sectPassNeedsValue;
    public static final int IN_HALF = 1;
    public static final int IN_RATIO = 2;
    public static final String[] volumeCutWording;
    public static final boolean[] volumeCutNeedsValue;
    public static final int ISO_TRI = 1;
    public static final int RECT_TRI = 2;
    public static final int EQUI_TRI = 3;
    public static final int PARALLELOGRAM = 4;
    public static final int RHOMBUS = 5;
    public static final int RECTANGLE = 6;
    public static final int SQUARE = 7;
    public static final String[] sectShapeWording;
    public static final String GOOD = "You gave a correct answer. Congratulations!";
    public static final String BAD = "Sorry! Your answer is incorrect";
    private int type = 0;
    private int numberDim;
    private int staticDim;
    private int sectPass;
    private int volumeCut;
    private int sectShape;
    private String solidName;
    private String staticValue;
    private String sectPassValue;
    private double numberValue = 0.0;
    private double volumeCutValue;
    private GPoint3DList staticList;
    private GPoint3DList sectPassList;

    public void print() {
        String string = new String();
        string = String.valueOf(string) + "type = " + this.type + '\n';
        string = String.valueOf(string) + "numberDim = " + this.numberDim + '\n';
        string = String.valueOf(string) + "staticDim = " + this.staticDim + '\n';
        string = String.valueOf(string) + "sectPass = " + this.sectPass + '\n';
        string = String.valueOf(string) + "volumeCut = " + this.volumeCut + '\n';
        string = String.valueOf(string) + "sectShape = " + this.sectShape + '\n';
        string = String.valueOf(string) + "solidName = " + this.solidName + '\n';
        string = String.valueOf(string) + "staticValue = " + this.staticValue + '\n';
        string = String.valueOf(string) + "sectPassValue = " + this.sectPassValue + '\n';
        string = String.valueOf(string) + "numberValue = " + this.numberValue + '\n';
        string = String.valueOf(string) + "volumeCutValue = " + this.volumeCutValue + '\n';
        System.out.println(string);
        this.staticList.print();
        this.sectPassList.print();
    }

    public int getType() {
        return this.type;
    }

    public int getNumberDim() {
        return this.numberDim;
    }

    public double getNumberValue() {
        return this.numberValue;
    }

    public String getSolidName() {
        return this.solidName;
    }

    public void setSolidName(String string) {
        this.solidName = string;
    }

    public int getStaticDim() {
        return this.staticDim;
    }

    public String getStaticValue() {
        return this.staticValue;
    }

    public int getSectPass() {
        return this.sectPass;
    }

    public String getSectPassValue() {
        if (sectPassNeedsValue[this.sectPass]) {
            return this.sectPassValue;
        }
        return null;
    }

    public int getVolumeCut() {
        return this.volumeCut;
    }

    public double getVolumeCutValue() {
        if (volumeCutNeedsValue[this.volumeCut]) {
            return this.volumeCutValue;
        }
        return 0.0;
    }

    public int getSectShape() {
        return this.sectShape;
    }

    protected int getID(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String setNumber(GProblem gProblem, GNotepad gNotepad, String string, String string2) {
        double d;
        if (string2.length() == 0) {
            return "No value provided for " + string;
        }
        Object object = gNotepad.seekDoubleObject(string2);
        if (object == null) {
            return "Wrong number format or incorrect variable reference: " + string2;
        }
        double d2 = d = object instanceof GVariable ? ((GVariable)object).getValue() : ((Double)object).doubleValue();
        if (d <= 0.0) {
            return "Answer must be a positive number";
        }
        this.type = 0;
        this.numberDim = this.getID(numberDimWording, string);
        this.numberValue = d;
        return null;
    }

    public String checkNumber(GProblem gProblem, GNotepad gNotepad, String string) {
        double d;
        if (string.length() == 0) {
            return "No answer given";
        }
        Object object = gNotepad.seekDoubleObject(string);
        if (object == null) {
            return "Wrong number format or incorrect variable reference: " + string;
        }
        double d2 = d = object instanceof GVariable ? ((GVariable)object).getValue() : ((Double)object).doubleValue();
        if (d <= 0.0) {
            return "Answer must be a positive number";
        }
        double d3 = this.numberValue;
        double d4 = gProblem.getScaleFactor();
        if (this.numberDim == 1) {
            d3 *= d4;
        } else if (this.numberDim == 2) {
            d3 *= d4 * d4;
        } else if (this.numberDim == 3) {
            d3 *= d4 * d4 * d4;
        }
        if (GMath.areEqual(d, d3)) {
            return GOOD;
        }
        return BAD;
    }

    public String setStatic(GProblem gProblem, String string, String string2, String string3) {
        GSolid gSolid = gProblem.solidWndList.seek(string).getSolid();
        int n = this.getID(staticDimWording, string2);
        if (string3.length() == 0) {
            return "No value provided for " + string2;
        }
        Object object = this.staticValueToList(gSolid, string, n, string3);
        if (object instanceof String) {
            return (String)object;
        }
        this.type = 1;
        this.solidName = string;
        this.staticDim = n;
        this.staticList = (GPoint3DList)object;
        this.staticValue = string3;
        return null;
    }

    protected Object staticValueToList(GSolid gSolid, String string, int n, String string2) {
        Object object = gSolid.checkPath(string2, new GPoint3DList());
        if (object instanceof String) {
            return "No point labeled " + (String)object + " found in " + string;
        }
        GPoint3DList gPoint3DList = (GPoint3DList)object;
        if (n == 0) {
            if (gPoint3DList.getDim() > 1) {
                return "No point labeled " + string2 + " found in " + string;
            }
        } else if (n == 1) {
            if (!this.isLine(gPoint3DList)) {
                return "No line labeled " + string2 + " found in " + string;
            }
        } else if (n == 2) {
            if (!this.isBrokenLine(gPoint3DList)) {
                return "No broken line labeled " + string2 + " found in " + string;
            }
        } else if ((gPoint3DList = this.isPlane(gPoint3DList)) == null) {
            return "Could reference no plane " + string2 + " in " + string;
        }
        return gPoint3DList;
    }

    public String checkStatic(GProblem gProblem, String string, String string2) {
        GSolid gSolid = gProblem.solidWndList.seek(string2).getSolid();
        double d = gSolid.getXYZDiameter();
        if (this.staticDim == 0 || this.staticDim == 1 || this.staticDim == 2) {
            GPoint3DList gPoint3DList = new GPoint3DList();
            if (string.length() == 0) {
                return "No answer given";
            }
            if (string2.indexOf(this.solidName) != 0) {
                return String.valueOf(string2) + " does not appear related to " + this.solidName;
            }
            Object object = gSolid.checkPath(string, new GPoint3DList());
            if (object instanceof String) {
                return "No point labeled " + (String)object + " found in " + string2;
            }
            gPoint3DList = (GPoint3DList)object;
            if (this.staticDim == 0) {
                if (gPoint3DList.getDim() > 1) {
                    return "No point labeled " + string + " found in " + string2;
                }
            } else if (this.staticDim == 1) {
                if (!this.isLine(gPoint3DList)) {
                    return "No line labeled " + string + " found in " + string2;
                }
            } else if (this.staticDim == 2 && !this.isBrokenLine(gPoint3DList)) {
                return "No broken line labeled " + string + " found in " + string2;
            }
            if (gPoint3DList.getDim() != this.staticList.getDim()) {
                return BAD;
            }
            GPoint3DNode gPoint3DNode = gPoint3DList.getHead();
            GPoint3DNode gPoint3DNode2 = this.staticList.getHead();
            while (gPoint3DNode != null) {
                if (!GMath.isAt(gPoint3DNode.getPoint3D(), gPoint3DNode2.getPoint3D(), d)) break;
                gPoint3DNode = gPoint3DNode.getNext();
                gPoint3DNode2 = gPoint3DNode2.getNext();
            }
            if (gPoint3DNode == null) {
                return GOOD;
            }
            gPoint3DNode = gPoint3DList.getTail();
            gPoint3DNode2 = this.staticList.getHead();
            while (gPoint3DNode != null) {
                if (!GMath.isAt(gPoint3DNode.getPoint3D(), gPoint3DNode2.getPoint3D(), d)) break;
                gPoint3DNode = gPoint3DNode.getPrev();
                gPoint3DNode2 = gPoint3DNode2.getNext();
            }
            if (gPoint3DNode == null) {
                return GOOD;
            }
            return BAD;
        }
        GFacet gFacet = gSolid.facetList.getTail().getFacet();
        GPoint3D gPoint3D = gFacet.getXYZNormal();
        GPoint3D gPoint3D2 = this.staticList.getHead().getPoint3D();
        GPoint3D gPoint3D3 = this.staticList.getTail().getPoint3D();
        if (gFacet.contains(gPoint3D2) && GMath.areCollinear(gPoint3D, gPoint3D3)) {
            return GOOD;
        }
        return BAD;
    }

    public String setCondSect(GProblem gProblem, GNotepad gNotepad, String string, String string2, String string3, String string4, String string5, String string6) {
        int n;
        GSolid gSolid = gProblem.solidWndList.seek(string).getSolid();
        double d = 0.0;
        Object object = null;
        int n2 = this.getID(sectPassWording, string2);
        if (sectPassNeedsValue[n2]) {
            if (string3.length() == 0) {
                return "No value provided for " + string2;
            }
            object = this.sectPassValueToList(gSolid, string, n2, string3);
            if (object instanceof String) {
                return (String)object;
            }
        }
        if (volumeCutNeedsValue[n = this.getID(volumeCutWording, string4)]) {
            if (string5.length() == 0) {
                return "No value provided for " + string4;
            }
            Object object2 = gNotepad.seekDoubleObject(string5);
            if (object2 == null) {
                return "Wrong number format or incorrect variable reference: " + string5;
            }
            double d2 = d = object2 instanceof GVariable ? ((GVariable)object2).getValue() : ((Double)object2).doubleValue();
            if (d <= 0.0) {
                return "Ratio must be a positive number";
            }
        }
        int n3 = this.getID(sectShapeWording, string6);
        this.type = 2;
        this.solidName = string;
        this.sectPass = n2;
        this.sectPassValue = string3;
        this.sectPassList = (GPoint3DList)object;
        this.volumeCut = n;
        this.volumeCutValue = d;
        this.sectShape = n3;
        return null;
    }

    protected Object sectPassValueToList(GSolid gSolid, String string, int n, String string2) {
        Object object = gSolid.checkPath(string2, new GPoint3DList());
        if (object instanceof String) {
            return "No point labeled " + (String)object + " found in " + string;
        }
        GPoint3DList gPoint3DList = (GPoint3DList)object;
        if (n == 1 || n == 3) {
            if (gPoint3DList.getDim() > 1) {
                return "No point labeled " + string2 + " found in " + string;
            }
        } else if (n == 2 || n == 4 || n == 7 || n == 9) {
            if (!this.isLine(gPoint3DList)) {
                return "No line labeled " + string2 + " found in " + string;
            }
        } else if ((n == 8 || n == 10) && (gPoint3DList = this.isPlane(gPoint3DList)) == null) {
            return "Could reference no plane " + string2 + " in " + string;
        }
        return gPoint3DList;
    }

    public String checkCondSect(GProblem gProblem, String string) {
        double d;
        double d2;
        GPoint3D gPoint3D;
        GPoint3D gPoint3D2;
        Serializable serializable;
        Serializable serializable2;
        GSolid gSolid = gProblem.solidWndList.seek(this.solidName).getSolid();
        GSolid gSolid2 = gProblem.solidWndList.seek(string).getSolid();
        double d3 = gSolid2.getXYZDiameter();
        GFacet gFacet = gSolid2.facetList.getTail().getFacet();
        GPoint3D gPoint3D3 = gFacet.getXYZNormal();
        if (this.sectPass == 1 || this.sectPass == 2) {
            if (!gFacet.contains(this.sectPassList)) {
                return BAD;
            }
        } else if (this.sectPass == 3 || this.sectPass == 4) {
            if (gFacet.contains(this.sectPassList)) {
                return BAD;
            }
        } else if (this.sectPass == 5) {
            serializable2 = gFacet.edgeList.getHead();
            while (serializable2 != null) {
                GEdge gEdge = ((GEdgeNode)serializable2).getEdge();
                if (gEdge.twin != null) {
                    serializable = ((GEdgeNode)serializable2).getEdge().getHead();
                    GVertexNode gVertexNode = gSolid.vertexList.getHead();
                    while (gVertexNode != null) {
                        GVertex gVertex = gVertexNode.getVertex();
                        if (!gVertex.isProper()) break;
                        if (GMath.isAt((GVertex)serializable, gVertex.xyzCrds, d3)) {
                            return BAD;
                        }
                        gVertexNode = gVertexNode.getNext();
                    }
                    serializable2 = ((GEdgeNode)serializable2).getNext();
                    continue;
                }
                break;
            }
        } else if (this.sectPass == 6) {
            serializable2 = gSolid.facetList.getHead();
            while (serializable2 != null) {
                GEdgeNode gEdgeNode = ((GFacetNode)serializable2).getFacet().edgeList.getHead();
                while (gEdgeNode != null) {
                    serializable = gEdgeNode.getEdge();
                    if (((GEdge)serializable).twin == null) break;
                    GPoint3DList gPoint3DList = new GPoint3DList();
                    gPoint3DList.addToTail(((GEdge)serializable).getHead().xyzCrds);
                    gPoint3DList.addToTail(((GEdge)serializable).getTail().xyzCrds);
                    if (gFacet.contains(gPoint3DList)) {
                        return BAD;
                    }
                    gEdgeNode = gEdgeNode.getNext();
                }
                serializable2 = ((GFacetNode)serializable2).getNext();
            }
        } else if (this.sectPass == 7 ? !GMath.areOrthogonal(gPoint3D2 = GMath.subtract(((GPoint3DNode)(serializable2 = this.sectPassList.getHead())).getNext().getPoint3D(), ((GPoint3DNode)serializable2).getPoint3D()), gPoint3D3) : (this.sectPass == 8 ? !GMath.areCollinear(gPoint3D3, this.sectPassList.getTail().getPoint3D()) : (this.sectPass == 9 ? !GMath.areCollinear(gPoint3D = GMath.subtract(((GPoint3DNode)(serializable2 = this.sectPassList.getHead())).getNext().getPoint3D(), ((GPoint3DNode)serializable2).getPoint3D()), gPoint3D3) : this.sectPass == 10 && !GMath.areOrthogonal(gPoint3D3, this.sectPassList.getTail().getPoint3D())))) {
            return BAD;
        }
        if (this.volumeCut == 1 ? !GMath.areEqual(gSolid2.computeVolume(), 0.5 * gSolid.computeVolume()) : this.volumeCut == 2 && !GMath.areEqual(d2 = 1.0 / (this.volumeCutValue + 1.0), d = gSolid2.computeVolume() / gSolid.computeVolume()) && !GMath.areEqual(d2, 1.0 - d)) {
            return BAD;
        }
        if (this.sectShape == 1 ? !gFacet.isIsoTriangle() : (this.sectShape == 2 ? !gFacet.isRectTriangle() : (this.sectShape == 3 ? !gFacet.isEquiTriangle() : (this.sectShape == 4 ? !gFacet.isParallelogram() : (this.sectShape == 5 ? !gFacet.isRhombus() : (this.sectShape == 6 ? !gFacet.isRectangle() : this.sectShape == 7 && !gFacet.isSquare())))))) {
            return BAD;
        }
        return GOOD;
    }

    public String validate(GProblem gProblem) {
        Object object;
        if (this.type == 0) {
            if (this.numberValue <= 0.0) {
                return "Answer must be a positive number";
            }
            return null;
        }
        if (this.solidName == null) {
            return "Answer related to no solid";
        }
        GSolidWindow gSolidWindow = gProblem.solidWndList.seek(this.solidName);
        if (gSolidWindow == null) {
            return "Answer related to no solid";
        }
        GSolid gSolid = gSolidWindow.getSolid();
        if (this.type == 1) {
            return null;
        }
        if (sectPassNeedsValue[this.sectPass] && (object = this.sectPassValueToList(gSolid, this.solidName, this.sectPass, this.sectPassValue)) instanceof String) {
            return (String)object;
        }
        if (volumeCutNeedsValue[this.volumeCut] && this.volumeCutValue <= 0.0) {
            return "Ratio must be a positive number";
        }
        return null;
    }

    protected boolean isLine(GPoint3DList gPoint3DList) {
        return gPoint3DList.getDim() == 2 && gPoint3DList.getHead().getPoint3D() != gPoint3DList.getTail().getPoint3D();
    }

    protected boolean isBrokenLine(GPoint3DList gPoint3DList) {
        if (gPoint3DList.getDim() < 3) {
            return false;
        }
        GPoint3DNode gPoint3DNode = gPoint3DList.getHead();
        while (gPoint3DNode != gPoint3DList.getTail()) {
            if (gPoint3DNode.getPoint3D() == gPoint3DNode.getNext().getPoint3D()) {
                return false;
            }
            gPoint3DNode = gPoint3DNode.getNext();
        }
        return true;
    }

    protected GPoint3DList isPlane(GPoint3DList gPoint3DList) {
        if (gPoint3DList.getDim() < 3) {
            return null;
        }
        GPoint3DNode gPoint3DNode = gPoint3DList.getHead();
        GPoint3D gPoint3D = gPoint3DNode.getPoint3D();
        gPoint3DNode = gPoint3DNode.getNext();
        GPoint3D gPoint3D2 = GMath.subtract(gPoint3DNode.getPoint3D(), gPoint3D);
        GPoint3D gPoint3D3 = null;
        gPoint3DNode = gPoint3DNode.getNext();
        while (gPoint3DNode != null) {
            gPoint3D3 = GMath.subtract(gPoint3DNode.getPoint3D(), gPoint3D);
            if (!GMath.areCollinear(gPoint3D3, gPoint3D2)) break;
            gPoint3DNode = gPoint3DNode.getNext();
        }
        if (gPoint3DNode == null) {
            return null;
        }
        GPoint3D gPoint3D4 = GMath.vectorP(gPoint3D2, gPoint3D3);
        gPoint3DNode = gPoint3DNode.getNext();
        while (gPoint3DNode != null) {
            if (!GMath.areOrthogonal(gPoint3D4, GMath.subtract(gPoint3DNode.getPoint3D(), gPoint3D))) {
                return null;
            }
            gPoint3DNode = gPoint3DNode.getNext();
        }
        GPoint3DList gPoint3DList2 = new GPoint3DList();
        gPoint3DList2.addToTail(gPoint3D);
        gPoint3DList2.addToTail(gPoint3D4);
        return gPoint3DList2;
    }

    public boolean needsSolidName(String string) {
        return (this.type == 1 || this.type == 2) && string.equals(this.solidName);
    }

    static {
        boolean[] blArray = new boolean[11];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        sectPassNeedsValue = blArray;
        volumeCutWording = new String[]{"N/A", "In Half", "In Ratio"};
        boolean[] blArray2 = new boolean[3];
        blArray2[2] = true;
        volumeCutNeedsValue = blArray2;
        sectShapeWording = new String[]{"N/A", "Isoscelles Triangle", "Rectangular Triangle", "Equilateral Triangle", "Parallelogram", "Rhombus", "Rectangle", "Square"};
    }
}

