/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GLogRecordList
implements Serializable {
    private GLogRecordNode head;
    private GLogRecordNode tail;
    private int dim = 0;

    public void print() {
        GLogRecordNode gLogRecordNode = this.head;
        while (gLogRecordNode != null) {
            gLogRecordNode.getRecord().print();
            gLogRecordNode = gLogRecordNode.getNext();
        }
    }

    public GLogRecordNode getHead() {
        return this.head;
    }

    public GLogRecordNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void addToTail(GLogRecord gLogRecord) {
        GLogRecordNode gLogRecordNode = new GLogRecordNode(gLogRecord);
        if (this.head == null) {
            this.head = this.tail = gLogRecordNode;
        } else {
            this.tail.setNext(gLogRecordNode);
            gLogRecordNode.setPrev(this.tail);
            this.tail = gLogRecordNode;
        }
        ++this.dim;
    }

    public GLogRecord seek(String string) {
        GLogRecordNode gLogRecordNode = this.head;
        while (gLogRecordNode != null) {
            GLogRecord gLogRecord = gLogRecordNode.getRecord();
            if (string.equals(gLogRecord.toString())) {
                return gLogRecord;
            }
            gLogRecordNode = gLogRecordNode.getNext();
        }
        return null;
    }

    public GLogRecord seek(int n) {
        GLogRecordNode gLogRecordNode = this.head;
        while (--n >= 0) {
            gLogRecordNode = gLogRecordNode.getNext();
        }
        if (gLogRecordNode != null) {
            return gLogRecordNode.getRecord();
        }
        return null;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }
}

