/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GNPRecordList
implements Serializable {
    private GNPRecordNode head;
    private GNPRecordNode tail;
    private int dim = 0;

    public void print() {
        GNPRecordNode gNPRecordNode = this.head;
        while (gNPRecordNode != null) {
            gNPRecordNode.getRecord().print();
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public GNPRecordNode getHead() {
        return this.head;
    }

    public GNPRecordNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public void addToHead(GNPRecord gNPRecord) {
        GNPRecordNode gNPRecordNode = new GNPRecordNode(gNPRecord);
        if (this.head == null) {
            this.head = this.tail = gNPRecordNode;
        } else {
            this.head.setPrev(gNPRecordNode);
            gNPRecordNode.setNext(this.head);
            this.head = gNPRecordNode;
        }
        ++this.dim;
    }

    public void addToTail(GNPRecord gNPRecord) {
        GNPRecordNode gNPRecordNode = new GNPRecordNode(gNPRecord);
        if (this.head == null) {
            this.head = this.tail = gNPRecordNode;
        } else {
            this.tail.setNext(gNPRecordNode);
            gNPRecordNode.setPrev(this.tail);
            this.tail = gNPRecordNode;
        }
        ++this.dim;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public GNPRecord seekVarDefinition(String string) {
        GNPRecordNode gNPRecordNode = this.head;
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (string.equals(gNPRecord.getLSide().getName())) {
                return gNPRecord;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        return null;
    }

    public GNPRecordList seekVarDefinitions(GVariable[] gVariableArray) {
        GNPRecordList gNPRecordList = new GNPRecordList();
        int n = 0;
        while (n < gVariableArray.length) {
            GNPRecordNode gNPRecordNode = this.head;
            while (gNPRecordNode != null) {
                GNPRecord gNPRecord = gNPRecordNode.getRecord();
                if (gVariableArray[n] == gNPRecord.getLSide()) {
                    gNPRecordList.addToTail(gNPRecord);
                }
                gNPRecordNode = gNPRecordNode.getNext();
            }
            ++n;
        }
        return gNPRecordList;
    }

    public void seekDependencies(GNPRecordList gNPRecordList) {
        GNPRecordNode gNPRecordNode = gNPRecordList.getHead();
        while (gNPRecordNode != null) {
            GVariable gVariable = gNPRecordNode.getRecord().getLSide();
            GNPRecordNode gNPRecordNode2 = this.head;
            while (gNPRecordNode2 != null) {
                Object object;
                GNPRecord gNPRecord = gNPRecordNode2.getRecord();
                if (gNPRecordList.seek(gNPRecord) == null && (object = gNPRecord.getRSide()) instanceof GExpression && ((GExpression)object).varList.seek(gVariable)) {
                    gNPRecordList.addToTail(gNPRecord);
                }
                gNPRecordNode2 = gNPRecordNode2.getNext();
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public GNPRecordNode seek(GNPRecord gNPRecord) {
        GNPRecordNode gNPRecordNode = this.head;
        while (gNPRecordNode != null) {
            if (gNPRecordNode.getRecord() == gNPRecord) {
                return gNPRecordNode;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        return null;
    }

    public GNPRecord seek(String string) {
        GNPRecordNode gNPRecordNode = this.head;
        while (gNPRecordNode != null) {
            GNPRecord gNPRecord = gNPRecordNode.getRecord();
            if (string.equals(gNPRecord.toString())) {
                return gNPRecord;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
        return null;
    }

    public GNPRecordList seek(String[] stringArray) {
        GNPRecordList gNPRecordList = new GNPRecordList();
        int n = 0;
        while (n < stringArray.length) {
            GNPRecordNode gNPRecordNode = this.head;
            while (gNPRecordNode != null) {
                GNPRecord gNPRecord = gNPRecordNode.getRecord();
                if (stringArray[n].equals(gNPRecord.toString())) {
                    gNPRecordList.addToTail(gNPRecord);
                }
                gNPRecordNode = gNPRecordNode.getNext();
            }
            ++n;
        }
        return gNPRecordList;
    }

    public void remove(GNPRecordNode gNPRecordNode) {
        GNPRecordNode gNPRecordNode2 = gNPRecordNode.getPrev();
        GNPRecordNode gNPRecordNode3 = gNPRecordNode.getNext();
        if (gNPRecordNode2 == null && gNPRecordNode3 == null) {
            this.head = null;
            this.tail = null;
        } else if (gNPRecordNode2 == null) {
            gNPRecordNode3.setPrev(null);
            this.head = gNPRecordNode3;
        } else if (gNPRecordNode3 == null) {
            gNPRecordNode2.setNext(null);
            this.tail = gNPRecordNode2;
        } else {
            gNPRecordNode2.setNext(gNPRecordNode3);
            gNPRecordNode3.setPrev(gNPRecordNode2);
        }
        --this.dim;
    }

    public void remove(GNPRecord gNPRecord) {
        GNPRecordNode gNPRecordNode = this.head;
        while (gNPRecordNode != null) {
            if (gNPRecordNode.getRecord() == gNPRecord) {
                this.remove(gNPRecordNode);
                return;
            }
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public void remove(GNPRecordList gNPRecordList) {
        GNPRecordNode gNPRecordNode = gNPRecordList.head;
        while (gNPRecordNode != null) {
            this.remove(gNPRecordNode.getRecord());
            gNPRecordNode = gNPRecordNode.getNext();
        }
    }

    public GVariable[] getDefinedVars() {
        GVariable[] gVariableArray = new GVariable[this.dim];
        GNPRecordNode gNPRecordNode = this.head;
        int n = 0;
        while (n < this.dim) {
            gVariableArray[n] = gNPRecordNode.getRecord().getLSide();
            gNPRecordNode = gNPRecordNode.getNext();
            ++n;
        }
        return gVariableArray;
    }
}

