/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;

public class GPerpDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "perp.gif";
    public static final Dimension ICONDIM = new Dimension(106, 62);
    private TextField[] p;
    private List facets;
    private Label facetPrompt;
    private GSolid solid;

    public GPerpDialog(GFrame gFrame, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Draw Perpendicular");
        this.helpTopic = "draw perpendicular";
        this.solid = gSolid;
        this.p = new TextField[3];
        int n2 = 0;
        while (n2 < 3) {
            this.p[n2] = new TextField(3);
            this.p[n2].setFont(gFrame.labelFont);
            ++n2;
        }
        this.facets = new List(2, false);
        this.facets.setFont(gFrame.labelFont);
        this.facetPrompt = new Label("In facet:");
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Draw perpendicular");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.gridwidth = 2;
        Label label2 = new Label("Through point:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p[0], gridBagConstraints);
        this.dataPanel.add(this.p[0]);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 15;
        Label label3 = new Label("To line:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(this.p[1], gridBagConstraints);
        this.dataPanel.add(this.p[1]);
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p[2], gridBagConstraints);
        this.dataPanel.add(this.p[2]);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 1;
        this.facetPrompt.setForeground(this.dataPanel.getBackground().darker());
        gridBagLayout.setConstraints(this.facetPrompt, gridBagConstraints);
        this.dataPanel.add(this.facetPrompt);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.facets, gridBagConstraints);
        this.dataPanel.add(this.facets);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase(), null, null};
        if (this.facets.getSelectedIndex() == 0) {
            objectArray[3] = this.facets.getItem(0);
            objectArray[4] = this.facets.getItem(1);
        } else if (this.facets.getSelectedIndex() == 1) {
            objectArray[3] = this.facets.getItem(1);
            objectArray[4] = this.facets.getItem(0);
        }
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p[0]).setText((String)objectArray[0]);
        ((TextComponent)this.p[1]).setText((String)objectArray[1]);
        ((TextComponent)this.p[2]).setText((String)objectArray[2]);
        if (objectArray[3] != null) {
            this.facets.add((String)objectArray[3]);
            this.facets.add((String)objectArray[4]);
            this.facets.select(0);
        }
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p[0].getText().toUpperCase(), this.p[1].getText().toUpperCase(), this.p[2].getText().toUpperCase()};
        if (stringArray[0].equals("") || stringArray[1].equals("") || stringArray[2].equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Perpendicular improperly referenced");
            return false;
        }
        if (stringArray[1].equals(stringArray[2])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[1]) + stringArray[2] + " is no line");
            return false;
        }
        String string = this.solid.drawPerpendicular(stringArray, this.facets.getSelectedItem());
        if (string == null) {
            return true;
        }
        if (string.equals("Facet Prompt")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Facet Prompt", "Select a facet in which to draw");
            this.set(-1, null);
        } else {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string);
        }
        return false;
    }

    public void set(int n, Object[] objectArray) {
        boolean bl = false;
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            GEdgeNode gEdgeNode;
            this.setTitle("Draw Perpendicular in Solid " + this.solid.getLabel());
            GVertexNode gVertexNode = this.solid.getSelectedVertices().getHead();
            if (gVertexNode != null) {
                ((TextComponent)this.p[0]).setText(gVertexNode.getVertex().getLabel());
            }
            if ((gEdgeNode = this.solid.getSelectedEdges().getHead()) != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                ((TextComponent)this.p[1]).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p[2]).setText(gEdge.getTail().getLabel());
                boolean bl2 = bl = gEdge.twin != null && gVertexNode != null && gEdge.vertexList.seek(gVertexNode.getVertex()) != null;
                if (bl) {
                    this.facetPrompt.setForeground(this.dataPanel.getForeground());
                    this.facets.add(gEdge.wing1.toString());
                    this.facets.add(gEdge.wing2.toString());
                    if (gEdge.wing1.isSelected()) {
                        this.facets.select(0);
                        bl = false;
                    } else if (gEdge.wing2.isSelected()) {
                        this.facets.select(1);
                        bl = false;
                    } else {
                        this.facets.select(0);
                    }
                }
            }
        }
        if (n == 0 || bl) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

