/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class GVertexList
implements Serializable {
    private GVertexNode head;
    private GVertexNode tail;
    private int dim;

    public GVertexList() {
        this.dim = 0;
    }

    public GVertexList(GVertex gVertex, GVertex gVertex2) {
        this.addToHead(gVertex);
        this.addToTail(gVertex2);
        this.dim = 2;
    }

    public void print() {
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertexNode.getVertex().print();
            gVertexNode = gVertexNode.getNext();
        }
    }

    public void addToHead(GVertex gVertex) {
        GVertexNode gVertexNode = new GVertexNode(gVertex);
        if (this.head == null) {
            this.head = this.tail = gVertexNode;
        } else {
            this.head.setPrev(gVertexNode);
            gVertexNode.setNext(this.head);
            this.head = gVertexNode;
        }
        ++this.dim;
    }

    public void addToTail(GVertex gVertex) {
        GVertexNode gVertexNode = new GVertexNode(gVertex);
        if (this.head == null) {
            this.head = this.tail = gVertexNode;
        } else {
            this.tail.setNext(gVertexNode);
            gVertexNode.setPrev(this.tail);
            this.tail = gVertexNode;
        }
        ++this.dim;
    }

    public void insertBefore(GVertex gVertex, GVertexNode gVertexNode) {
        if (gVertexNode == this.head) {
            this.addToHead(gVertex);
        } else {
            GVertexNode gVertexNode2 = gVertexNode.getPrev();
            GVertexNode gVertexNode3 = new GVertexNode(gVertex);
            gVertexNode2.setNext(gVertexNode3);
            gVertexNode3.setNext(gVertexNode);
            gVertexNode.setPrev(gVertexNode3);
            gVertexNode3.setPrev(gVertexNode2);
        }
        ++this.dim;
    }

    public GVertexNode getHead() {
        return this.head;
    }

    public GVertexNode getTail() {
        return this.tail;
    }

    public int getDim() {
        return this.dim;
    }

    public String seek(GVertex gVertex) {
        if (this.head == null) {
            return null;
        }
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            GVertex gVertex2 = gVertexNode.getVertex();
            if (gVertex2 == gVertex) {
                return gVertex2.getLabel();
            }
            gVertexNode = gVertexNode.getNext();
        }
        return null;
    }

    public GVertex seek(GPoint3D gPoint3D, double d) {
        if (this.head == null) {
            return null;
        }
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            GVertex gVertex = gVertexNode.getVertex();
            if (GMath.isAt(gVertex, gPoint3D, d)) {
                return gVertex;
            }
            gVertexNode = gVertexNode.getNext();
        }
        return null;
    }

    public GVertex seek(String string) {
        if (this.head == null) {
            return null;
        }
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            GVertex gVertex = gVertexNode.getVertex();
            if (string.equals(gVertex.getLabel())) {
                return gVertex;
            }
            gVertexNode = gVertexNode.getNext();
        }
        return null;
    }

    public void flush() {
        this.tail = null;
        this.head = null;
        this.dim = 0;
    }

    public void clearSelection() {
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertexNode.getVertex().setSelected(false);
            gVertexNode = gVertexNode.getNext();
        }
    }

    public void unmarkAll() {
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertexNode.getVertex().setMarked(false);
            gVertexNode = gVertexNode.getNext();
        }
    }

    public GVertexList reverse() {
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertexList.addToHead(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public GVertexList sort() {
        GVertex gVertex;
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertex = gVertexNode.getVertex();
            if (gVertex.isProper()) {
                gVertexList.addToTail(gVertex);
            }
            gVertexNode = gVertexNode.getNext();
        }
        gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertex = gVertexNode.getVertex();
            if (!gVertex.isProper()) {
                gVertexList.addToTail(gVertex);
            }
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public void remove(GVertexNode gVertexNode) {
        GVertexNode gVertexNode2 = gVertexNode.getPrev();
        GVertexNode gVertexNode3 = gVertexNode.getNext();
        if (gVertexNode2 == null && gVertexNode3 == null) {
            this.head = null;
            this.tail = null;
        } else if (gVertexNode2 == null) {
            gVertexNode3.setPrev(null);
            this.head = gVertexNode3;
        } else if (gVertexNode3 == null) {
            gVertexNode2.setNext(null);
            this.tail = gVertexNode2;
        } else {
            gVertexNode2.setNext(gVertexNode3);
            gVertexNode3.setPrev(gVertexNode2);
        }
        --this.dim;
    }

    public void remove(GVertex gVertex) {
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            if (gVertexNode.getVertex() == gVertex) {
                this.remove(gVertexNode);
                return;
            }
            gVertexNode = gVertexNode.getNext();
        }
    }

    public GVertexList crop(GVertexNode gVertexNode, GVertexNode gVertexNode2) {
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode3 = gVertexNode;
        GVertexNode gVertexNode4 = gVertexNode2.getNext();
        while (gVertexNode3 != gVertexNode4) {
            gVertexList.addToTail(gVertexNode3.getVertex());
            gVertexNode3 = gVertexNode3.getNext();
        }
        return gVertexList;
    }

    public GVertexList removeParaVerts() {
        GVertexList gVertexList = new GVertexList();
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            if (!gVertexNode.getVertex().isProper()) break;
            gVertexList.addToTail(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public void move(double[][] dArray, double[][] dArray2, GPoint3D gPoint3D, GPoint3D gPoint3D2) {
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gVertexNode.getVertex().move(dArray, dArray2, gPoint3D, gPoint3D2);
            gVertexNode = gVertexNode.getNext();
        }
    }

    public GVertexList replaceHead(GVertex gVertex) {
        GVertexList gVertexList = new GVertexList();
        gVertexList.addToTail(gVertex);
        GVertexNode gVertexNode = this.head.getNext();
        while (gVertexNode != null) {
            gVertexList.addToTail(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getNext();
        }
        return gVertexList;
    }

    public GVertexList replaceTail(GVertex gVertex) {
        GVertexList gVertexList = new GVertexList();
        gVertexList.addToHead(gVertex);
        GVertexNode gVertexNode = this.tail.getPrev();
        while (gVertexNode != null) {
            gVertexList.addToHead(gVertexNode.getVertex());
            gVertexNode = gVertexNode.getPrev();
        }
        return gVertexList;
    }

    /*
     * Unable to fully structure code
     */
    public void stretch(GPoint3D var1_1) {
        var2_2 = this.head;
        if (var2_2 != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            var2_2.getVertex().stretch(var1_1);
            var2_2 = var2_2.getNext();
lbl6:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl7:
        // 1 sources

    }

    public GLabelList toLabelList() {
        GLabelList gLabelList = new GLabelList();
        GVertexNode gVertexNode = this.head;
        while (gVertexNode != null) {
            gLabelList.addToTail(gVertexNode.getVertex().getLabel());
            gVertexNode = gVertexNode.getNext();
        }
        return gLabelList;
    }
}

