/*
 * Decompiled with CFR 0.152.
 */
package Typing;

import Typing.ArticlePane;
import Typing.ControlPanel;
import Typing.ExercisePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class TypingPractice
extends JFrame {
    private JTabbedPane tabPane;
    private String url;
    private String driver;
    private Connection connect;
    private JLabel splashLabel;
    private JWindow splashScreen;
    private File configfile;
    private Properties options;
    private String buttonTextState;
    private String toolTipsState;
    private String lookAndFeelState;
    ArticlePane aPane;
    ControlPanel controls;
    ExercisePane exercise;

    public TypingPractice() {
        block9: {
            super("Typing Practice");
            this.splashLabel = null;
            this.splashScreen = null;
            this.createSplashScreen();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TypingPractice.this.showSplashScreen();
                }
            });
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graphics2D graphics2D = (Graphics2D)TypingPractice.this.splashScreen.getGraphics();
                        graphics2D.setFont(new Font("Serif", 3, 17));
                        graphics2D.drawString("Loading database driver . . . .", 10, 240);
                    }
                });
                this.driver = "COM.cloudscape.core.JDBCDriver";
                this.url = "jdbc:cloudscape:" + System.getProperty("user.dir") + "/ExamData";
                Class.forName(this.driver).newInstance();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TypingPractice.this.splashScreen.repaint(0, 220, 380, 40);
                    }
                });
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Graphics2D graphics2D = (Graphics2D)TypingPractice.this.splashScreen.getGraphics();
                        graphics2D.setFont(new Font("Serif", 3, 17));
                        graphics2D.drawString("Connecting database . . . .", 10, 240);
                    }
                });
                this.connect = DriverManager.getConnection(this.url);
                this.connect.setAutoCommit(false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(this, "Load database driver fail.\nPlease select YES to continue otherwise select NO to exit !!!", "ERROR", 0, 0);
                if (n == 1) {
                    System.exit(0);
                }
            }
            catch (SQLException sQLException) {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(this, "Database connect fail.\nPlease select YES to continue otherwise select NO to exit !!!", "ERROR", 0, 0);
                if (n == 1) {
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
                int n = JOptionPane.showConfirmDialog(this, "Load database driver fail.\nPlease select YES to continue otherwise select NO to exit !!!", "ERROR", 0, 0);
                if (n != 1) break block9;
                System.exit(0);
            }
        }
        this.tabPane = new JTabbedPane();
        Font font = this.tabPane.getFont();
        font = font.deriveFont(14.0f);
        this.tabPane.setFont(font);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TypingPractice.this.splashScreen.repaint(0, 220, 380, 40);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics2D graphics2D = (Graphics2D)TypingPractice.this.splashScreen.getGraphics();
                graphics2D.setFont(new Font("Serif", 3, 17));
                graphics2D.drawString("Loading control module . . . .", 10, 240);
            }
        });
        this.options = new Properties();
        this.configfile = this.createFile(System.getProperty("user.dir"), "configreg.ini");
        try {
            if (!this.configfile.exists()) {
                this.configfile.createNewFile();
                this.options.setProperty("ButtonTextEnable", "true");
                this.options.setProperty("ToolTipTextEnable", "true");
                this.options.setProperty("LookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel");
                this.options.store(new FileOutputStream(this.configfile), "config file");
            }
            this.options.load(new FileInputStream(this.configfile));
            this.buttonTextState = this.options.getProperty("ButtonTextEnable", "true");
            this.toolTipsState = this.options.getProperty("ToolTipTextEnable", "true");
            this.lookAndFeelState = this.options.getProperty("LookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JPanel jPanel = new JPanel();
        this.aPane = new ArticlePane();
        this.controls = new ControlPanel(this.connect, this.aPane, this, Boolean.valueOf(this.buttonTextState), Boolean.valueOf(this.toolTipsState), this.lookAndFeelState);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TypingPractice.this.splashScreen.repaint(0, 220, 380, 40);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics2D graphics2D = (Graphics2D)TypingPractice.this.splashScreen.getGraphics();
                graphics2D.setFont(new Font("Serif", 3, 17));
                graphics2D.drawString("Setting Look and Feel . . . .", 10, 240);
            }
        });
        this.exercise = new ExercisePane(this.connect, this);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.controls, "North");
        jPanel.add((Component)this.aPane, "Center");
        jPanel.add((Component)this.controls.statusBar, "South");
        this.tabPane.add(" Create Article ", jPanel);
        this.tabPane.add("    Practice    ", this.exercise);
        Container container = this.getContentPane();
        container.setBackground(new Color(153, 153, 190, 255));
        container.add(this.tabPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TypingPractice.this.options.setProperty("ButtonTextEnable", String.valueOf(TypingPractice.this.controls.getShowTextItemState()));
                TypingPractice.this.options.setProperty("ToolTipTextEnable", String.valueOf(TypingPractice.this.controls.getShowToolTipsItemState()));
                TypingPractice.this.options.setProperty("LookAndFeel", TypingPractice.this.controls.getLookAndFeelState());
                try {
                    TypingPractice.this.options.store(new FileOutputStream(TypingPractice.this.configfile), "config file");
                    TypingPractice.this.connect.close();
                    DriverManager.getConnection("JDBC:cloudscape:;shutdown=true");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        this.controls.getLafDialog().updateLookAndFeel(this.lookAndFeelState);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TypingPractice.this.splashScreen.repaint(0, 220, 380, 40);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics2D graphics2D = (Graphics2D)TypingPractice.this.splashScreen.getGraphics();
                graphics2D.setFont(new Font("Serif", 3, 17));
                graphics2D.drawString("Done . . . .", 10, 240);
            }
        });
        this.pack();
        this.setSize(800, 600);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.setIconImage(toolkit.getImage(this.getClass().getResource("images/logo.gif")));
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TypingPractice.this.show();
                TypingPractice.this.hideSplashScreen();
            }
        });
    }

    private void createSplashScreen() {
        this.splashLabel = new JLabel(this.createImageIcon("splash.jpg"));
        this.splashScreen = new JWindow();
        this.splashScreen.getContentPane().add(this.splashLabel);
        this.splashScreen.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.splashScreen.setLocation(dimension.width / 2 - this.splashScreen.getSize().width / 2, dimension.height / 2 - this.splashScreen.getSize().height / 2);
    }

    private void showSplashScreen() {
        this.splashScreen.show();
    }

    private void hideSplashScreen() {
        this.splashScreen.setVisible(false);
        this.splashLabel = null;
        this.splashScreen = null;
    }

    private ImageIcon createImageIcon(String string) {
        String string2 = "images/" + string;
        return new ImageIcon(this.getClass().getResource(string2));
    }

    private File createFile(String string, String string2) {
        String string3 = string + "/" + string2;
        return new File(string3);
    }

    public static void main(String[] stringArray) {
        TypingPractice typingPractice = new TypingPractice();
    }
}

