// ------------------------------------------------------------------
// -- P_DOMAIN.C
// -- PLUGIN interface for DOLIST Server for EMWACS IMS
// -- Copyright  Denis Olivier 1998-1999
// -- Denis Olivier : d.olivier@dolist.net
// -- Comments : see p_domain_doc.txt
// ------------------------------------------------------------------

#include <SYS\STAT.H>
#include <FCNTL.H>
#include <STDLIB.H>
#include <STDIO.H>
#include <STDARG.H>
#include <DOS.H>
#include <DIRECT.H>
#include <IO.H>
#include <STRING.H>
#include <WINSOCK.H>

#include "..\PLUGINS.H"
#include "..\PLUGINS.C"

#define NbItem 7

char Prefix[NbItem][NbItem]={"","mail.","www.","ftp.","news.",".irc",NULL};

int main(int argc, char *argv[]) {
  FILE *MsgFile;
  char Buffer[1024];
  char Domain[128];
  PHOSTENT hostinfo;
  WSADATA wsaData;
  unsigned int addr;
  int i,Dot=0;
  
  strcpy(MsgName,argv[1]); // need to be done for public
  strcpy(LogPath,argv[2]); // need to be done for public
  
  if (WSAStartup(MAKEWORD(2,1),&wsaData) != 0) {
    log_out("  WSAStartup failed with error %d\n",WSAGetLastError());
    WSACleanup();
    return PLUGIN_OK;
  }
 
  if ((MsgFile=fopen(MsgName,"rt"))) {
    search_tag(MsgFile,"From: ",Buffer);
    fclose(MsgFile);
    if (Buffer==NULL || strlen(Buffer)<5) goto ERROR_DOMAIN;
    extract_email_address(Buffer);
    if (strchr(Buffer,'@')!=NULL) strcpy(Domain,strchr(Buffer,'@')+1);
    if (Domain==NULL || strlen(Domain)<5) goto ERROR_DOMAIN;
    
    for (i=0;i<NbItem;i++) {
      if (Prefix[i]==NULL) break;
      if (Domain==NULL || strlen(Domain)<2) break;
      sprintf(Buffer,"%s%s",Prefix[i],Domain);
      if (isalpha(Buffer[0])) {
        hostinfo = gethostbyname(Buffer);
      } else { 
        addr = inet_addr(Buffer);
        hostinfo = gethostbyaddr((char *) &addr,4,AF_INET);
      }
      if (hostinfo!=NULL) {
        log_out("  Domain %s [%s] ok.",Buffer,inet_ntoa (*(struct in_addr *)*hostinfo->h_addr_list));
        WSACleanup();  
        return PLUGIN_OK;
      }
    }
  }
  
  ERROR_DOMAIN:
  
  WSACleanup();  
  log_out("  Cannot resolve address [%s]",Domain);
  return PLUGIN_ERROR;
}



