/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.Runner;

public class Global
extends ImporterTopLevel {
    boolean debug = false;
    boolean processStdin = true;
    boolean quitting;
    int exitCode = 0;
    NativeArray history;
    boolean showDebuggerUI = false;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$shell$Global;
    static /* synthetic */ Class class$org$mozilla$javascript$Script;

    public Global() {
        Context context = Context.enter();
        context.initStandardObjects(this, false);
        String[] stringArray = new String[]{"print", "quit", "version", "load", "help", "loadClass", "defineClass", "spawn"};
        try {
            try {
                this.defineFunctionProperties(stringArray, class$org$mozilla$javascript$tools$shell$Global != null ? class$org$mozilla$javascript$tools$shell$Global : (class$org$mozilla$javascript$tools$shell$Global = Global.class$("org.mozilla.javascript.tools.shell.Global")), 2);
            }
            catch (PropertyException propertyException) {
                throw new Error(propertyException.getMessage());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void defineClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Class clazz = Global.getClass(objectArray);
        ScriptableObject.defineClass(Main.global, clazz);
    }

    private static Class getClass(Object[] objectArray) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (objectArray.length == 0) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.expected.string.arg"));
        }
        String string = Context.toString(objectArray[0]);
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.class.not.found", string));
        }
    }

    public String getClassName() {
        return "global";
    }

    public static void help(String string) {
        Main.getOut().println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = 0;
        while (n < objectArray.length) {
            Main.processSource(context, Context.toString(objectArray[n]));
            ++n;
        }
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class clazz;
        if (!(class$org$mozilla$javascript$Script != null ? class$org$mozilla$javascript$Script : (class$org$mozilla$javascript$Script = Global.class$("org.mozilla.javascript.Script"))).isAssignableFrom(clazz = Global.getClass(objectArray))) {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.must.implement.Script"));
        }
        Script script = (Script)clazz.newInstance();
        script.exec(context, Main.global);
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                Main.getOut().print(" ");
            }
            String string = Context.toString(objectArray[n]);
            Main.getOut().print(string);
            ++n;
        }
        Main.getOut().println();
        return Context.getUndefinedValue();
    }

    public static void quit(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Main.global.exitCode = 0;
        if (objectArray.length > 0) {
            Main.global.exitCode = (int)Context.toNumber(objectArray[0]);
        }
        Main.global.quitting = true;
    }

    public static Object spawn(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Runner runner;
        Object object;
        Scriptable scriptable2 = function.getParentScope();
        if (objectArray.length != 0 && objectArray[0] instanceof Function) {
            object = null;
            if (objectArray.length > 1 && objectArray[1] instanceof Scriptable) {
                object = context.getElements((Scriptable)objectArray[1]);
            }
            runner = new Runner(scriptable2, (Function)objectArray[0], (Object[])object);
        } else if (objectArray.length != 0 && objectArray[0] instanceof Script) {
            runner = new Runner(scriptable2, (Script)objectArray[0]);
        } else {
            throw Context.reportRuntimeError(ToolErrorReporter.getMessage("msg.spawn.args"));
        }
        object = new Thread(runner);
        ((Thread)object).start();
        return object;
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d = context.getLanguageVersion();
        if (objectArray.length > 0) {
            double d2 = Context.toNumber(objectArray[0]);
            context.setLanguageVersion((int)d2);
        }
        return d;
    }
}

