/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.InputStreamHook;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.ValueUtility;
import com.sun.corba.se.internal.io.util.Arrays;
import com.sun.corba.se.internal.io.util.Comparator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.omg.CORBA.ValueMember;

public class ObjectStreamClass
implements Serializable {
    public static final long kDefaultUID = -1L;
    private static Object[] noArgsList = new Object[0];
    private static Class[] noTypesList = new Class[0];
    private boolean isAbstractInterface = true;
    private boolean isAbstractComputed = false;
    private boolean hasSerialVersionUIDField = false;
    private static Class kObjectStreamFieldClazz = null;
    private static ObjectStreamClassEntry[] descriptorFor;
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    private long suid = -1L;
    private long computedSuid = -1L;
    private String suidStr = null;
    private long actualSuid = -1L;
    private String actualSuidStr = null;
    int primBytes;
    int objFields;
    private boolean hasWriteObjectMethod;
    private boolean hasExternalizableBlockData;
    Method writeObjectMethod;
    Method readObjectMethod;
    private Method writeReplaceObjectMethod;
    private Method readResolveObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable;
    private static Class classExternalizable;
    private static final long serialVersionUID = -6120832682080437368L;
    private static Comparator compareClassByName;
    private static Comparator compareMemberByName;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$io$IOException;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$lang$Object;

    public final boolean isAbstractInterface() {
        if (!this.isAbstractComputed) {
            this.computeAbstract(this.ofClass);
        }
        return this.isAbstractInterface;
    }

    static final ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        return objectStreamClass;
    }

    static ObjectStreamClass lookupInternal(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (objectStreamClassEntryArray) {
            Class clazz2;
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass != null) {
                ObjectStreamClass objectStreamClass2 = objectStreamClass;
                return objectStreamClass2;
            }
            boolean bl = classSerializable.isAssignableFrom(clazz);
            boolean bl2 = classExternalizable.isAssignableFrom(clazz);
            if (bl2) {
                bl = false;
            }
            ObjectStreamClass objectStreamClass3 = null;
            if (clazz.getSuperclass() != (class$java$lang$Class == null ? (class$java$lang$Class = ObjectStreamClass.class$("java.lang.Class")) : class$java$lang$Class) && (clazz2 = clazz.getSuperclass()) != null) {
                objectStreamClass3 = ObjectStreamClass.lookup(clazz2);
            }
            objectStreamClass = new ObjectStreamClass(clazz, objectStreamClass3, bl, bl2);
        }
        return objectStreamClass;
    }

    public final String getName() {
        return this.name;
    }

    public static final long getSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getSerialVersionUID();
        }
        return 0L;
    }

    public final long getSerialVersionUID() {
        if (this.hasSerialVersionUIDField) {
            return this.suid;
        }
        return this.computedSuid;
    }

    public final String getSerialVersionUIDStr() {
        if (this.hasSerialVersionUIDField) {
            if (this.suidStr == null) {
                this.suidStr = Long.toHexString(this.suid).toUpperCase();
            }
            return this.suidStr;
        }
        if (this.suidStr == null) {
            this.suidStr = Long.toHexString(this.computedSuid).toUpperCase();
        }
        return this.suidStr;
    }

    public static final long getActualSerialVersionUID(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass.getActualSerialVersionUID();
        }
        return 0L;
    }

    public final long getActualSerialVersionUID() {
        return this.actualSuid;
    }

    public final String getActualSerialVersionUIDStr() {
        if (this.actualSuidStr == null) {
            this.actualSuidStr = Long.toHexString(this.actualSuid).toUpperCase();
        }
        return this.actualSuidStr;
    }

    public final Class forClass() {
        return this.ofClass;
    }

    public ObjectStreamField[] getFields() {
        if (this.fields.length > 0) {
            ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
            System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
            return objectStreamFieldArray;
        }
        return this.fields;
    }

    public boolean hasSerialVersionUIDField() {
        return this.hasSerialVersionUIDField;
    }

    public boolean hasField(ValueMember valueMember) {
        int n = 0;
        while (n < this.fields.length) {
            try {
                if (this.fields[n].getName().equals(valueMember.name) && this.fields[n].getSignature().equals(ValueUtility.getSignature(valueMember))) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return false;
    }

    final ObjectStreamField[] getFieldsNoCopy() {
        return this.fields;
    }

    public final ObjectStreamField getField(String string) {
        int n = this.fields.length - 1;
        while (n >= 0) {
            if (string.equals(this.fields[n].getName())) {
                return this.fields[n];
            }
            --n;
        }
        return null;
    }

    public Serializable writeReplace(Serializable serializable) {
        if (this.writeReplaceObjectMethod != null) {
            try {
                return (Serializable)this.writeReplaceObjectMethod.invoke(serializable, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return serializable;
    }

    public Object readResolve(Object object) {
        if (this.readResolveObjectMethod != null) {
            try {
                return this.readResolveObjectMethod.invoke(object, noArgsList);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage());
            }
        }
        return object;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        Class[] classArray;
        int n;
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        this.externalizable = bl2;
        ObjectStreamClass.insertDescriptorFor(this);
        if (!this.serializable || this.externalizable || this.name.equals("java.lang.String")) {
            this.fields = new ObjectStreamField[0];
        } else if (this.serializable) {
            Field[] fieldArray;
            try {
                fieldArray = ObjectStreamClass.getDeclaredField(clazz, "serialPersistentFields");
                n = fieldArray.getModifiers();
                if (Modifier.isPrivate(n) && Modifier.isStatic(n) && Modifier.isFinal(n) && fieldArray.getDeclaringClass().equals(kObjectStreamFieldClazz)) {
                    this.fields = (ObjectStreamField[])InputStreamHook.translateFields((Object[])fieldArray.get(clazz));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                this.fields = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.fields = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.fields = null;
            }
            if (this.fields == null) {
                fieldArray = ObjectStreamClass.getDeclaredFields(clazz);
                n = 0;
                ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[fieldArray.length];
                int n2 = 0;
                while (n2 < fieldArray.length) {
                    int n3 = fieldArray[n2].getModifiers();
                    if (!Modifier.isStatic(n3) && !Modifier.isTransient(n3)) {
                        objectStreamFieldArray[n++] = new ObjectStreamField(fieldArray[n2]);
                    }
                    ++n2;
                }
                this.fields = new ObjectStreamField[n];
                System.arraycopy(objectStreamFieldArray, 0, this.fields, 0, n);
            } else {
                int n4 = this.fields.length - 1;
                while (n4 >= 0) {
                    try {
                        Field field = ObjectStreamClass.getDeclaredField(clazz, this.fields[n4].getName());
                        if (this.fields[n4].getType() == field.getType()) {
                            this.fields[n4].setField(field);
                        }
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    --n4;
                }
            }
            if (this.fields.length > 1) {
                Arrays.sort(this.fields);
            }
            this.computeFieldInfo();
        }
        try {
            classArray = ObjectStreamClass.getDeclaredField(clazz, "serialVersionUID");
            n = classArray.getModifiers();
            if (Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n)) {
                this.hasSerialVersionUIDField = true;
                this.suid = ObjectStreamClass.getSerialVersionUIDField(clazz);
                this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            } else {
                this.hasSerialVersionUIDField = false;
                this.suid = 0L;
                this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.hasSerialVersionUIDField = false;
            this.suid = 0L;
            this.actualSuid = ObjectStreamClass.computeStructuralUID(this, clazz);
        }
        this.computedSuid = ObjectStreamClass._computeSerialVersionUID(this, clazz);
        try {
            classArray = new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream};
            this.writeObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "writeObject", classArray);
            this.hasWriteObjectMethod = true;
            n = this.writeObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                this.writeObjectMethod = null;
                this.hasWriteObjectMethod = false;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.writeReplaceObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "writeReplace", noTypesList);
            if (Modifier.isStatic(this.writeReplaceObjectMethod.getModifiers())) {
                this.writeReplaceObjectMethod = null;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectStreamClass.this.writeReplaceObjectMethod.setAccessible(true);
                        return null;
                    }
                });
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.readResolveObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readResolve", noTypesList);
            if (Modifier.isStatic(this.readResolveObjectMethod.getModifiers())) {
                this.readResolveObjectMethod = null;
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectStreamClass.this.readResolveObjectMethod.setAccessible(true);
                        return null;
                    }
                });
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readObject", classArray);
            n = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n) || Modifier.isStatic(n)) {
                this.readObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    final void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            this.computeFieldInfo();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookupInternal(clazz);
        if (this.localClassDesc == null) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.suid != this.localClassDesc.suid && (!clazz.isArray() || clazz.getName().equals(this.name))) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible: stream classdesc serialVersionUID=" + this.suid + " local class serialVersionUID=" + this.localClassDesc.suid);
        }
        if (!ObjectStreamClass.compareClassNames(this.name, clazz.getName(), '.')) {
            throw new InvalidClassException(this.name, "Incompatible local class name: " + clazz.getName());
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.fields;
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            int n3 = n;
            while (n3 < objectStreamFieldArray.length) {
                if (objectStreamFieldArray2[n2].getName().equals(objectStreamFieldArray[n3].getName())) {
                    if (objectStreamFieldArray2[n2].isPrimitive() && !objectStreamFieldArray2[n2].typeEquals(objectStreamFieldArray[n3])) {
                        throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n2].getName() + " of class " + this.name + " is incompatible.");
                    }
                    n = n3;
                    objectStreamFieldArray2[n2].setField(objectStreamFieldArray[n].getField());
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.computeFieldInfo();
        this.ofClass = clazz;
        try {
            Class[] classArray = new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream};
            this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(clazz, "readObject", classArray);
            int n4 = this.readObjectMethod.getModifiers();
            if (!Modifier.isPrivate(n4) || Modifier.isStatic(n4)) {
                this.readObjectMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static boolean compareClassNames(String string, String string2, char c) {
        int n;
        int n2 = string.lastIndexOf(c);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string2.lastIndexOf(c)) < 0) {
            n = 0;
        }
        return string.regionMatches(false, n2, string2, n, string.length() - n2);
    }

    final boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && ObjectStreamClass.compareClassNames(this.name, objectStreamClass.name, '.');
    }

    final void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    final ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    final boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    final boolean isCustomMarshaled() {
        return this.hasWriteObject() || this.isExternalizable();
    }

    boolean hasExternalizableBlockDataMode() {
        return this.hasExternalizableBlockData;
    }

    final ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    private void computeFieldInfo() {
        this.primBytes = 0;
        this.objFields = 0;
        int n = 0;
        while (n < this.fields.length) {
            switch (this.fields[n].getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primBytes;
                    break;
                }
                case 'C': 
                case 'S': {
                    this.primBytes += 2;
                    break;
                }
                case 'F': 
                case 'I': {
                    this.primBytes += 4;
                    break;
                }
                case 'D': 
                case 'J': {
                    this.primBytes += 8;
                    break;
                }
                case 'L': 
                case '[': {
                    ++this.objFields;
                }
            }
            ++n;
        }
    }

    private final synchronized void computeAbstract(Class clazz) {
        this.isAbstractComputed = true;
        Method[] methodArray = ObjectStreamClass.getDeclaredMethods(clazz);
        if (!clazz.isInterface()) {
            this.isAbstractInterface = false;
            return;
        }
        if (methodArray.length == 0) {
            this.isAbstractInterface = false;
            return;
        }
        int n = methodArray.length - 1;
        while (n > -1) {
            Class[] classArray = methodArray[n].getExceptionTypes();
            if (classArray.length == 0) {
                this.isAbstractInterface = false;
                return;
            }
            this.isAbstractInterface = false;
            int n2 = classArray.length - 1;
            while (n2 > -1 && !this.isAbstractInterface) {
                if ((class$java$rmi$RemoteException == null ? ObjectStreamClass.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException) == classArray[n2] || (class$java$lang$Throwable == null ? ObjectStreamClass.class$("java.lang.Throwable") : class$java$lang$Throwable) == classArray[n2] || (class$java$lang$Exception == null ? ObjectStreamClass.class$("java.lang.Exception") : class$java$lang$Exception) == classArray[n2] || (class$java$io$IOException == null ? ObjectStreamClass.class$("java.io.IOException") : class$java$io$IOException) == classArray[n2]) {
                    this.isAbstractInterface = true;
                }
                --n2;
            }
            --n;
        }
        this.isAbstractInterface = this.isAbstractInterface && (this.superclass == null || this.superclass.isAbstractInterface());
    }

    private static long _computeSerialVersionUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            Object object;
            Object object2;
            int n;
            MethodSignature[] methodSignatureArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            Member[] memberArray = ObjectStreamClass.getDeclaredMethods(clazz);
            if (((n2 &= 0x611) & 0x200) != 0) {
                n2 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2);
            Object[] objectArray = clazz.getInterfaces();
            Arrays.sort(objectArray, compareClassByName);
            int n3 = 0;
            while (n3 < objectArray.length) {
                dataOutputStream.writeUTF(((Class)objectArray[n3]).getName());
                ++n3;
            }
            Object[] objectArray2 = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(objectArray2, compareMemberByName);
            int n4 = 0;
            while (n4 < objectArray2.length) {
                methodSignatureArray = objectArray2[n4];
                n = methodSignatureArray.getModifiers();
                if (!Modifier.isPrivate(n) || !Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(methodSignatureArray.getName());
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(methodSignatureArray.getType()));
                }
                ++n4;
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            methodSignatureArray = MethodSignature.removePrivateAndSort(ObjectStreamClass.getDeclaredConstructors(clazz));
            n = 0;
            while (n < methodSignatureArray.length) {
                object2 = methodSignatureArray[n];
                String string = "<init>";
                object = object2.signature;
                object = ((String)object).replace('/', '.');
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeInt(object2.member.getModifiers());
                dataOutputStream.writeUTF((String)object);
                ++n;
            }
            object2 = MethodSignature.removePrivateAndSort(memberArray);
            int n5 = 0;
            while (n5 < ((MethodSignature[])object2).length) {
                object = object2[n5];
                String string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
                ++n5;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n6 = 0;
            while (n6 < Math.min(8, ((Object)object).length)) {
                l += (long)(object[n6] & 0xFF) << n6 * 8;
                ++n6;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static long computeStructuralUID(ObjectStreamClass objectStreamClass, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            Object object;
            if (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectStreamClass.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ObjectStreamClass.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != (class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object)) {
                dataOutputStream.writeLong(ObjectStreamClass.computeStructuralUID(ObjectStreamClass.lookup(clazz2), clazz2));
            }
            if (objectStreamClass.hasWriteObject()) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Object[] objectArray = ObjectStreamClass.getDeclaredFields(clazz);
            Arrays.sort(objectArray, compareMemberByName);
            int n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2];
                n = ((Field)object).getModifiers();
                if (!Modifier.isTransient(n) && !Modifier.isStatic(n)) {
                    dataOutputStream.writeUTF(((Field)object).getName());
                    dataOutputStream.writeUTF(ObjectStreamClass.getSignature(((Field)object).getType()));
                }
                ++n2;
            }
            dataOutputStream.flush();
            object = messageDigest.digest();
            int n3 = n = Math.min(8, ((Object)object).length);
            while (n3 > 0) {
                l += (long)(object[n3] & 0xFF) << n3 * 8;
                --n3;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("[");
                ++n2;
            }
            stringBuffer.append(ObjectStreamClass.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClass.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class[] classArray = constructor.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(ObjectStreamClass.getSignature(classArray[n]));
            ++n;
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.get() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.get();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private static Field getDeclaredField(final Class clazz, final String string) throws NoSuchFieldException {
        try {
            return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchFieldException {
                    return clazz.getDeclaredField(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchFieldException)privilegedActionException.getException();
        }
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray) throws NoSuchMethodException {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return clazz.getDeclaredMethod(string, classArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NoSuchMethodException)privilegedActionException.getException();
        }
    }

    private static Method[] getDeclaredMethods(final Class clazz) {
        return (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    private static Constructor[] getDeclaredConstructors(final Class clazz) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredConstructors();
            }
        });
    }

    private static native boolean hasStaticInitializer(Class var0);

    private static native long getSerialVersionUIDField(Class var0);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.sun.corba.se.internal.io.LibraryManager").getDeclaredMethod("load", null).invoke(null, null);
            kObjectStreamFieldClazz = Class.forName("java.io.ObjectStreamField");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        descriptorFor = new ObjectStreamClassEntry[61];
        classSerializable = null;
        classExternalizable = null;
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
        compareClassByName = new CompareClassByName();
        compareMemberByName = new CompareMemberByName();
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n2].getModifiers())) {
                    ++n;
                }
                ++n2;
            }
            Object[] objectArray = new MethodSignature[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < memberArray.length) {
                if (!Modifier.isPrivate(memberArray[n4].getModifiers())) {
                    objectArray[n3] = new MethodSignature(memberArray[n4]);
                    ++n3;
                }
                ++n4;
            }
            if (n3 > 0) {
                Arrays.sort(objectArray, objectArray[0]);
            }
            return objectArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClass.getSignature((Constructor)member) : ObjectStreamClass.getSignature((Method)member);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClass.getSignature((Method)object);
                string2 = string2 + ObjectStreamClass.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClass.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClass.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class ObjectStreamClassEntry {
        ObjectStreamClassEntry next;
        private ObjectStreamClass c;

        ObjectStreamClassEntry(ObjectStreamClass objectStreamClass) {
            this.c = objectStreamClass;
        }

        public Object get() {
            return this.c;
        }
    }
}

