/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.awt.Component;
import java.awt.Container;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.Visibility;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.beans.beancontext.BeanContextProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class BeanContextSupport
extends BeanContextChildSupport
implements BeanContext,
Serializable,
PropertyChangeListener,
VetoableChangeListener {
    static final long serialVersionUID = -4879613978649577204L;
    protected transient HashMap children;
    private int serializable = 0;
    protected transient ArrayList bcmListeners;
    protected Locale locale;
    protected boolean okToUseGui;
    protected boolean designTime;
    private transient PropertyChangeListener childPCL;
    private transient VetoableChangeListener childVCL;
    private transient boolean serializing;

    public BeanContextSupport(BeanContext beanContext, Locale locale, boolean bl, boolean bl2) {
        super(beanContext);
        this.locale = locale != null ? locale : Locale.getDefault();
        this.designTime = bl;
        this.okToUseGui = bl2;
        this.initialize();
    }

    public BeanContextSupport(BeanContext beanContext, Locale locale, boolean bl) {
        this(beanContext, locale, bl, true);
    }

    public BeanContextSupport(BeanContext beanContext, Locale locale) {
        this(beanContext, locale, false, true);
    }

    public BeanContextSupport(BeanContext beanContext) {
        this(beanContext, null, false, true);
    }

    public BeanContextSupport() {
        this(null, null, false, true);
    }

    public BeanContext getBeanContextPeer() {
        return (BeanContext)this.getBeanContextChildPeer();
    }

    public Object instantiateChild(String string) throws IOException, ClassNotFoundException {
        BeanContext beanContext = this.getBeanContextPeer();
        return Beans.instantiate(beanContext.getClass().getClassLoader(), string, beanContext);
    }

    public int size() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            int n = this.children.size();
            return n;
        }
    }

    public boolean isEmpty() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            boolean bl = this.children.isEmpty();
            return bl;
        }
    }

    public boolean contains(Object object) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            boolean bl = this.children.containsKey(object);
            return bl;
        }
    }

    public boolean containsKey(Object object) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            boolean bl = this.children.containsKey(object);
            return bl;
        }
    }

    public Iterator iterator() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            BCSIterator bCSIterator = new BCSIterator(this.children.keySet().iterator());
            return bCSIterator;
        }
    }

    public Object[] toArray() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Object[] objectArray = this.children.keySet().toArray();
            return objectArray;
        }
    }

    public Object[] toArray(Object[] objectArray) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Object[] objectArray2 = this.children.keySet().toArray(objectArray);
            return objectArray2;
        }
    }

    protected BCSChild createBCSChild(Object object, Object object2) {
        return new BCSChild(object, object2);
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.children.containsKey(object)) {
            return false;
        }
        Object object2 = BeanContext.globalHierarchyLock;
        synchronized (object2) {
            Object[] objectArray;
            if (this.children.containsKey(object)) {
                boolean bl = false;
                return bl;
            }
            if (!this.validatePendingAdd(object)) {
                throw new IllegalStateException();
            }
            BeanContextChild beanContextChild = BeanContextSupport.getChildBeanContextChild(object);
            BeanContextChild beanContextChild2 = null;
            Object object3 = object;
            synchronized (object3) {
                Visibility visibility;
                if (object instanceof BeanContextProxy && (beanContextChild2 = ((BeanContextProxy)object).getBeanContextProxy()) == null) {
                    throw new NullPointerException("BeanContextPeer.getBeanContextProxy()");
                }
                BCSChild bCSChild = this.createBCSChild(object, beanContextChild2);
                BCSChild bCSChild2 = null;
                HashMap hashMap = this.children;
                synchronized (hashMap) {
                    this.children.put(object, bCSChild);
                    if (beanContextChild2 != null) {
                        bCSChild2 = this.createBCSChild(beanContextChild2, object);
                        this.children.put(beanContextChild2, bCSChild2);
                    }
                }
                if (beanContextChild != null) {
                    BeanContextChild beanContextChild3 = beanContextChild;
                    synchronized (beanContextChild3) {
                        try {
                            beanContextChild.setBeanContext(this.getBeanContextPeer());
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            HashMap hashMap2 = this.children;
                            synchronized (hashMap2) {
                                this.children.remove(object);
                                if (beanContextChild2 != null) {
                                    this.children.remove(beanContextChild2);
                                }
                            }
                            throw new IllegalStateException();
                        }
                        beanContextChild.addPropertyChangeListener("beanContext", this.childPCL);
                        beanContextChild.addVetoableChangeListener("beanContext", this.childVCL);
                    }
                }
                if ((visibility = BeanContextSupport.getChildVisibility(object)) != null) {
                    if (this.okToUseGui) {
                        visibility.okToUseGui();
                    } else {
                        visibility.dontUseGui();
                    }
                }
                if (BeanContextSupport.getChildSerializable(object) != null) {
                    ++this.serializable;
                }
                this.childJustAddedHook(object, bCSChild);
                if (beanContextChild2 != null) {
                    visibility = BeanContextSupport.getChildVisibility(beanContextChild2);
                    if (visibility != null) {
                        if (this.okToUseGui) {
                            visibility.okToUseGui();
                        } else {
                            visibility.dontUseGui();
                        }
                    }
                    if (BeanContextSupport.getChildSerializable(beanContextChild2) != null) {
                        ++this.serializable;
                    }
                    this.childJustAddedHook(beanContextChild2, bCSChild2);
                }
            }
            BeanContext beanContext = this.getBeanContextPeer();
            if (beanContextChild2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = object;
                objectArray = objectArray3;
                objectArray3[1] = beanContextChild2;
            }
            this.fireChildrenAdded(new BeanContextMembershipEvent(beanContext, objectArray));
        }
        return true;
    }

    public boolean remove(Object object) {
        return this.remove(object, true);
    }

    protected boolean remove(Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Object object2 = BeanContext.globalHierarchyLock;
        synchronized (object2) {
            Object[] objectArray;
            if (!this.containsKey(object)) {
                boolean bl2 = false;
                return bl2;
            }
            if (!this.validatePendingRemove(object)) {
                throw new IllegalStateException();
            }
            BCSChild bCSChild = (BCSChild)this.children.get(object);
            BCSChild bCSChild2 = null;
            Object object3 = null;
            Object object4 = object;
            synchronized (object4) {
                Object object5;
                if (bl && (object5 = BeanContextSupport.getChildBeanContextChild(object)) != null) {
                    Object object6 = object5;
                    synchronized (object6) {
                        object5.removePropertyChangeListener("beanContext", this.childPCL);
                        object5.removeVetoableChangeListener("beanContext", this.childVCL);
                        try {
                            object5.setBeanContext(null);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            object5.addPropertyChangeListener("beanContext", this.childPCL);
                            object5.addVetoableChangeListener("beanContext", this.childVCL);
                            throw new IllegalStateException();
                        }
                    }
                }
                object5 = this.children;
                synchronized (object5) {
                    this.children.remove(object);
                    if (bCSChild.isProxyPeer()) {
                        object3 = bCSChild.getProxyPeer();
                        bCSChild2 = (BCSChild)this.children.get(object3);
                        this.children.remove(object3);
                    }
                }
                if (BeanContextSupport.getChildSerializable(object) != null) {
                    --this.serializable;
                }
                this.childJustRemovedHook(object, bCSChild);
                if (object3 != null) {
                    if (BeanContextSupport.getChildSerializable(object3) != null) {
                        --this.serializable;
                    }
                    this.childJustRemovedHook(object3, bCSChild2);
                }
            }
            BeanContext beanContext = this.getBeanContextPeer();
            if (object3 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = object;
                objectArray = objectArray3;
                objectArray3[1] = object3;
            }
            this.fireChildrenRemoved(new BeanContextMembershipEvent(beanContext, objectArray));
        }
        return true;
    }

    public boolean containsAll(Collection collection) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void addBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        if (beanContextMembershipListener == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (this.bcmListeners.contains(beanContextMembershipListener)) {
                return;
            }
            this.bcmListeners.add(beanContextMembershipListener);
        }
    }

    public void removeBeanContextMembershipListener(BeanContextMembershipListener beanContextMembershipListener) {
        if (beanContextMembershipListener == null) {
            throw new NullPointerException("listener");
        }
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            if (!this.bcmListeners.contains(beanContextMembershipListener)) {
                return;
            }
            this.bcmListeners.remove(beanContextMembershipListener);
        }
    }

    public InputStream getResourceAsStream(String string, BeanContextChild beanContextChild) {
        boolean bl;
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (beanContextChild == null) {
            throw new NullPointerException("bcc");
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            bl = this.children.containsValue(beanContextChild);
        }
        if (bl) {
            ClassLoader classLoader = beanContextChild.getClass().getClassLoader();
            return classLoader != null ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
        }
        throw new IllegalArgumentException("Not a valid child");
    }

    public URL getResource(String string, BeanContextChild beanContextChild) {
        boolean bl;
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (beanContextChild == null) {
            throw new NullPointerException("bcc");
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            bl = this.children.containsValue(beanContextChild);
        }
        if (bl) {
            ClassLoader classLoader = beanContextChild.getClass().getClassLoader();
            return classLoader != null ? classLoader.getResource(string) : ClassLoader.getSystemResource(string);
        }
        throw new IllegalArgumentException("Not a valid child");
    }

    public synchronized void setDesignTime(boolean bl) {
        if (this.designTime != bl) {
            this.designTime = bl;
            this.firePropertyChange("designMode", new Boolean(!bl), new Boolean(bl));
        }
    }

    public synchronized boolean isDesignTime() {
        return this.designTime;
    }

    public synchronized void setLocale(Locale locale) throws PropertyVetoException {
        if (this.locale != null && !this.locale.equals(locale) || locale != null) {
            Locale locale2 = this.locale;
            this.fireVetoableChange("locale", locale2, locale);
            this.locale = locale;
            this.firePropertyChange("locale", locale2, locale);
        }
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized boolean needsGui() {
        BeanContext beanContext = this.getBeanContextPeer();
        if (beanContext != this) {
            if (beanContext instanceof Visibility) {
                return beanContext.needsGui();
            }
            if (beanContext instanceof Container || beanContext instanceof Component) {
                return true;
            }
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iterator = this.children.keySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                try {
                    boolean bl = ((Visibility)object).needsGui();
                    return bl;
                }
                catch (ClassCastException classCastException) {
                    if (!(object instanceof Container) && !(object instanceof Component)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    public synchronized void dontUseGui() {
        if (this.okToUseGui) {
            this.okToUseGui = false;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                Iterator iterator = this.children.keySet().iterator();
                while (iterator.hasNext()) {
                    Visibility visibility = BeanContextSupport.getChildVisibility(iterator.next());
                    if (visibility == null) continue;
                    visibility.dontUseGui();
                }
            }
        }
    }

    public synchronized void okToUseGui() {
        if (!this.okToUseGui) {
            this.okToUseGui = true;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                Iterator iterator = this.children.keySet().iterator();
                while (iterator.hasNext()) {
                    Visibility visibility = BeanContextSupport.getChildVisibility(iterator.next());
                    if (visibility == null) continue;
                    visibility.okToUseGui();
                }
            }
        }
    }

    public boolean avoidingGui() {
        return !this.okToUseGui && this.needsGui();
    }

    public boolean isSerializing() {
        return this.serializing;
    }

    protected Iterator bcsChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iterator = this.children.values().iterator();
            return iterator;
        }
    }

    protected void bcsPreSerializationHook(ObjectOutputStream objectOutputStream) throws IOException {
    }

    protected void bcsPreDeserializationHook(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    protected void childDeserializedHook(Object object, BCSChild bCSChild) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            this.children.put(object, bCSChild);
        }
    }

    protected final void serialize(ObjectOutputStream objectOutputStream, Collection collection) throws IOException {
        int n = 0;
        Object[] objectArray = collection.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Serializable) {
                ++n;
            } else {
                objectArray[n2] = null;
            }
            ++n2;
        }
        objectOutputStream.writeInt(n);
        int n3 = 0;
        while (n > 0) {
            Object object = objectArray[n3];
            if (object != null) {
                objectOutputStream.writeObject(object);
                --n;
            }
            ++n3;
        }
    }

    protected final void deserialize(ObjectInputStream objectInputStream, Collection collection) throws IOException, ClassNotFoundException {
        int n = 0;
        n = objectInputStream.readInt();
        while (n-- > 0) {
            collection.add(objectInputStream.readObject());
        }
    }

    public final void writeChildren(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.serializable <= 0) {
            return;
        }
        boolean bl = this.serializing;
        this.serializing = true;
        int n = 0;
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Iterator iterator = this.children.entrySet().iterator();
            while (iterator.hasNext() && n < this.serializable) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!(entry.getKey() instanceof Serializable)) continue;
                try {
                    objectOutputStream.writeObject(entry.getKey());
                    objectOutputStream.writeObject(entry.getValue());
                }
                catch (IOException iOException) {
                    this.serializing = bl;
                    throw iOException;
                }
                ++n;
            }
        }
        this.serializing = bl;
        if (n != this.serializable) {
            throw new IOException("wrote different number of children than expected");
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        this.serializing = true;
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            try {
                objectOutputStream.defaultWriteObject();
                this.bcsPreSerializationHook(objectOutputStream);
                if (this.serializable > 0 && this.equals(this.getBeanContextPeer())) {
                    this.writeChildren(objectOutputStream);
                }
                this.serialize(objectOutputStream, this.bcmListeners);
                Object var4_3 = null;
                this.serializing = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.serializing = false;
                throw throwable;
            }
        }
    }

    public final void readChildren(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = this.serializable;
        while (n-- > 0) {
            Object object = null;
            BCSChild bCSChild = null;
            try {
                object = objectInputStream.readObject();
                bCSChild = (BCSChild)objectInputStream.readObject();
            }
            catch (IOException iOException) {
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            Object object2 = object;
            synchronized (object2) {
                BeanContextChild beanContextChild = null;
                try {
                    beanContextChild = (BeanContextChild)object;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (beanContextChild != null) {
                    try {
                        beanContextChild.setBeanContext(this.getBeanContextPeer());
                        beanContextChild.addPropertyChangeListener("beanContext", this.childPCL);
                        beanContextChild.addVetoableChangeListener("beanContext", this.childVCL);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        continue;
                    }
                }
                this.childDeserializedHook(object, bCSChild);
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            objectInputStream.defaultReadObject();
            this.initialize();
            this.bcsPreDeserializationHook(objectInputStream);
            if (this.serializable > 0 && this.equals(this.getBeanContextPeer())) {
                this.readChildren(objectInputStream);
            }
            this.bcmListeners = new ArrayList(1);
            this.deserialize(objectInputStream, this.bcmListeners);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if ("beanContext".equals(string) && this.containsKey(object) && !this.getBeanContextPeer().equals(propertyChangeEvent.getNewValue())) {
                if (!this.validatePendingRemove(object)) {
                    throw new PropertyVetoException("current BeanContext vetoes setBeanContext()", propertyChangeEvent);
                }
                ((BCSChild)this.children.get(object)).setRemovePending(true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if ("beanContext".equals(string) && this.containsKey(object) && ((BCSChild)this.children.get(object)).isRemovePending()) {
                BeanContext beanContext = this.getBeanContextPeer();
                if (beanContext.equals(propertyChangeEvent.getOldValue()) && !beanContext.equals(propertyChangeEvent.getNewValue())) {
                    this.remove(object, false);
                } else {
                    ((BCSChild)this.children.get(object)).setRemovePending(false);
                }
            }
        }
    }

    protected boolean validatePendingAdd(Object object) {
        return true;
    }

    protected boolean validatePendingRemove(Object object) {
        return true;
    }

    protected void childJustAddedHook(Object object, BCSChild bCSChild) {
    }

    protected void childJustRemovedHook(Object object, BCSChild bCSChild) {
    }

    protected static final Visibility getChildVisibility(Object object) {
        try {
            return (Visibility)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static final Serializable getChildSerializable(Object object) {
        try {
            return (Serializable)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static final PropertyChangeListener getChildPropertyChangeListener(Object object) {
        try {
            return (PropertyChangeListener)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static final VetoableChangeListener getChildVetoableChangeListener(Object object) {
        try {
            return (VetoableChangeListener)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static final BeanContextMembershipListener getChildBeanContextMembershipListener(Object object) {
        try {
            return (BeanContextMembershipListener)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected static final BeanContextChild getChildBeanContextChild(Object object) {
        try {
            BeanContextChild beanContextChild = (BeanContextChild)object;
            if (object instanceof BeanContextChild && object instanceof BeanContextProxy) {
                throw new IllegalArgumentException("child cannot implement both BeanContextChild and BeanContextProxy");
            }
            return beanContextChild;
        }
        catch (ClassCastException classCastException) {
            try {
                return ((BeanContextProxy)object).getBeanContextProxy();
            }
            catch (ClassCastException classCastException2) {
                return null;
            }
        }
    }

    protected final void fireChildrenAdded(BeanContextMembershipEvent beanContextMembershipEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            objectArray = this.bcmListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BeanContextMembershipListener)objectArray[n]).childrenAdded(beanContextMembershipEvent);
            ++n;
        }
    }

    protected final void fireChildrenRemoved(BeanContextMembershipEvent beanContextMembershipEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcmListeners;
        synchronized (arrayList) {
            objectArray = this.bcmListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BeanContextMembershipListener)objectArray[n]).childrenRemoved(beanContextMembershipEvent);
            ++n;
        }
    }

    protected synchronized void initialize() {
        this.children = new HashMap(this.serializable + 1);
        this.bcmListeners = new ArrayList(1);
        this.childPCL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BeanContextSupport.this.propertyChange(propertyChangeEvent);
            }
        };
        this.childVCL = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                BeanContextSupport.this.vetoableChange(propertyChangeEvent);
            }
        };
    }

    protected final Object[] copyChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Object[] objectArray = this.children.keySet().toArray();
            return objectArray;
        }
    }

    protected static final boolean classEquals(Class clazz, Class clazz2) {
        return clazz.equals(clazz2) || clazz.getName().equals(clazz2.getName());
    }

    protected class BCSChild
    implements Serializable {
        private Object child;
        private Object proxyPeer;
        private transient boolean removePending;

        BCSChild(Object object, Object object2) {
            this.child = object;
            this.proxyPeer = object2;
        }

        Object getChild() {
            return this.child;
        }

        void setRemovePending(boolean bl) {
            this.removePending = bl;
        }

        boolean isRemovePending() {
            return this.removePending;
        }

        boolean isProxyPeer() {
            return this.proxyPeer != null;
        }

        Object getProxyPeer() {
            return this.proxyPeer;
        }
    }

    protected static final class BCSIterator
    implements Iterator {
        private Iterator src;

        BCSIterator(Iterator iterator) {
            this.src = iterator;
        }

        public boolean hasNext() {
            return this.src.hasNext();
        }

        public Object next() {
            return this.src.next();
        }

        public void remove() {
        }
    }
}

