/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private boolean blockDataMode;
    private byte[] buf;
    private int count;
    private OutputStream out;
    private DataOutputStream dos;
    private IOException abortIOException = null;
    private HandleTable handleTable;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Stack classDescStack;
    private PutField currentPutFields;
    private Object[] writeObjectArglist = new Object[]{this};
    private static final int INITIAL_BUFFER_SIZE = 64;
    private byte[] data;
    private static final int CDATA_MAX_LEN = 1024;
    private char[] cdata;
    boolean enableReplace;
    private Object[] replaceObjects;
    private int nextReplaceOffset;
    private static final boolean REPLACEABLE = true;
    private static final boolean NOT_REPLACEABLE = false;
    private int recursionDepth = 0;
    boolean useDeprecatedExternalizableFormat = false;
    private boolean enableSubclassImplementation;
    static /* synthetic */ Class class$java$lang$String;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.enableSubclassImplementation = false;
        this.out = outputStream;
        this.dos = new DataOutputStream(this);
        this.buf = new byte[1024];
        this.writeStreamHeader();
        this.resetStream();
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void useProtocolVersion(int n) throws IOException {
        if (this.handleTable.size() != 0) {
            throw new IllegalStateException("Must call useProtocolVersion before writing any objects to the stream");
        }
        switch (n) {
            case 1: {
                this.useDeprecatedExternalizableFormat = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version:" + n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeObject(Object object) throws IOException {
        Serializable serializable;
        block26: {
            boolean bl;
            ObjectStreamClass objectStreamClass;
            Object object2;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    if (this.enableSubclassImplementation) {
                                        this.writeObjectOverride(object);
                                        return;
                                    }
                                    object2 = this.currentObject;
                                    objectStreamClass = this.currentClassDesc;
                                    bl = this.setBlockData(false);
                                    ++this.recursionDepth;
                                    try {
                                        try {
                                            if (this.serializeNullAndRepeat(object, true)) {
                                                Object var10_5 = null;
                                                --this.recursionDepth;
                                                this.currentObject = object2;
                                                this.currentClassDesc = objectStreamClass;
                                                break block20;
                                            }
                                            if (this.checkSpecialClasses(object)) {
                                                break block21;
                                            }
                                            serializable = object.getClass();
                                            Serializable serializable2 = null;
                                            Object object3 = object;
                                            this.currentClassDesc = ObjectStreamClass.lookupInternal(serializable);
                                            while (true) {
                                                if (this.currentClassDesc == null || !this.currentClassDesc.isReplaceable() || serializable == serializable2) {
                                                    if (!this.enableReplace) break;
                                                    ObjectStreamClass objectStreamClass2 = this.currentClassDesc = (object3 = this.replaceObject(object3)) != null ? ObjectStreamClass.lookupInternal(object3.getClass()) : null;
                                                }
                                                object3 = ObjectStreamClass.invokeMethod(this.currentClassDesc.writeReplaceMethod, object3, null);
                                                serializable2 = serializable;
                                                if (object3 != null) {
                                                    serializable = object3.getClass();
                                                    this.currentClassDesc = ObjectStreamClass.lookupInternal(serializable);
                                                    continue;
                                                }
                                                serializable = null;
                                                this.currentClassDesc = null;
                                            }
                                            if (object != object3) {
                                                if (object3 != null && !(object3 instanceof Serializable)) {
                                                    String string = object3.getClass().getName();
                                                    throw new NotSerializableException(string);
                                                }
                                                if (this.serializeNullAndRepeat(object3, true)) {
                                                    this.addReplacement(object, object3);
                                                    break block22;
                                                }
                                                this.addReplacement(object, object3);
                                                if (this.checkSpecialClasses(object3)) {
                                                    break block23;
                                                }
                                                object = object3;
                                            }
                                            if (this.checkSubstitutableSpecialClasses(object, this.currentClassDesc.forClass())) {
                                                break block24;
                                            }
                                            this.outputObject(object);
                                            break block25;
                                        }
                                        catch (IOException iOException) {
                                            if (this.abortIOException == null) {
                                                try {
                                                    this.setBlockData(false);
                                                    this.writeCode(123);
                                                    this.resetStream();
                                                    this.setBlockData(false);
                                                    this.currentClassDesc = ObjectStreamClass.lookupInternal(iOException.getClass());
                                                    this.outputObject(iOException);
                                                    this.resetStream();
                                                    this.abortIOException = iOException;
                                                }
                                                catch (IOException iOException2) {
                                                    this.abortIOException = new StreamCorruptedException(iOException2.getMessage());
                                                }
                                            }
                                            Object var10_11 = null;
                                            --this.recursionDepth;
                                            this.currentObject = object2;
                                            this.currentClassDesc = objectStreamClass;
                                            this.setBlockData(bl);
                                            break block26;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var10_12 = null;
                                        --this.recursionDepth;
                                        this.currentObject = object2;
                                        this.currentClassDesc = objectStreamClass;
                                        this.setBlockData(bl);
                                        throw throwable;
                                    }
                                }
                                this.setBlockData(bl);
                                return;
                            }
                            Object var10_6 = null;
                            --this.recursionDepth;
                            this.currentObject = object2;
                            this.currentClassDesc = objectStreamClass;
                            this.setBlockData(bl);
                            return;
                        }
                        Object var10_7 = null;
                        --this.recursionDepth;
                        this.currentObject = object2;
                        this.currentClassDesc = objectStreamClass;
                        this.setBlockData(bl);
                        return;
                    }
                    Object var10_8 = null;
                    --this.recursionDepth;
                    this.currentObject = object2;
                    this.currentClassDesc = objectStreamClass;
                    this.setBlockData(bl);
                    return;
                }
                Object var10_9 = null;
                --this.recursionDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
                this.setBlockData(bl);
                return;
            }
            Object var10_10 = null;
            --this.recursionDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            this.setBlockData(bl);
        }
        serializable = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (serializable != null) {
            throw serializable;
        }
    }

    private boolean checkSpecialClasses(Object object) throws IOException {
        if (object instanceof Class) {
            this.outputClass((Class)object);
            return true;
        }
        if (object instanceof ObjectStreamClass) {
            this.outputClassDescriptor((ObjectStreamClass)object);
            return true;
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object object, Class clazz) throws IOException {
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = ObjectOutputStream.class$("java.lang.String")) : class$java$lang$String)) {
            this.outputString((String)object);
            return true;
        }
        if (clazz.isArray()) {
            this.outputArray(object);
            return true;
        }
        return false;
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObject");
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        if (objectStreamFieldArray.length > 0) {
            boolean bl = this.setBlockData(false);
            this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            this.setBlockData(bl);
        }
    }

    public PutField putFields() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("putFields");
        }
        this.currentPutFields = new PutFieldImpl(this.currentClassDesc);
        return this.currentPutFields;
    }

    public void writeFields() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null || this.currentPutFields == null) {
            throw new NotActiveException("writeFields");
        }
        boolean bl = this.setBlockData(false);
        this.currentPutFields.write(this);
        this.setBlockData(bl);
    }

    public void reset() throws IOException {
        if (this.currentObject != null || this.currentClassDesc != null) {
            throw new IOException("Illegal call to reset");
        }
        this.setBlockData(false);
        this.writeCode(121);
        this.resetStream();
        this.abortIOException = null;
    }

    private void resetStream() throws IOException {
        if (this.handleTable == null) {
            this.handleTable = new HandleTable();
        } else {
            this.handleTable.clear();
        }
        if (this.classDescStack == null) {
            this.classDescStack = new Stack();
        } else {
            this.classDescStack.setSize(0);
        }
        int n = 0;
        while (n < this.nextReplaceOffset) {
            this.replaceObjects[n] = null;
            ++n;
        }
        this.nextReplaceOffset = 0;
        this.setBlockData(true);
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableReplace;
        if (bl) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(ObjectStreamConstants.SUBSTITUTION_PERMISSION);
            }
            this.enableReplace = true;
        } else {
            this.enableReplace = false;
        }
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
    }

    private void outputString(String string) throws IOException {
        int n = string.length();
        this.handleTable.assignWireOffset(string);
        if (this.cdata == null || this.cdata.length < n) {
            this.cdata = string.toCharArray();
        } else {
            string.getChars(0, n, this.cdata, 0);
        }
        long l = ObjectOutputStream.getUTFLength(this.cdata, n);
        if (l <= 65535L) {
            this.writeCode(116);
            this.writeShort((int)l);
        } else {
            this.writeCode(124);
            this.writeLong(l);
        }
        this.writeUTFBody(this.cdata, n);
        if (n > 1024) {
            this.cdata = null;
        }
    }

    private static long getUTFLength(char[] cArray, int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            l = c >= '\u0001' && c <= '\u007f' ? ++l : (c > '\u07ff' ? (l += 3L) : (l += 2L));
            ++n2;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeUTFBody(char[] cArray, int n) throws IOException {
        int n2 = this.buf.length - 2;
        int n3 = 0;
        while (n3 < n) {
            block9: {
                char c;
                block10: {
                    block11: {
                        c = cArray[n3];
                        if (this.count < n2) break block10;
                        if (!this.blockDataMode) break block11;
                        if (c >= '\u0001' && c <= '\u007f') {
                            this.write(c);
                            break block9;
                        } else if (c > '\u07ff') {
                            this.write(0xE0 | c >> 12 & 0xF);
                            this.write(0x80 | c >> 6 & 0x3F);
                            this.write(0x80 | c >> 0 & 0x3F);
                            break block9;
                        } else {
                            this.write(0xC0 | c >> 6 & 0x1F);
                            this.write(0x80 | c >> 0 & 0x3F);
                        }
                        break block9;
                    }
                    this.drain();
                }
                if (c >= '\u0001' && c <= '\u007f') {
                    this.buf[this.count++] = (byte)c;
                } else if (c > '\u07ff') {
                    this.buf[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buf[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    this.buf[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
            }
            ++n3;
        }
    }

    private void outputClass(Class clazz) throws IOException {
        this.writeCode(118);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookupInternal(clazz);
        if (objectStreamClass == null) {
            throw new NotSerializableException(clazz.getName());
        }
        this.outputClassDescriptor(objectStreamClass);
        this.handleTable.assignWireOffset(clazz);
    }

    private void writeClassDescriptor0(ObjectStreamClass objectStreamClass) throws IOException {
        this.writeUTF(objectStreamClass.getName());
        this.writeLong(objectStreamClass.getSerialVersionUID());
        objectStreamClass.write(this);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        this.writeClassDescriptor0(objectStreamClass);
    }

    private void outputClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        if (this.serializeNullAndRepeat(objectStreamClass, false)) {
            return;
        }
        Class clazz = objectStreamClass.forClass();
        if (!objectStreamClass.forProxyClass) {
            this.writeCode(114);
            this.handleTable.assignWireOffset(objectStreamClass);
            if (this.useDeprecatedExternalizableFormat) {
                this.writeClassDescriptor0(objectStreamClass);
            } else {
                this.writeClassDescriptor(objectStreamClass);
            }
            boolean bl = this.setBlockData(true);
            this.annotateClass(clazz);
            this.setBlockData(bl);
            this.writeCode(120);
            ObjectStreamClass objectStreamClass2 = objectStreamClass.getSuperclass();
            this.outputClassDescriptor(objectStreamClass2);
        } else {
            this.writeCode(125);
            this.handleTable.assignWireOffset(objectStreamClass);
            Class[] classArray = clazz.getInterfaces();
            this.writeInt(classArray.length);
            int n = 0;
            while (n < classArray.length) {
                this.writeUTF(classArray[n].getName());
                ++n;
            }
            boolean bl = this.setBlockData(true);
            this.annotateProxyClass(clazz);
            this.setBlockData(bl);
            this.writeCode(120);
            this.outputClassDescriptor(objectStreamClass.getSuperclass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputArray(Object object) throws IOException {
        Class clazz = this.currentClassDesc.forClass();
        this.writeCode(117);
        this.outputClassDescriptor(this.currentClassDesc);
        this.handleTable.assignWireOffset(object);
        Class clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n = nArray.length;
                int n2 = this.buf.length - 4;
                this.writeInt(n);
                int n3 = 0;
                while (n3 < n) {
                    if (this.count > n2) {
                        this.drain();
                    }
                    int n4 = nArray[n3];
                    this.buf[this.count++] = (byte)(n4 >>> 24);
                    this.buf[this.count++] = (byte)(n4 >>> 16);
                    this.buf[this.count++] = (byte)(n4 >>> 8);
                    this.buf[this.count++] = (byte)(n4 >>> 0);
                    ++n3;
                }
                return;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n = byArray.length;
                this.writeInt(n);
                this.writeInternal(byArray, 0, n, true);
                return;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                int n = lArray.length;
                int n5 = this.buf.length - 8;
                this.writeInt(n);
                int n6 = 0;
                while (n6 < n) {
                    if (this.count > n5) {
                        this.drain();
                    }
                    long l = lArray[n6];
                    this.buf[this.count++] = (byte)(l >>> 56);
                    this.buf[this.count++] = (byte)(l >>> 48);
                    this.buf[this.count++] = (byte)(l >>> 40);
                    this.buf[this.count++] = (byte)(l >>> 32);
                    this.buf[this.count++] = (byte)(l >>> 24);
                    this.buf[this.count++] = (byte)(l >>> 16);
                    this.buf[this.count++] = (byte)(l >>> 8);
                    this.buf[this.count++] = (byte)(l >>> 0);
                    ++n6;
                }
                return;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                int n = fArray.length;
                this.writeInt(n);
                int n7 = 0;
                while (n > 0) {
                    int n8 = this.buf.length - this.count >> 2;
                    if (n8 > 0) {
                        int n9 = n < n8 ? n : n8;
                        ObjectOutputStream.floatsToBytes(fArray, n7, this.buf, this.count, n9);
                        n7 += n9;
                        n -= n9;
                        this.count += n9 << 2;
                        continue;
                    }
                    this.drain();
                }
                return;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                int n = dArray.length;
                this.writeInt(n);
                int n10 = 0;
                while (n > 0) {
                    int n11 = this.buf.length - this.count >> 3;
                    if (n11 > 0) {
                        int n12 = n < n11 ? n : n11;
                        ObjectOutputStream.doublesToBytes(dArray, n10, this.buf, this.count, n12);
                        n10 += n12;
                        n -= n12;
                        this.count += n12 << 3;
                        continue;
                    }
                    this.drain();
                }
                return;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                int n = sArray.length;
                int n13 = this.buf.length - 2;
                this.writeInt(n);
                int n14 = 0;
                while (n14 < n) {
                    if (this.count > n13) {
                        this.drain();
                    }
                    short s = sArray[n14];
                    this.buf[this.count++] = (byte)(s >>> 8);
                    this.buf[this.count++] = (byte)(s >>> 0);
                    ++n14;
                }
                return;
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                int n = cArray.length;
                int n15 = this.buf.length - 2;
                this.writeInt(n);
                int n16 = 0;
                while (n16 < n) {
                    if (this.count > n15) {
                        this.drain();
                    }
                    char c = cArray[n16];
                    this.buf[this.count++] = (byte)(c >>> 8);
                    this.buf[this.count++] = (byte)(c >>> 0);
                    ++n16;
                }
                return;
            } else {
                if (clazz2 != Boolean.TYPE) throw new InvalidClassException(clazz.getName());
                boolean[] blArray = (boolean[])object;
                int n = blArray.length;
                int n17 = this.buf.length - 1;
                this.writeInt(n);
                int n18 = 0;
                while (n18 < n) {
                    if (this.count > n17) {
                        this.drain();
                    }
                    this.buf[this.count++] = blArray[n18] ? (byte)1 : 0;
                    ++n18;
                }
            }
            return;
        } else {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            this.writeInt(n);
            int n19 = 0;
            while (n19 < n) {
                this.writeObject(objectArray[n19]);
                ++n19;
            }
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    void writeTypeString(String string) throws IOException {
        int n = this.handleTable.findWireOffset(string);
        if (n >= 0) {
            this.writeCode(113);
            this.writeInt(n + 0x7E0000);
        } else {
            this.handleTable.assignWireOffset(string);
            this.writeCode(116);
            this.writeUTF(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputObject(Object object) throws IOException {
        this.currentObject = object;
        if (this.currentClassDesc.isNonSerializable()) {
            throw new NotSerializableException(this.currentClassDesc.getName());
        }
        this.writeCode(115);
        this.outputClassDescriptor(this.currentClassDesc);
        this.handleTable.assignWireOffset(object);
        if (this.currentClassDesc.isExternalizable()) {
            Externalizable externalizable = (Externalizable)object;
            if (this.useDeprecatedExternalizableFormat) {
                externalizable.writeExternal(this);
                return;
            }
            this.setBlockData(true);
            try {
                externalizable.writeExternal(this);
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.setBlockData(false);
                this.writeCode(120);
                throw throwable;
            }
            this.setBlockData(false);
            this.writeCode(120);
            return;
        }
        int n = this.classDescStack.size();
        try {
            ObjectStreamClass objectStreamClass;
            while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                this.classDescStack.push(this.currentClassDesc);
                this.currentClassDesc = objectStreamClass;
            }
            do {
                if (this.currentClassDesc.hasWriteObject()) {
                    this.setBlockData(true);
                    this.invokeObjectWriter(object);
                    this.setBlockData(false);
                    this.writeCode(120);
                } else {
                    this.defaultWriteObject();
                }
                if (this.classDescStack.size() <= n) break;
            } while ((this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
            Object var6_8 = null;
            this.classDescStack.setSize(n);
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.classDescStack.setSize(n);
            throw throwable;
        }
    }

    private Object lookupReplace(Object object) {
        int n = 0;
        while (n < this.nextReplaceOffset) {
            if (this.replaceObjects[n] == object) {
                return this.replaceObjects[n + 1];
            }
            n += 2;
        }
        return object;
    }

    private boolean serializeNullAndRepeat(Object object, boolean bl) throws IOException {
        int n;
        if (object == null) {
            this.writeCode(112);
            return true;
        }
        if (bl && this.replaceObjects != null) {
            object = this.lookupReplace(object);
        }
        if ((n = this.handleTable.findWireOffset(object)) >= 0) {
            this.writeCode(113);
            this.writeInt(n + 0x7E0000);
            return true;
        }
        return false;
    }

    private void addReplacement(Object object, Object object2) {
        if (this.replaceObjects == null) {
            this.replaceObjects = new Object[10];
        }
        if (this.nextReplaceOffset == this.replaceObjects.length) {
            Object[] objectArray = this.replaceObjects;
            this.replaceObjects = new Object[2 + this.nextReplaceOffset * 2];
            System.arraycopy(objectArray, 0, this.replaceObjects, 0, this.nextReplaceOffset);
        }
        this.replaceObjects[this.nextReplaceOffset++] = object;
        this.replaceObjects[this.nextReplaceOffset++] = object2;
    }

    private void writeCode(int n) throws IOException {
        this.writeByte(n);
    }

    public void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void writeInternal(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeCanonical(byArray, n, n2);
        } else {
            int n3 = this.buf.length - this.count;
            if (n2 <= n3) {
                System.arraycopy(byArray, n, this.buf, this.count, n2);
                this.count += n2;
            } else if (bl) {
                this.bufferedWrite(byArray, n, n2);
            } else {
                this.drain();
                this.out.write(byArray, n, n2);
            }
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeInternal(byArray, n, n2, false);
    }

    private void bufferedWrite(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = this.buf.length - this.count;
        if (n3 > n4) {
            System.arraycopy(byArray, n, this.buf, this.count, n4);
            n += n4;
            n3 -= n4;
            this.out.write(this.buf, 0, this.buf.length);
            this.count = 0;
            while (n3 >= this.buf.length) {
                System.arraycopy(byArray, n, this.buf, 0, this.buf.length);
                this.out.write(this.buf, 0, this.buf.length);
                n += this.buf.length;
                n3 -= this.buf.length;
            }
        }
        if (n3 != 0) {
            System.arraycopy(byArray, n, this.buf, this.count, n3);
            this.count += n3;
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    protected void drain() throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeBlockDataHeader(this.count);
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        this.drain();
        this.blockDataMode = bl;
        return !bl;
    }

    private void writeBlockDataHeader(int n) throws IOException {
        if (n <= 255) {
            this.out.write(119);
            this.out.write((byte)n);
        } else {
            this.out.write(122);
            this.out.write((byte)(n >> 24 & 0xFF));
            this.out.write((byte)(n >> 16 & 0xFF));
            this.out.write((byte)(n >> 8 & 0xFF));
            this.out.write((byte)(n & 0xFF));
        }
    }

    private void writeCanonical(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        int n4 = this.buf.length - this.count;
        if (n3 > n4) {
            this.writeBlockDataHeader(this.buf.length);
            this.out.write(this.buf, 0, this.count);
            this.out.write(byArray, n, n4);
            this.count = 0;
            n += n4;
            n3 -= n4;
            while (n3 >= this.buf.length) {
                if (this.blockDataMode) {
                    this.writeBlockDataHeader(this.buf.length);
                }
                this.out.write(byArray, n, this.buf.length);
                n += this.buf.length;
                n3 -= this.buf.length;
            }
        }
        if (n3 != 0) {
            System.arraycopy(byArray, n, this.buf, this.count, n3);
            this.count += n3;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (this.count >= this.buf.length) {
            this.dos.writeBoolean(bl);
            return;
        }
        this.buf[this.count++] = bl ? (byte)1 : 0;
    }

    public void writeByte(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.dos.writeByte(n);
            return;
        }
        this.buf[this.count++] = (byte)n;
    }

    public void writeShort(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.dos.writeShort(n);
            return;
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeChar(int n) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.dos.writeChar(n);
            return;
        }
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeInt(int n) throws IOException {
        if (this.count + 4 > this.buf.length) {
            this.dos.writeInt(n);
            return;
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeLong(long l) throws IOException {
        if (this.count + 8 > this.buf.length) {
            this.dos.writeLong(l);
            return;
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public void writeFloat(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        if (this.count + 4 > this.buf.length) {
            this.dos.writeFloat(f);
            return;
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)(n >>> 0);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        if (this.count + 8 > this.buf.length) {
            this.dos.writeDouble(d);
            return;
        }
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)(l >>> 0);
    }

    public void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = this.buf.length;
        int n3 = 0;
        while (n3 < n) {
            if (this.count >= n2) {
                this.drain();
            }
            this.buf[this.count++] = (byte)cArray[n3];
            ++n3;
        }
    }

    public void writeChars(String string) throws IOException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = this.buf.length - 2;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (this.count > n2) {
                this.dos.writeChar(c);
            } else {
                this.buf[this.count++] = (byte)(c >>> 8);
                this.buf[this.count++] = (byte)(c >>> 0);
            }
            ++n3;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n = string.length();
        if (this.cdata == null || this.cdata.length < n) {
            this.cdata = string.toCharArray();
        } else {
            string.getChars(0, n, this.cdata, 0);
        }
        long l = ObjectOutputStream.getUTFLength(this.cdata, n);
        if (l > 65535L) {
            throw new UTFDataFormatException();
        }
        this.writeShort((int)l);
        this.writeUTFBody(this.cdata, n);
        if (n > 1024) {
            this.cdata = null;
        }
    }

    private void outputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        int n = this.currentClassDesc.numPrimBytes;
        if (n > 0) {
            if (this.data == null) {
                this.data = new byte[Math.max(n, 64)];
            } else if (this.data.length < n) {
                this.data = new byte[n];
            }
            ObjectOutputStream.getPrimitiveFieldValues(object, this.currentClassDesc.primFieldIDs, this.currentClassDesc.primFieldTypecodes, this.data);
            this.writeInternal(this.data, 0, n, false);
        }
        int n2 = objectStreamFieldArray.length - this.currentClassDesc.numObjFields;
        long[] lArray = this.currentClassDesc.objFieldIDs;
        int n3 = 0;
        while (n3 < this.currentClassDesc.numObjFields) {
            Object object2;
            try {
                object2 = ObjectOutputStream.getObjectFieldValue(object, lArray[n3]);
            }
            catch (Exception exception) {
                throw new InvalidClassException(clazz.getName(), "Invalid field " + objectStreamFieldArray[n2 + n3].getName());
            }
            this.writeObject(object2);
            ++n3;
        }
    }

    private static native void getPrimitiveFieldValues(Object var0, long[] var1, char[] var2, byte[] var3);

    private static native Object getObjectFieldValue(Object var0, long var1);

    private void invokeObjectWriter(Object object) throws IOException {
        try {
            this.currentClassDesc.writeObjectMethod.invoke(object, this.writeObjectArglist);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("internal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Unable to access writeObject method");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class Stack
    extends ArrayList {
        private static final long serialVersionUID = -428799992207134975L;

        private Stack() {
        }

        public void setSize(int n) {
            if (n == 0) {
                this.clear();
            } else {
                int n2 = this.size();
                int n3 = n2 - 1;
                while (n3 >= n) {
                    this.remove(n3);
                    --n3;
                }
            }
        }

        public Object push(Object object) {
            this.add(object);
            return object;
        }

        public Object pop() {
            int n = this.size();
            Object object = this.peek();
            this.remove(n - 1);
            return object;
        }

        public Object peek() {
            int n = this.size();
            if (n == 0) {
                throw new EmptyStackException();
            }
            return this.get(n - 1);
        }
    }

    private static final class HandleTable {
        private static final int START_SIZE_POWER = 2;
        private static final int LOAD_FACTOR = 7;
        private static final int START_CAPACITY = 4;
        private int nextWireOffset;
        private int wireHashSizePower = 2;
        private int wireHashCapacity;
        private int[] wireHash2Handle;
        private int[] wireNextHandle;
        private Object[] wireHandle2Object;

        public HandleTable() {
            int n = 1 << this.wireHashSizePower;
            this.wireHashCapacity = n * 7;
            this.wireHash2Handle = new int[n - 1];
            this.wireNextHandle = new int[4];
            this.wireHandle2Object = new Object[4];
            this.clear();
        }

        public int assignWireOffset(Object object) {
            if (this.nextWireOffset >= this.wireNextHandle.length) {
                this.growEntries();
            }
            if (this.nextWireOffset >= this.wireHashCapacity) {
                this.growSpine();
            }
            this.insert(object, this.nextWireOffset);
            return this.nextWireOffset++;
        }

        private void insert(Object object, int n) {
            int n2 = (System.identityHashCode(object) & Integer.MAX_VALUE) % this.wireHash2Handle.length;
            this.wireHandle2Object[n] = object;
            this.wireNextHandle[n] = this.wireHash2Handle[n2];
            this.wireHash2Handle[n2] = n;
        }

        private void growSpine() {
            ++this.wireHashSizePower;
            int n = 1 << this.wireHashSizePower;
            this.wireHashCapacity = n * 7;
            this.wireHash2Handle = new int[n - 1];
            Arrays.fill(this.wireHash2Handle, -1);
            int n2 = 0;
            while (n2 < this.nextWireOffset) {
                this.insert(this.wireHandle2Object[n2], n2);
                ++n2;
            }
        }

        private void growEntries() {
            int[] nArray = new int[this.wireNextHandle.length * 2];
            System.arraycopy(this.wireNextHandle, 0, nArray, 0, this.nextWireOffset);
            this.wireNextHandle = nArray;
            Object[] objectArray = new Object[this.wireHandle2Object.length * 2];
            System.arraycopy(this.wireHandle2Object, 0, objectArray, 0, this.nextWireOffset);
            this.wireHandle2Object = objectArray;
        }

        public int findWireOffset(Object object) {
            int n = (System.identityHashCode(object) & Integer.MAX_VALUE) % this.wireHash2Handle.length;
            int n2 = this.wireHash2Handle[n];
            while (n2 >= 0) {
                if (this.wireHandle2Object[n2] == object) {
                    return n2;
                }
                n2 = this.wireNextHandle[n2];
            }
            return -1;
        }

        public void clear() {
            this.nextWireOffset = 0;
            Arrays.fill(this.wireHash2Handle, -1);
        }

        public int size() {
            return this.nextWireOffset;
        }
    }

    static final class PutFieldImpl
    extends PutField {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;
        static /* synthetic */ Class class$java$lang$Object;

        public void put(String string, boolean bl) throws IllegalArgumentException {
            ObjectStreamField objectStreamField = this.desc.getField(string, Boolean.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Boolean.TYPE) {
                throw new IllegalArgumentException("No such boolean field");
            }
            this.data[objectStreamField.getOffset()] = bl ? (byte)1 : 0;
        }

        public void put(String string, char c) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Character.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Character.TYPE) {
                throw new IllegalArgumentException("No such char field");
            }
            this.data[objectStreamField.getOffset()] = (byte)(c >> 8);
            this.data[objectStreamField.getOffset() + 1] = (byte)c;
        }

        public void put(String string, byte by) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Byte.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Byte.TYPE) {
                throw new IllegalArgumentException("No such byte field");
            }
            this.data[objectStreamField.getOffset()] = by;
        }

        public void put(String string, short s) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Short.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Short.TYPE) {
                throw new IllegalArgumentException("No such short field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(s >> 8);
            this.data[n + 1] = (byte)s;
        }

        public void put(String string, int n) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Integer.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("No such int field");
            }
            int n2 = objectStreamField.getOffset();
            this.data[n2] = (byte)(n >> 24);
            this.data[n2 + 1] = (byte)(n >> 16);
            this.data[n2 + 2] = (byte)(n >> 8);
            this.data[n2 + 3] = (byte)n;
        }

        public void put(String string, long l) {
            ObjectStreamField objectStreamField = this.desc.getField(string, Long.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Long.TYPE) {
                throw new IllegalArgumentException("No such long field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(l >> 56);
            this.data[n + 1] = (byte)(l >> 48);
            this.data[n + 2] = (byte)(l >> 40);
            this.data[n + 3] = (byte)(l >> 32);
            this.data[n + 4] = (byte)(l >> 24);
            this.data[n + 5] = (byte)(l >> 16);
            this.data[n + 6] = (byte)(l >> 8);
            this.data[n + 7] = (byte)l;
        }

        public void put(String string, float f) {
            int n = Float.floatToIntBits(f);
            ObjectStreamField objectStreamField = this.desc.getField(string, Float.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Float.TYPE) {
                throw new IllegalArgumentException("No such float field");
            }
            int n2 = objectStreamField.getOffset();
            this.data[n2] = (byte)(n >> 24);
            this.data[n2 + 1] = (byte)(n >> 16);
            this.data[n2 + 2] = (byte)(n >> 8);
            this.data[n2 + 3] = (byte)n;
        }

        public void put(String string, double d) {
            long l = Double.doubleToLongBits(d);
            ObjectStreamField objectStreamField = this.desc.getField(string, Double.TYPE);
            if (objectStreamField == null || objectStreamField.getType() != Double.TYPE) {
                throw new IllegalArgumentException("No such double field");
            }
            int n = objectStreamField.getOffset();
            this.data[n] = (byte)(l >> 56);
            this.data[n + 1] = (byte)(l >> 48);
            this.data[n + 2] = (byte)(l >> 40);
            this.data[n + 3] = (byte)(l >> 32);
            this.data[n + 4] = (byte)(l >> 24);
            this.data[n + 5] = (byte)(l >> 16);
            this.data[n + 6] = (byte)(l >> 8);
            this.data[n + 7] = (byte)l;
        }

        public void put(String string, Object object) {
            ObjectStreamField objectStreamField = this.desc.getField(string, class$java$lang$Object == null ? (class$java$lang$Object = PutFieldImpl.class$("java.lang.Object")) : class$java$lang$Object);
            if (objectStreamField == null || objectStreamField.isPrimitive()) {
                throw new IllegalArgumentException("No such object field");
            }
            this.objects[objectStreamField.getOffset()] = object;
        }

        public void write(ObjectOutput objectOutput) throws IOException {
            if (this.data != null) {
                objectOutput.write(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                int n = 0;
                while (n < this.objects.length) {
                    objectOutput.writeObject(this.objects[n]);
                    ++n;
                }
            }
        }

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            if (this.desc.numPrimBytes > 0) {
                this.data = new byte[this.desc.numPrimBytes];
            }
            if (this.desc.numObjFields > 0) {
                this.objects = new Object[this.desc.numObjFields];
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

