/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Rectangle;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.SpanIterator;

public class Region {
    public static final int INIT_SIZE = 50;
    public static final int GROW_SIZE = 50;
    int[] bands = new int[50];
    int endIndex;
    int prevYrow;
    int curYrow;
    int lox;
    int loy;
    int hix;
    int hiy;

    public void setOutputArea(Rectangle rectangle) {
        this.setOutputArea(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setOutputArea(int n, int n2, int n3, int n4) {
        this.lox = n;
        this.loy = n2;
        this.hix = n + n3;
        this.hiy = n2 + n4;
    }

    public void appendSpans(SpanIterator spanIterator) {
        int[] nArray = new int[4];
        while (spanIterator.nextSpan(nArray)) {
            this.appendSpan(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        this.endRow();
        this.calcBBox();
    }

    public void appendSpan(int n, int n2, int n3, int n4) {
        if (n < this.lox) {
            n = this.lox;
        }
        if (n2 < this.loy) {
            n2 = this.loy;
        }
        if (n3 > this.hix) {
            n3 = this.hix;
        }
        if (n4 > this.hiy) {
            n4 = this.hiy;
        }
        if (n3 <= n || n4 <= n2) {
            return;
        }
        if (this.endIndex == 0 || n2 >= this.bands[this.curYrow + 1]) {
            this.endRow();
            this.needSpace(5);
            this.bands[this.endIndex++] = n2;
            this.bands[this.endIndex++] = n4;
            this.bands[this.endIndex++] = 0;
        } else if (n2 == this.bands[this.curYrow] && n4 == this.bands[this.curYrow + 1] && n >= this.bands[this.endIndex - 1]) {
            if (n == this.bands[this.endIndex - 1]) {
                this.bands[this.endIndex - 1] = n3;
                return;
            }
            this.needSpace(2);
        } else {
            throw new InternalError("bad span");
        }
        this.bands[this.endIndex++] = n;
        this.bands[this.endIndex++] = n3;
        int n5 = this.curYrow + 2;
        this.bands[n5] = this.bands[n5] + 1;
    }

    void needSpace(int n) {
        if (this.endIndex + n >= this.bands.length) {
            int[] nArray = new int[this.bands.length + 50];
            System.arraycopy(this.bands, 0, nArray, 0, this.endIndex);
            this.bands = nArray;
        }
    }

    void endRow() {
        int[] nArray;
        int n = this.curYrow;
        int n2 = this.prevYrow;
        if (n > n2 && (nArray = this.bands)[n2 + 1] == nArray[n] && nArray[n2 + 2] == nArray[n + 2]) {
            int n3 = nArray[n + 2] * 2;
            n += 3;
            n2 += 3;
            while (n3 > 0) {
                if (nArray[n++] != nArray[n2++]) break;
                --n3;
            }
            if (n3 == 0) {
                nArray[this.prevYrow + 1] = nArray[this.curYrow + 1];
                this.endIndex = this.curYrow;
                return;
            }
        }
        this.prevYrow = this.curYrow;
        this.curYrow = this.endIndex;
    }

    void calcBBox() {
        if (this.endIndex == 0) {
            this.hiy = 0;
            this.hix = 0;
            this.loy = 0;
            this.lox = 0;
            return;
        }
        int n = this.hix;
        int n2 = this.lox;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = this.bands;
        while (n4 < this.endIndex) {
            n3 = n4;
            int n5 = nArray[n4 + 2];
            if (n > nArray[n4 += 3]) {
                n = nArray[n4];
            }
            if (n2 >= nArray[(n4 += n5 * 2) - 1]) continue;
            n2 = nArray[n4 - 1];
        }
        this.lox = n;
        this.loy = nArray[0];
        this.hix = n2;
        this.hiy = nArray[n3 + 1];
    }

    public void getBounds(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public RegionIterator getIterator() {
        return new RegionIterator(this);
    }
}

