/*
 * Decompiled with CFR 0.152.
 */
package sun.beanbox.simpleresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.beanbox.SimpleClassLoader;

public class SimpleResourceConnection
extends URLConnection {
    private static boolean debug = false;
    private Object resource;
    private String cookie;
    private String name;
    private final String prefix = "SIMPLE";
    private final int prefixLength = "SIMPLE".length();

    protected SimpleResourceConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        this.debug("SimpleResourceConnection(" + uRL + ")");
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("SIMPLE")) {
            throw new MalformedURLException("SimpleResource file should start with /SIMPLE");
        }
        this.cookie = string.substring(this.prefixLength, string.indexOf("/+/"));
        this.name = string.substring(string.indexOf("/+/") + 3);
        this.debug(" cookie: " + this.cookie);
        this.debug(" name: " + this.name);
    }

    public void connect() throws IOException {
        this.debug("Looking for " + this.cookie + ", " + this.name + " in SimpleResourceLoader");
        Object object = SimpleClassLoader.getLocalResource(this.cookie, this.name);
        if (object == null) {
            this.debug("Invalid resource name");
            this.resource = null;
            return;
        }
        this.debug("Found resource " + object);
        this.resource = object;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return SimpleClassLoader.getLocalResourceAsStream(this.cookie, this.name);
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

