/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole;

import java.awt.Color;
import java.awt.Component;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import sun.awt.EmbeddedFrame;
import sun.beanbox.SimpleClassLoader;
import sun.beans.ole.ObjectProxy;

public class CustomizerInterface
implements PropertyChangeListener {
    private String customizerClass;
    private Customizer cust;
    private int handle;
    private Object[] targetBeans;
    private boolean dirty;

    private CustomizerInterface(String string, int n) {
        this.customizerClass = string;
        this.handle = n;
    }

    public Component getCustomizerComponent() {
        Class clazz;
        SimpleClassLoader simpleClassLoader;
        try {
            simpleClassLoader = SimpleClassLoader.ourLoader;
            clazz = simpleClassLoader.loadClass(this.customizerClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("No class " + this.customizerClass);
            return null;
        }
        try {
            simpleClassLoader = clazz.newInstance();
        }
        catch (Throwable throwable) {
            System.err.println("no instanciation");
            return null;
        }
        if (simpleClassLoader instanceof Component) {
            return (Component)((Object)simpleClassLoader);
        }
        return null;
    }

    public boolean openCustomizer(EmbeddedFrame embeddedFrame, Color color) {
        if (this.cust == null) {
            return false;
        }
        if (!(this.cust instanceof Component)) {
            return false;
        }
        Component component = (Component)((Object)this.cust);
        component.setSize(component.getPreferredSize());
        ((Component)embeddedFrame).setBackground(color);
        component.setBackground(color);
        embeddedFrame.add(component);
        embeddedFrame.validate();
        this.cust.addPropertyChangeListener(this);
        return true;
    }

    public void closeCustomizer() {
        this.cust.removePropertyChangeListener(this);
    }

    public void setObjects(Object[] objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        System.err.println("Nb of objects = " + objectArray.length);
        Component component = this.getCustomizerComponent();
        if (component instanceof Customizer) {
            this.cust = (Customizer)((Object)component);
        }
        if (!(objectArray[0] instanceof ObjectProxy)) {
            return;
        }
        ObjectProxy objectProxy = (ObjectProxy)objectArray[0];
        this.cust.setObject(objectProxy.getInterfacedObject());
        this.targetBeans = objectArray;
    }

    public synchronized void apply() {
        this.dirty = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CustomizerInterface customizerInterface = this;
        synchronized (customizerInterface) {
            System.err.println("Property Changed");
            this.dirty = true;
        }
    }
}

