/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

class Arguments
extends ScriptableObject {
    private NativeCall activation;
    private Object[] args;
    private boolean hasCaller;

    public Arguments(NativeCall nativeCall) {
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.getOriginalArguments();
        int n = this.args.length;
        NativeFunction nativeFunction = nativeCall.funObj;
        this.defineProperty("length", new Integer(n), 2);
        this.defineProperty("callee", nativeFunction, 2);
        this.hasCaller = nativeCall.funObj.version <= 130 && nativeCall.funObj.version != 0;
    }

    public void delete(String string) {
        if (string.equals("caller")) {
            this.hasCaller = false;
        }
        super.delete(string);
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.args.length) {
            NativeFunction nativeFunction = this.activation.funObj;
            if (n < nativeFunction.argCount) {
                return this.activation.get(nativeFunction.names[n + 1], (Scriptable)this.activation);
            }
            return this.args[n];
        }
        return super.get(n, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        if (this.hasCaller && string.equals("caller")) {
            NativeCall nativeCall = this.activation.caller;
            if (nativeCall == null || nativeCall.originalArgs == null) {
                return null;
            }
            return nativeCall.get("arguments", (Scriptable)nativeCall);
        }
        return super.get(string, scriptable);
    }

    public String getClassName() {
        return "Arguments";
    }

    public boolean has(int n, Scriptable scriptable) {
        Object[] objectArray = this.activation.getOriginalArguments();
        return n >= 0 && n < objectArray.length || super.has(n, scriptable);
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.hasCaller && string.equals("caller") || super.has(string, scriptable);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.args.length) {
            NativeFunction nativeFunction = this.activation.funObj;
            if (n < nativeFunction.argCount) {
                this.activation.put(nativeFunction.names[n + 1], (Scriptable)this.activation, object);
            } else {
                this.args[n] = object;
            }
            return;
        }
        super.put(n, scriptable, object);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (string.equals("caller")) {
            this.hasCaller = false;
        }
        super.put(string, scriptable, object);
    }
}

