/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

class JavaMembers {
    static Hashtable classTable = new Hashtable();
    private Class cl;
    private Hashtable members = new Hashtable(23);
    private Hashtable fieldAndMethods;
    private Hashtable staticMembers = new Hashtable(7);
    private Hashtable staticFieldAndMethods;
    private Constructor[] ctors;

    JavaMembers(Scriptable scriptable, Class clazz) {
        this.cl = clazz;
        this.reflect(scriptable, clazz);
    }

    Member findExplicitFunction(String string, boolean bl) {
        Object object;
        boolean bl2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = string.indexOf(40);
        Executable[] executableArray = null;
        NativeJavaMethod nativeJavaMethod = null;
        boolean bl3 = bl2 = bl && n == 0;
        if (bl2) {
            executableArray = this.ctors;
        } else if (n > 0) {
            String string2 = string.substring(0, n);
            object = hashtable.get(string2);
            if (!bl && object == null) {
                object = this.staticMembers.get(string2);
            }
            if (object != null && object instanceof NativeJavaMethod) {
                nativeJavaMethod = (NativeJavaMethod)object;
                executableArray = nativeJavaMethod.getMethods();
            }
        }
        if (executableArray != null) {
            int n2 = 0;
            while (n2 < executableArray.length) {
                object = NativeJavaMethod.signature(executableArray[n2]);
                if (string.equals(object)) {
                    return executableArray[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    Object get(Scriptable scriptable, String string, Object object, boolean bl) {
        Class<?> clazz;
        Object object2;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object3 = hashtable.get(string);
        if (!bl && object3 == null) {
            object3 = this.staticMembers.get(string);
        }
        if (object3 == null && (object3 = this.getExplicitFunction(scriptable, string, object, bl)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (object3 instanceof Scriptable) {
            return object3;
        }
        try {
            if (object3 instanceof BeanProperty) {
                BeanProperty beanProperty = (BeanProperty)object3;
                object2 = beanProperty.getter.invoke(object, ScriptRuntime.emptyArgs);
                clazz = beanProperty.getter.getReturnType();
            } else {
                Field field = (Field)object3;
                object2 = field.get(bl ? null : object);
                clazz = field.getType();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WrappedException(invocationTargetException.getTargetException());
        }
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return NativeJavaObject.wrap(scriptable, object2, clazz);
    }

    Constructor[] getConstructors() {
        return this.ctors;
    }

    Object getExplicitFunction(Scriptable scriptable, String string, Object object, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        NativeFunction nativeFunction = null;
        Member member = this.findExplicitFunction(string, bl);
        if (member != null) {
            Scriptable scriptable2 = ScriptableObject.getFunctionPrototype(scriptable);
            if (member instanceof Constructor) {
                NativeJavaConstructor nativeJavaConstructor = new NativeJavaConstructor((Constructor)member);
                nativeJavaConstructor.setPrototype(scriptable2);
                nativeFunction = nativeJavaConstructor;
                hashtable.put(string, nativeJavaConstructor);
            } else {
                String string2 = member.getName();
                nativeFunction = (NativeFunction)hashtable.get(string2);
                if (nativeFunction instanceof NativeJavaMethod && ((NativeJavaMethod)nativeFunction).getMethods().length > 1) {
                    NativeJavaMethod nativeJavaMethod = new NativeJavaMethod((Method)member, string);
                    nativeJavaMethod.setPrototype(scriptable2);
                    hashtable.put(string, nativeJavaMethod);
                    nativeFunction = nativeJavaMethod;
                }
            }
        }
        return nativeFunction;
    }

    Hashtable getFieldAndMethodsObjects(Scriptable scriptable, Object object, boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            return null;
        }
        int n = hashtable.size();
        Hashtable<String, FieldAndMethods> hashtable3 = new Hashtable<String, FieldAndMethods>(Math.max(n, 1));
        Enumeration enumeration = hashtable.elements();
        while (n-- > 0) {
            FieldAndMethods fieldAndMethods = (FieldAndMethods)enumeration.nextElement();
            fieldAndMethods = (FieldAndMethods)fieldAndMethods.clone();
            fieldAndMethods.setJavaObject(object);
            hashtable3.put(fieldAndMethods.getName(), fieldAndMethods);
        }
        return hashtable3;
    }

    Hashtable getFieldAndMethodsTable(boolean bl) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable = bl ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (hashtable == null) {
            hashtable = new Hashtable(11);
            if (bl) {
                this.staticFieldAndMethods = hashtable;
            } else {
                this.fieldAndMethods = hashtable;
            }
        }
        return hashtable;
    }

    Object[] getIds(boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        int n = hashtable.size();
        Object[] objectArray = new Object[n];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = enumeration.nextElement();
            ++n2;
        }
        return objectArray;
    }

    Class getReflectedClass() {
        return this.cl;
    }

    boolean has(String string, boolean bl) {
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string);
        if (v != null) {
            return true;
        }
        Member member = this.findExplicitFunction(string, bl);
        return member != null;
    }

    static JavaMembers lookupClass(Scriptable scriptable, Class clazz, Class clazz2) {
        Hashtable hashtable = classTable;
        Class clazz3 = clazz;
        JavaMembers javaMembers = (JavaMembers)hashtable.get(clazz3);
        if (javaMembers != null) {
            return javaMembers;
        }
        if (clazz2 != null && clazz2 != clazz && !Modifier.isPublic(clazz.getModifiers()) && Modifier.isPublic(clazz2.getModifiers())) {
            clazz3 = clazz2;
        }
        try {
            javaMembers = new JavaMembers(scriptable, clazz3);
        }
        catch (SecurityException securityException) {
            if (clazz3 != clazz2) {
                javaMembers = new JavaMembers(scriptable, clazz2);
            }
            throw securityException;
        }
        if (Context.isCachingEnabled) {
            hashtable.put(clazz3, javaMembers);
        }
        return javaMembers;
    }

    void makeBeanProperties(Scriptable scriptable, boolean bl) {
        Object object;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Class<?>[] classArray;
            Class<?> clazz;
            NativeJavaMethod nativeJavaMethod;
            Method[] methodArray;
            Object v;
            String string;
            object = (String)enumeration.nextElement();
            boolean bl2 = ((String)object).startsWith("get");
            boolean bl3 = ((String)object).startsWith("is");
            if (!bl2 && !bl3 || (string = ((String)object).substring(bl2 ? 3 : 2)).length() == 0) continue;
            String string2 = string;
            if (string.length() > 1 && Character.isUpperCase(string.charAt(0)) && !Character.isUpperCase(string.charAt(1))) {
                string2 = String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
            }
            if (hashtable.containsKey(string2) || !((v = hashtable.get(object)) instanceof NativeJavaMethod) || (methodArray = (nativeJavaMethod = (NativeJavaMethod)v).getMethods()) == null || methodArray.length != 1 || (clazz = methodArray[0].getReturnType()) == null || (classArray = methodArray[0].getParameterTypes()) == null || classArray.length != 0 || bl && !Modifier.isStatic(methodArray[0].getModifiers())) continue;
            Method method = null;
            String string3 = "set" + string;
            if (hashtable.containsKey(string3) && (v = hashtable.get(string3)) instanceof NativeJavaMethod) {
                object2 = (NativeJavaMethod)v;
                Method[] methodArray2 = ((NativeJavaMethod)object2).getMethods();
                int n = 1;
                while (n <= 2 && method == null) {
                    int n2 = 0;
                    while (n2 < methodArray2.length) {
                        if (methodArray2[n2].getReturnType() == Void.TYPE && (!bl || Modifier.isStatic(methodArray2[n2].getModifiers())) && (classArray = methodArray2[n2].getParameterTypes()) != null && classArray.length == 1 && (n == 1 && classArray[0] == clazz || n == 2 && classArray[0].isAssignableFrom(clazz))) {
                            method = methodArray2[n2];
                            break;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            object2 = new BeanProperty(methodArray[0], method);
            hashtable2.put(string2, object2);
        }
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            Object v = hashtable2.get(string);
            hashtable.put(string, v);
        }
    }

    public void put(String string, Object object, Object object2, boolean bl) {
        Object object3;
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object object4 = hashtable.get(string);
        if (!bl && object4 == null) {
            object4 = this.staticMembers.get(string);
        }
        if (object4 == null) {
            throw this.reportMemberNotFound(string);
        }
        if (object4 instanceof FieldAndMethods) {
            object3 = (FieldAndMethods)hashtable.get(string);
            object4 = ((FieldAndMethods)object3).getField();
        }
        if (object4 instanceof BeanProperty) {
            try {
                object3 = ((BeanProperty)object4).setter;
                if (object3 == null) {
                    throw this.reportMemberNotFound(string);
                }
                Class<?>[] classArray = ((Method)object3).getParameterTypes();
                Object[] objectArray = new Object[]{NativeJavaObject.coerceType(classArray[0], object2)};
                ((Method)object3).invoke(object, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WrappedException(invocationTargetException.getTargetException());
            }
        }
        object3 = null;
        try {
            object3 = (Field)object4;
            if (object3 == null) {
                Object[] objectArray = new Object[]{string};
                throw Context.reportRuntimeError(Context.getMessage("msg.java.internal.private", objectArray));
            }
            ((Field)object3).set(object, NativeJavaObject.coerceType(((Field)object3).getType(), object2));
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw Context.reportRuntimeError(Context.getMessage("msg.java.method.assign", objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("unexpected IllegalAccessException accessing Java field");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{object2.getClass().getName(), object3, object.getClass().getName()};
            throw Context.reportRuntimeError(Context.getMessage("msg.java.internal.field.type", objectArray));
        }
    }

    void reflect(Scriptable scriptable, Class clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this.reflectMethod(scriptable, methodArray[n]);
            ++n;
        }
        Field[] fieldArray = clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            this.reflectField(scriptable, fieldArray[n2]);
            ++n2;
        }
        this.makeBeanProperties(scriptable, false);
        this.makeBeanProperties(scriptable, true);
        this.ctors = clazz.getConstructors();
    }

    void reflectField(Scriptable scriptable, Field field) {
        String string;
        int n = field.getModifiers();
        if (!Modifier.isPublic(n)) {
            return;
        }
        boolean bl = Modifier.isStatic(n);
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        Object v = hashtable.get(string = field.getName());
        if (v != null) {
            if (v instanceof NativeJavaMethod) {
                NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)v;
                FieldAndMethods fieldAndMethods = new FieldAndMethods(nativeJavaMethod.getMethods(), field, null);
                fieldAndMethods.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
                this.getFieldAndMethodsTable(bl).put(string, fieldAndMethods);
                hashtable.put(string, fieldAndMethods);
                return;
            }
            if (v instanceof Field) {
                Field field2 = (Field)v;
                if (field2.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                    hashtable.put(string, field);
                }
                return;
            }
            throw new RuntimeException("unknown member type");
        }
        hashtable.put(string, field);
    }

    void reflectMethod(Scriptable scriptable, Method method) {
        String string;
        int n = method.getModifiers();
        if (!Modifier.isPublic(n)) {
            return;
        }
        boolean bl = Modifier.isStatic(n);
        Hashtable hashtable = bl ? this.staticMembers : this.members;
        NativeJavaMethod nativeJavaMethod = (NativeJavaMethod)hashtable.get(string = method.getName());
        if (nativeJavaMethod == null) {
            nativeJavaMethod = new NativeJavaMethod();
            if (scriptable != null) {
                nativeJavaMethod.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
            }
            hashtable.put(string, nativeJavaMethod);
            nativeJavaMethod.add(method);
        } else {
            nativeJavaMethod.add(method);
        }
    }

    RuntimeException reportMemberNotFound(String string) {
        Object[] objectArray = new Object[]{this.cl.getName(), string};
        return Context.reportRuntimeError(Context.getMessage("msg.java.member.not.found", objectArray));
    }
}

