/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;

public class NativeGlobal {
    private static int URL_XALPHAS = 1;
    private static int URL_XPALPHAS = 2;
    private static int URL_PATH = 4;
    private static String uriReservedPlusPound = ";/?:@&=+$,#";
    private static String uriUnescaped = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'()";
    static /* synthetic */ Class class$org$mozilla$javascript$NativeGlobal;

    public static Object CommonError(Context context, Object[] objectArray, Function function, boolean bl) {
        NativeError nativeError = new NativeError();
        nativeError.setPrototype((Scriptable)function.get("prototype", (Scriptable)function));
        nativeError.setParentScope(context.ctorScope);
        if (objectArray.length > 0) {
            nativeError.put("message", (Scriptable)nativeError, objectArray[0]);
        }
        return nativeError;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static EcmaError constructError(Context context, String string, String string2, Object object) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        return NativeGlobal.constructError(context, string, string2, object, string3, nArray[0], 0, null);
    }

    public static EcmaError constructError(Context context, String string, String string2, Object object, String string3, int n, int n2, String string4) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(classCastException.toString());
        }
        Object[] objectArray = new Object[]{string2};
        try {
            Scriptable scriptable2 = context.newObject(scriptable, string, objectArray);
            return new EcmaError((NativeError)scriptable2, string3, n, n2, string4);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException(propertyException.toString());
        }
        catch (JavaScriptException javaScriptException) {
            throw new RuntimeException(javaScriptException.toString());
        }
        catch (NotAFunctionException notAFunctionException) {
            throw new RuntimeException(notAFunctionException.toString());
        }
    }

    private static String decode(Context context, String string, String string2) {
        int n = 0;
        char[] cArray = new char[6];
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                int n2 = n;
                if (n + 2 >= string.length()) {
                    throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                }
                if (!NativeGlobal.isHex(string.charAt(n + 1)) || !NativeGlobal.isHex(string.charAt(n + 2))) {
                    throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                }
                int n3 = NativeGlobal.unHex(string.charAt(n + 1)) * 16 + NativeGlobal.unHex(string.charAt(n + 2));
                n += 2;
                if ((n3 & 0x80) == 0) {
                    c = (char)n3;
                } else {
                    int n4 = 1;
                    while ((n3 & 128 >>> n4) != 0) {
                        ++n4;
                    }
                    if (n4 == 1 || n4 > 6) {
                        throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                    }
                    cArray[0] = (char)n3;
                    if (n + 3 * (n4 - 1) >= string.length()) {
                        throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                    }
                    int n5 = 1;
                    while (n5 < n4) {
                        if (string.charAt(++n) != '%') {
                            throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                        }
                        if (!NativeGlobal.isHex(string.charAt(n + 1)) || !NativeGlobal.isHex(string.charAt(n + 2))) {
                            throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                        }
                        n3 = NativeGlobal.unHex(string.charAt(n + 1)) * 16 + NativeGlobal.unHex(string.charAt(n + 2));
                        if ((n3 & 0xC0) != 128) {
                            throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                        }
                        n += 2;
                        cArray[n5] = (char)n3;
                        ++n5;
                    }
                    int n6 = NativeGlobal.utf8ToOneUcs4Char(cArray, n4);
                    if (n6 >= 65536) {
                        if ((n6 -= 65536) > 1048575) {
                            throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                        }
                        c = (char)((n6 & 0x3FF) + 56320);
                        char c2 = (char)((n6 >>> 10) + 55296);
                        stringBuffer.append(c2);
                    } else {
                        c = (char)n6;
                    }
                }
                if (string2.indexOf(c) != -1) {
                    int n7 = 0;
                    while (n7 < n - n2 + 1) {
                        stringBuffer.append(string.charAt(n2 + n7));
                        ++n7;
                    }
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String decodeURI(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(objectArray[0]);
        return NativeGlobal.decode(context, string, uriReservedPlusPound);
    }

    public static String decodeURIComponent(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(objectArray[0]);
        return NativeGlobal.decode(context, string, "");
    }

    private static String encode(Context context, String string, String string2) {
        int n = 0;
        char[] cArray = new char[6];
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (string2.indexOf(n2) != -1) {
                stringBuffer.append((char)n2);
            } else {
                int n3;
                if (n2 >= 56320 && n2 <= 57343) {
                    throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                }
                if (n2 < 55296 || n2 > 56319) {
                    n3 = n2;
                } else {
                    if (++n == string.length()) {
                        throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                    }
                    char c = string.charAt(n);
                    if (c < '\udc00' || c > '\udfff') {
                        throw Context.reportRuntimeError(Context.getMessage("msg.bad.uri", null));
                    }
                    n3 = (n2 - 55296 << 10) + (c - 56320) + 65536;
                }
                int n4 = NativeGlobal.oneUcs4ToUtf8Char(cArray, n3);
                int n5 = 0;
                while (n5 < n4) {
                    stringBuffer.append('%');
                    if (cArray[n5] < '\u0010') {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toHexString(cArray[n5]));
                    ++n5;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Object encodeURI(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(objectArray[0]);
        return NativeGlobal.encode(context, string, String.valueOf(uriReservedPlusPound) + uriUnescaped);
    }

    public static String encodeURIComponent(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(objectArray[0]);
        return NativeGlobal.encode(context, string, uriUnescaped);
    }

    public static Object escape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = URL_XALPHAS | URL_XPALPHAS | URL_PATH;
        if (objectArray.length > 1 && ((d = ScriptRuntime.toNumber(objectArray[1])) != d || (double)(n = (int)d) != d || (n & ~(URL_XALPHAS | URL_XPALPHAS | URL_PATH)) != 0)) {
            String string2 = Context.getMessage("msg.bad.esc.mask", null);
            Context.reportError(string2);
            n = URL_XALPHAS | URL_XPALPHAS | URL_PATH;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (n != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || (c == '/' || c == '+') && n > 3)) {
                stringBuffer.append(c);
            } else if (c < '\u0100') {
                if (c == ' ' && n == URL_XPALPHAS) {
                    stringBuffer.append('+');
                } else {
                    stringBuffer.append('%');
                    stringBuffer.append(cArray[c >> 4]);
                    stringBuffer.append(cArray[c & 0xF]);
                }
            } else {
                stringBuffer.append('%');
                stringBuffer.append('u');
                stringBuffer.append(cArray[c >> 12]);
                stringBuffer.append(cArray[(c & 0xF00) >> 8]);
                stringBuffer.append(cArray[(c & 0xF0) >> 4]);
                stringBuffer.append(cArray[c & 0xF]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static Object eval(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2 = new Object[]{"eval"};
        String string = ScriptRuntime.getMessage("msg.cant.call.indirect", objectArray2);
        throw NativeGlobal.constructError(context, "EvalError", string, function);
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) throws JavaScriptException {
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object2 = objectArray[0];
        if (!(object2 instanceof String)) {
            String string2 = Context.getMessage("msg.eval.nonstring", null);
            Context.reportWarning(string2);
            return object2;
        }
        int[] nArray = new int[]{n};
        if (string == null && (string = Context.getSourcePositionFromStack(nArray)) == null) {
            string = "<eval'ed string>";
            nArray[0] = 1;
        }
        try {
            StringReader stringReader = new StringReader((String)object2);
            Object object3 = context.getSecurityDomainForStackDepth(3);
            int n2 = context.getOptimizationLevel();
            context.setOptimizationLevel(-1);
            Script script = context.compileReader(scriptable, stringReader, string, nArray[0], object3);
            context.setOptimizationLevel(n2);
            if (script == null) {
                String string3 = Context.getMessage("msg.syntax", null);
                throw new EvaluatorException(string3);
            }
            InterpretedScript interpretedScript = (InterpretedScript)script;
            interpretedScript.itsData.itsFromEvalCode = true;
            Object object4 = interpretedScript.call(context, scriptable, (Scriptable)object, null);
            return object4;
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public static void init(Scriptable scriptable) throws PropertyException, NotAFunctionException, JavaScriptException {
        String[] stringArray = new String[]{"eval", "parseInt", "parseFloat", "escape", "unescape", "isNaN", "isFinite", "decodeURI", "decodeURIComponent", "encodeURI", "encodeURIComponent"};
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineFunctionProperties(stringArray, class$org$mozilla$javascript$NativeGlobal != null ? class$org$mozilla$javascript$NativeGlobal : (class$org$mozilla$javascript$NativeGlobal = NativeGlobal.class$("org.mozilla.javascript.NativeGlobal")), 2);
        scriptableObject.defineProperty("NaN", ScriptRuntime.NaNobj, 2);
        scriptableObject.defineProperty("Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        scriptableObject.defineProperty("undefined", Undefined.instance, 2);
        String[] stringArray2 = new String[]{"ConversionError", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"};
        Method[] methodArray = FunctionObject.findMethods(class$org$mozilla$javascript$NativeGlobal != null ? class$org$mozilla$javascript$NativeGlobal : (class$org$mozilla$javascript$NativeGlobal = NativeGlobal.class$("org.mozilla.javascript.NativeGlobal")), "CommonError");
        Context context = Context.getContext();
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            FunctionObject functionObject = new FunctionObject(string, methodArray[0], scriptableObject);
            scriptableObject.defineProperty(string, functionObject, 2);
            Scriptable scriptable2 = context.newObject(scriptable, "Error");
            scriptable2.put("name", scriptable2, (Object)string);
            functionObject.put("prototype", (Scriptable)functionObject, (Object)scriptable2);
            ++n;
        }
    }

    public static Object isFinite(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.FALSE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        return d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Boolean.FALSE : Boolean.TRUE;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static Object isNaN(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return Boolean.TRUE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        return d != d ? Boolean.TRUE : Boolean.FALSE;
    }

    private static int oneUcs4ToUtf8Char(char[] cArray, int n) {
        int n2 = 1;
        if (n < 128 && n >= 0) {
            cArray[0] = (char)n;
        } else {
            int n3 = n >>> 11;
            n2 = 2;
            while (n3 != 0) {
                n3 >>>= 5;
                ++n2;
            }
            int n4 = n2;
            while (--n4 > 0) {
                cArray[n4] = (char)(n & 0x3F | 0x80);
                n >>>= 6;
            }
            cArray[0] = (char)(256 - (1 << 8 - n2) + n);
        }
        return n2;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parseFloat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        char c;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = string.length();
        if (n == 0) {
            return ScriptRuntime.NaNobj;
        }
        int n2 = 0;
        while (TokenStream.isJSSpace(c = string.charAt(n2)) && n2 + 1 < n) {
            ++n2;
        }
        int n3 = n2;
        if (c == '+' || c == '-') {
            c = string.charAt(++n2);
        }
        if (c == 'I') {
            if (n2 + 8 > n) return ScriptRuntime.NaNobj;
            if (!string.substring(n2, n2 + 8).equals("Infinity")) return ScriptRuntime.NaNobj;
            double d = string.charAt(n3) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d);
        }
        int n4 = -1;
        int n5 = -1;
        block9: while (n2 < n) {
            char c2 = '\u0000';
            block10: do {
                switch (c2 == '\u0000' ? string.charAt(n2) : c2) {
                    case '.': {
                        if (n4 != -1) break block9;
                        n4 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case 'E': 
                    case 'e': {
                        if (n5 != -1) break block9;
                        n5 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case '+': 
                    case '-': {
                        if (n5 != n2 - 1) break block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++n2;
                        continue block9;
                    }
                }
                break block9;
            } while (true);
        }
        string = string.substring(n3, n2);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return ScriptRuntime.NaNobj;
        }
    }

    public static Object parseInt(String string, int n) {
        char c;
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n3 = 0;
        while (Character.isWhitespace(c = string.charAt(n3)) && ++n3 < n2) {
        }
        if (c == '+' || (bl = c == '-')) {
            ++n3;
        }
        int n4 = -1;
        if (n == 0) {
            n = -1;
        } else {
            if (n < 2 || n > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n == 16 && n2 - n3 > 1 && string.charAt(n3) == '0' && ((c = string.charAt(n3 + 1)) == 'x' || c == 'X')) {
                n3 += 2;
            }
        }
        if (n == -1) {
            n = 10;
            if (n2 - n3 > 1 && string.charAt(n3) == '0') {
                c = string.charAt(n3 + 1);
                if (c == 'x' || c == 'X') {
                    n = 16;
                    n3 += 2;
                } else if (c != '.') {
                    n = 8;
                    ++n3;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(string, n3, n);
        return new Double(bl ? -d : d);
    }

    private static int unHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    public static Object unescape(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            block10: {
                char c = string.charAt(n);
                if (c != '%' || n == string.length() - 1) {
                    stringBuffer.append(c);
                } else {
                    int n2;
                    int n3;
                    if (string.charAt(n + 1) == 'u') {
                        n3 = n + 2;
                        n2 = n + 6;
                    } else {
                        n3 = n + 1;
                        n2 = n + 3;
                    }
                    if (n2 > string.length()) {
                        stringBuffer.append('%');
                    } else {
                        String string2 = string.substring(n3, n2);
                        int n4 = 0;
                        while (n4 < string2.length()) {
                            if (!TokenStream.isXDigit(string2.charAt(n4))) {
                                stringBuffer.append('%');
                                break block10;
                            }
                            ++n4;
                        }
                        n = n2 - 1;
                        stringBuffer.append(new Character((char)Integer.valueOf(string2, 16).intValue()));
                    }
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int utf8ToOneUcs4Char(char[] cArray, int n) {
        int n2;
        int n3 = 0;
        if (n == 1) {
            n2 = cArray[0];
        } else {
            n2 = cArray[n3++] & (1 << 7 - n) - 1;
            while (--n > 0) {
                n2 = n2 << 6 | cArray[n3++] & 0x3F;
            }
        }
        return n2;
    }
}

