/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeString
extends ScriptableObject
implements Wrapper {
    private static final String defaultValue = "";
    private String string;

    public NativeString() {
        this.string = defaultValue;
    }

    public NativeString(String string) {
        this.string = string;
    }

    private static RegExpProxy checkReProxy(Context context) {
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError(Context.getMessage("msg.no.regexp", null));
        }
        return regExpProxy;
    }

    /*
     * Unable to fully structure code
     */
    private static int find_split(Function var0, String var1_1, String var2_2, Object var3_3, int[] var4_4, int[] var5_5, boolean[] var6_6, String[][] var7_7) {
        block11: {
            var8_8 = var4_4[0];
            var9_9 = var1_1.length();
            var10_10 = Context.getContext();
            var11_11 = var10_10.getLanguageVersion();
            if (var11_11 != 120 || var3_3 != null || var2_2.length() != 1 || var2_2.charAt(0) != ' ') break block11;
            if (var8_8 == 0) {
                while (var8_8 < var9_9 && Character.isWhitespace(var1_1.charAt(var8_8))) {
                    ++var8_8;
                }
                var4_4[0] = var8_8;
            }
            if (var8_8 != var9_9) ** GOTO lbl14
            return -1;
lbl-1000:
            // 1 sources

            {
                ++var8_8;
lbl14:
                // 2 sources

                ** while (var8_8 < var9_9 && !Character.isWhitespace((char)var1_1.charAt((int)var8_8)))
            }
lbl15:
            // 1 sources

            var12_12 = var8_8;
            while (var12_12 < var9_9 && Character.isWhitespace(var1_1.charAt(var12_12))) {
                ++var12_12;
            }
            var5_5[0] = var12_12 - var8_8;
            return var8_8;
        }
        if (var8_8 > var9_9) {
            return -1;
        }
        if (var3_3 != null) {
            return var10_10.getRegExpProxy().find_split(var0, var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
        }
        if (var11_11 != 0 && var11_11 < 130 && var9_9 == 0) {
            return -1;
        }
        if (var2_2.length() == 0) {
            if (var11_11 == 120) {
                if (var8_8 == var9_9) {
                    var5_5[0] = 1;
                    return var8_8;
                }
                return var8_8 + 1;
            }
            return var8_8 == var9_9 ? -1 : var8_8 + 1;
        }
        if (var4_4[0] >= var9_9) {
            return var9_9;
        }
        var8_8 = var1_1.indexOf(var2_2, var4_4[0]);
        return var8_8 != -1 ? var8_8 : var9_9;
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        String[] stringArray = new String[]{"indexOf", "lastIndexOf", "substring", "toUpperCase", "toLowerCase", "toString"};
        short[] sArray = new short[6];
        sArray[0] = 2;
        sArray[1] = 2;
        sArray[2] = 2;
        short[] sArray2 = sArray;
        int n = 0;
        while (n < stringArray.length) {
            Object object = scriptable2.get(stringArray[n], scriptable2);
            ((FunctionObject)object).setLength(sArray2[n]);
            ++n;
        }
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.string.length()) {
            return this.string.substring(n, n + 1);
        }
        return super.get(n, scriptable);
    }

    public String getClassName() {
        return "String";
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        String string;
        String string2 = string = objectArray.length >= 1 ? ScriptRuntime.toString(objectArray[0]) : defaultValue;
        if (bl) {
            return new NativeString(string);
        }
        return string;
    }

    public String jsFunction_anchor(String string) {
        return this.tagify("A NAME", "A", string);
    }

    public String jsFunction_big() {
        return this.tagify("BIG", null, null);
    }

    public String jsFunction_blink() {
        return this.tagify("BLINK", null, null);
    }

    public String jsFunction_bold() {
        return this.tagify("B", null, null);
    }

    public static String jsFunction_charAt(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        double d = ScriptRuntime.toInteger(objectArray[0]);
        if (d < 0.0 || d >= (double)string.length()) {
            return defaultValue;
        }
        return string.substring((int)d, (int)d + 1);
    }

    public static double jsFunction_charCodeAt(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        double d = ScriptRuntime.toInteger(objectArray[0]);
        if (d < 0.0 || d >= (double)string.length()) {
            return ScriptRuntime.NaN;
        }
        return string.charAt((int)d);
    }

    public static String jsFunction_concat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ScriptRuntime.toString(scriptable));
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(ScriptRuntime.toString(objectArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Object jsFunction_equals(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        return new Boolean(string.equals(string2));
    }

    public static Object jsFunction_equalsIgnoreCase(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        return new Boolean(string.equalsIgnoreCase(string2));
    }

    public String jsFunction_fixed() {
        return this.tagify("TT", null, null);
    }

    public String jsFunction_fontcolor(String string) {
        return this.tagify("FONT COLOR", "FONT", string);
    }

    public String jsFunction_fontsize(String string) {
        return this.tagify("FONT SIZE", "FONT", string);
    }

    public static int jsFunction_indexOf(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 2) {
            objectArray = ScriptRuntime.padArguments(objectArray, 2);
        }
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        double d = ScriptRuntime.toInteger(objectArray[1]);
        if (d > (double)string.length()) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return string.indexOf(string2, (int)d);
    }

    public String jsFunction_italics() {
        return this.tagify("I", null, null);
    }

    public static int jsFunction_lastIndexOf(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 2) {
            objectArray = ScriptRuntime.padArguments(objectArray, 2);
        }
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        double d = ScriptRuntime.toNumber(objectArray[1]);
        if (d != d || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    public String jsFunction_link(String string) {
        return this.tagify("A HREF", "A", string);
    }

    public static Object jsFunction_match(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.checkReProxy(context).match(context, scriptable, objectArray, function);
    }

    public static Object jsFunction_replace(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.checkReProxy(context).replace(context, scriptable, objectArray, function);
    }

    public static Object jsFunction_search(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.checkReProxy(context).search(context, scriptable, objectArray, function);
    }

    public static String jsFunction_slice(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        if (objectArray.length != 0) {
            double d;
            double d2 = ScriptRuntime.toInteger(objectArray[0]);
            int n = string.length();
            if (d2 < 0.0) {
                if ((d2 += (double)n) < 0.0) {
                    d2 = 0.0;
                }
            } else if (d2 > (double)n) {
                d2 = n;
            }
            if (objectArray.length == 1) {
                d = n;
            } else {
                d = ScriptRuntime.toInteger(objectArray[1]);
                if (d < 0.0) {
                    if ((d += (double)n) < 0.0) {
                        d = 0.0;
                    }
                } else if (d > (double)n) {
                    d = n;
                }
                if (d < d2) {
                    d = d2;
                }
            }
            return string.substring((int)d2, (int)d);
        }
        return string;
    }

    public String jsFunction_small() {
        return this.tagify("SMALL", null, null);
    }

    public static Object jsFunction_split(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n;
        String string = ScriptRuntime.toString(scriptable);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        if (objectArray.length < 1) {
            scriptable3.put(0, scriptable3, (Object)string);
            return scriptable3;
        }
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l = 0L;
        if (bl && (l = ScriptRuntime.toUint32(objectArray[1])) > (long)string.length()) {
            l = 1 + string.length();
        }
        String string2 = null;
        int[] nArray = new int[1];
        Object object = null;
        RegExpProxy regExpProxy = context.getRegExpProxy();
        if (regExpProxy != null && regExpProxy.isRegExp(objectArray[0])) {
            object = objectArray[0];
        } else {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        int[] nArray2 = new int[1];
        int n2 = 0;
        boolean[] blArray = new boolean[1];
        String[][] stringArray = new String[][]{null};
        while ((n = NativeString.find_split(function, string, string2, object, nArray2, nArray, blArray, stringArray)) >= 0) {
            if (bl && (long)n2 >= l || n > string.length()) break;
            String string3 = string.length() == 0 ? string : string.substring(nArray2[0], n);
            scriptable3.put(n2, scriptable3, (Object)string3);
            ++n2;
            if (object != null && blArray[0]) {
                int n3 = stringArray[0].length;
                int n4 = 0;
                while (n4 < n3) {
                    if (bl && (long)n2 >= l) break;
                    scriptable3.put(n2, scriptable3, (Object)stringArray[0][n4]);
                    ++n2;
                    ++n4;
                }
                blArray[0] = false;
            }
            nArray2[0] = n + nArray[0];
            if (context.getLanguageVersion() < 130 && context.getLanguageVersion() != 0 && !bl && nArray2[0] == string.length()) break;
        }
        return scriptable3;
    }

    public String jsFunction_strike() {
        return this.tagify("STRIKE", null, null);
    }

    public String jsFunction_sub() {
        return this.tagify("SUB", null, null);
    }

    public static String jsFunction_substr(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        String string = ScriptRuntime.toString(scriptable);
        if (objectArray.length < 1) {
            return string;
        }
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        int n = string.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            }
            if ((d += d2) > (double)n) {
                d = n;
            }
        }
        return string.substring((int)d2, (int)d);
    }

    public static String jsFunction_substring(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d;
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        int n = string.length();
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length == 1) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return string.substring((int)d2, (int)d);
    }

    public String jsFunction_sup() {
        return this.tagify("SUP", null, null);
    }

    public static String jsFunction_toLowerCase(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        return string.toLowerCase();
    }

    public String jsFunction_toString() {
        return this.string;
    }

    public static String jsFunction_toUpperCase(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        return string.toUpperCase();
    }

    public String jsFunction_valueOf() {
        return this.string;
    }

    public double jsGet_length() {
        return this.string.length();
    }

    public static String jsStaticFunction_fromCharCode(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return defaultValue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(ScriptRuntime.toUint16(objectArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    private String tagify(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string);
        if (string3 != null) {
            stringBuffer.append('=');
            stringBuffer.append(string3);
        }
        stringBuffer.append('>');
        stringBuffer.append(this.string);
        stringBuffer.append("</");
        stringBuffer.append(string2 == null ? string : string2);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.string;
    }

    public Object unwrap() {
        return this.string;
    }
}

