/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.RegExpImpl;
import org.mozilla.javascript.regexp.SubString;

public class NativeRegExpCtor
extends NativeFunction {
    static /* synthetic */ Class class$org$mozilla$javascript$regexp$NativeRegExpCtor;

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return this.construct(context, this.parent, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        NativeRegExp nativeRegExp = new NativeRegExp();
        NativeRegExp.compile(context, nativeRegExp, objectArray, this);
        nativeRegExp.setPrototype(ScriptableObject.getClassPrototype(scriptable, "RegExp"));
        nativeRegExp.setParentScope(this.getParentScope());
        return nativeRegExp;
    }

    public Object get(String string, Scriptable scriptable) {
        int n;
        if (string.length() > 1 && string.charAt(0) == '$' && (n = this.getDollarNumber(string)) != 0) {
            RegExpImpl regExpImpl = NativeRegExpCtor.getImpl();
            return regExpImpl.getParenSubString(--n).toString();
        }
        return super.get(string, scriptable);
    }

    public String getClassName() {
        return "Function";
    }

    private int getDollarNumber(String string) {
        if (string.length() != 2) {
            return 0;
        }
        char c = string.charAt(1);
        if (c < '0' || c > '9') {
            return 0;
        }
        return c - 48;
    }

    static RegExpImpl getImpl() {
        Context context = Context.getCurrentContext();
        return (RegExpImpl)ScriptRuntime.getRegExpProxy(context);
    }

    public static String getInput(ScriptableObject scriptableObject) {
        String string = NativeRegExpCtor.getImpl().input;
        return string == null ? "" : string;
    }

    public static String getLastMatch(ScriptableObject scriptableObject) {
        SubString subString = NativeRegExpCtor.getImpl().lastMatch;
        return subString == null ? "" : subString.toString();
    }

    public static String getLastParen(ScriptableObject scriptableObject) {
        SubString subString = NativeRegExpCtor.getImpl().lastParen;
        return subString == null ? "" : subString.toString();
    }

    public static String getLeftContext(ScriptableObject scriptableObject) {
        SubString subString = NativeRegExpCtor.getImpl().leftContext;
        return subString == null ? "" : subString.toString();
    }

    public static boolean getMultiline(ScriptableObject scriptableObject) {
        return NativeRegExpCtor.getImpl().multiline;
    }

    public static String getRightContext(ScriptableObject scriptableObject) {
        SubString subString = NativeRegExpCtor.getImpl().rightContext;
        return subString == null ? "" : subString.toString();
    }

    public boolean has(String string, Scriptable scriptable) {
        if (string != null && string.length() > 1 && string.charAt(0) == '$' && this.getDollarNumber(string) != 0) {
            return true;
        }
        return super.has(string, scriptable);
    }

    public static Scriptable init(Scriptable scriptable) throws PropertyException {
        Object object;
        NativeRegExpCtor nativeRegExpCtor = new NativeRegExpCtor();
        String[] stringArray = new String[]{"RegExp"};
        nativeRegExpCtor.names = stringArray;
        nativeRegExpCtor.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Function"));
        nativeRegExpCtor.setParentScope(scriptable);
        String[] stringArray2 = new String[]{"multiline", "input", "lastMatch", "lastParen", "leftContext", "rightContext"};
        String[] stringArray3 = new String[]{"$*", "$_", "$&", "$+", "$`", "$'"};
        int n = 0;
        while (n < stringArray2.length) {
            nativeRegExpCtor.defineProperty(stringArray2[n], class$org$mozilla$javascript$regexp$NativeRegExpCtor != null ? class$org$mozilla$javascript$regexp$NativeRegExpCtor : NativeRegExpCtor.class$("org.mozilla.javascript.regexp.NativeRegExpCtor"), 2);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray3.length) {
            object = new StringBuffer("get");
            ((StringBuffer)object).append(stringArray2[n2]);
            ((StringBuffer)object).setCharAt(3, Character.toUpperCase(stringArray2[n2].charAt(0)));
            Method[] methodArray = FunctionObject.findMethods(class$org$mozilla$javascript$regexp$NativeRegExpCtor != null ? class$org$mozilla$javascript$regexp$NativeRegExpCtor : NativeRegExpCtor.class$("org.mozilla.javascript.regexp.NativeRegExpCtor"), ((StringBuffer)object).toString());
            ((StringBuffer)object).setCharAt(0, 's');
            Method[] methodArray2 = FunctionObject.findMethods(class$org$mozilla$javascript$regexp$NativeRegExpCtor != null ? class$org$mozilla$javascript$regexp$NativeRegExpCtor : NativeRegExpCtor.class$("org.mozilla.javascript.regexp.NativeRegExpCtor"), ((StringBuffer)object).toString());
            Method method = methodArray2 == null ? null : methodArray2[0];
            nativeRegExpCtor.defineProperty(stringArray3[n2], null, methodArray[0], method, 2);
            ++n2;
        }
        object = (ScriptableObject)scriptable;
        ((ScriptableObject)object).defineProperty("RegExp", nativeRegExpCtor, 2);
        return nativeRegExpCtor;
    }

    public static void setInput(ScriptableObject scriptableObject, String string) {
        NativeRegExpCtor.getImpl().input = string;
    }

    public static void setMultiline(ScriptableObject scriptableObject, boolean bl) {
        NativeRegExpCtor.getImpl().multiline = bl;
    }
}

