/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SourceTextManager;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.DebugReader;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Global;

public class Main {
    protected static ToolErrorReporter errorReporter;
    protected static Global global;
    public static InputStream inStream;
    public static PrintStream outStream;
    public static PrintStream errStream;
    private static final int EXITCODE_RUNTIME_ERROR = 3;
    private static final int EXITCODE_FILE_NOT_FOUND = 4;
    SourceTextManager debug_stm;

    private static Object evaluateReader(Context context, Scriptable scriptable, Reader reader, String string, int n) {
        Object object = Context.getUndefinedValue();
        try {
            try {
                object = context.evaluateReader(scriptable, reader, string, n, null);
            }
            catch (WrappedException wrappedException) {
                Main.getErr().println(wrappedException.getWrappedException().toString());
                wrappedException.printStackTrace();
            }
            catch (EcmaError ecmaError) {
                String string2 = ToolErrorReporter.getMessage("msg.uncaughtJSException", ecmaError.toString());
                Main.global.exitCode = 3;
                if (ecmaError.getSourceName() != null) {
                    Context.reportError(string2, ecmaError.getSourceName(), ecmaError.getLineNumber(), ecmaError.getLineSource(), ecmaError.getColumnNumber());
                } else {
                    Context.reportError(string2);
                }
            }
            catch (EvaluatorException evaluatorException) {
                Main.global.exitCode = 3;
            }
            catch (JavaScriptException javaScriptException) {
                Object object2 = javaScriptException.getValue();
                if (object2 instanceof ThreadDeath) {
                    throw (ThreadDeath)object2;
                }
                Main.global.exitCode = 3;
                Context.reportError(ToolErrorReporter.getMessage("msg.uncaughtJSException", javaScriptException.getMessage()));
            }
            catch (IOException iOException) {
                Main.getErr().println(iOException.toString());
            }
            Object var7_14 = null;
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                Main.getErr().println(iOException.toString());
            }
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            Main.getErr().println(iOException.toString());
        }
        return object;
    }

    public static int exec(String[] stringArray) {
        Context context = Context.enter();
        errorReporter = new ToolErrorReporter(false, Main.getErr());
        context.setErrorReporter(errorReporter);
        global = new Global();
        stringArray = Main.processOptions(context, stringArray);
        Object[] objectArray = stringArray;
        if (stringArray.length > 0) {
            int n = stringArray.length - 1;
            objectArray = new Object[n];
            System.arraycopy(stringArray, 1, objectArray, 0, n);
        }
        Scriptable scriptable = context.newArray((Scriptable)global, objectArray);
        global.defineProperty("arguments", scriptable, 2);
        Environment.defineClass(global);
        Environment environment = new Environment(global);
        global.defineProperty("environment", environment, 2);
        Main.global.history = (NativeArray)context.newArray((Scriptable)global, 0);
        global.defineProperty("history", Main.global.history, 2);
        if (Main.global.processStdin) {
            Main.processSource(context, stringArray.length == 0 ? null : stringArray[0]);
        }
        Context.exit();
        return Main.global.exitCode;
    }

    public static PrintStream getErr() {
        return errStream == null ? System.err : errStream;
    }

    public static InputStream getIn() {
        return inStream == null ? System.in : inStream;
    }

    public static PrintStream getOut() {
        return outStream == null ? System.out : outStream;
    }

    public static void main(String[] stringArray) {
        int n = Main.exec(stringArray);
        System.exit(n);
    }

    private static void p(String string) {
        Main.getOut().println(string);
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        context.setTargetPackage("");
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (!string.startsWith("-")) {
                String[] stringArray2 = new String[stringArray.length - n];
                int n2 = n;
                while (n2 < stringArray.length) {
                    stringArray2[n2 - n] = stringArray[n2];
                    ++n2;
                }
                return stringArray2;
            }
            if (string.equals("-version")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setLanguageVersion((int)d);
            } else if (string.equals("-opt") || string.equals("-O")) {
                double d;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if ((d = Context.toNumber(stringArray[n])) != d) {
                    Main.usage(string);
                }
                context.setOptimizationLevel((int)d);
            } else if (string.equals("-e")) {
                Main.global.processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                StringReader stringReader = new StringReader(stringArray[n]);
                Main.evaluateReader(context, global, stringReader, "<command>", 1);
            } else if (string.equals("-w")) {
                errorReporter.setIsReportingWarnings(true);
            } else if (string.equals("-f")) {
                Main.global.processStdin = false;
                if (++n == stringArray.length) {
                    Main.usage(string);
                }
                if (stringArray[n].equals("-")) {
                    Main.global.processStdin = false;
                }
                Main.processSource(context, stringArray[n]);
            } else {
                Main.usage(string);
            }
            ++n;
        }
        return new String[0];
    }

    public static void processSource(Context context, String string) {
        SourceTextManager sourceTextManager = context.getSourceTextManager();
        if (string == null || string.equals("-")) {
            context.setOptimizationLevel(-1);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Main.getIn()));
            if (sourceTextManager != null) {
                bufferedReader = new DebugReader(bufferedReader, sourceTextManager, "<stdin>");
            }
            int n = 1;
            boolean bl = false;
            while (!bl && !Main.global.quitting) {
                Object object;
                int n2 = n;
                if (string == null) {
                    Main.getErr().print("js> ");
                }
                Main.getErr().flush();
                String string2 = "";
                do {
                    try {
                        object = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        Main.getErr().println(iOException.toString());
                        break;
                    }
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    string2 = String.valueOf(string2) + (String)object + "\n";
                    ++n;
                } while (!context.stringIsCompilableUnit(string2));
                object = new StringReader(string2);
                Object object2 = Main.evaluateReader(context, global, (Reader)object, "<stdin>", n2);
                if (object2 != Context.getUndefinedValue()) {
                    Main.getErr().println(Context.toString(object2));
                }
                NativeArray nativeArray = Main.global.history;
                nativeArray.put((int)nativeArray.jsGet_length(), (Scriptable)nativeArray, (Object)string2);
                if (Main.global.quitting) break;
            }
            Main.getErr().println();
        } else {
            Reader reader = null;
            try {
                reader = new PushbackReader(new FileReader(string));
                int n = reader.read();
                if (n == 35) {
                    while ((n = reader.read()) != -1) {
                        if (n == 10 || n == 13) break;
                    }
                    ((PushbackReader)reader).unread(n);
                } else {
                    reader.close();
                    reader = new FileReader(string);
                }
                if (sourceTextManager != null) {
                    reader = new DebugReader(reader, sourceTextManager, string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                Main.global.exitCode = 4;
                return;
            }
            catch (IOException iOException) {
                Main.getErr().println(iOException.toString());
            }
            Main.evaluateReader(context, global, reader, string, 1);
        }
        System.gc();
    }

    public static void setErr(PrintStream printStream) {
        errStream = printStream;
    }

    public static void setIn(InputStream inputStream) {
        inStream = inputStream;
    }

    public static void setOut(PrintStream printStream) {
        outStream = printStream;
    }

    public static void usage(String string) {
        Main.p(ToolErrorReporter.getMessage("msg.shell.usage", string));
        System.exit(1);
    }
}

