/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.https;

import java.io.IOException;
import java.io.InputStream;
import sun.plugin.protocol.https.BrowserHttpsURLConnection;

public class BrowserHttpsInputStream
extends InputStream {
    BrowserHttpsURLConnection urlConnection;
    long seekPos;
    long nativeConnection;
    boolean open;
    private byte[] temp = new byte[1];

    public BrowserHttpsInputStream(BrowserHttpsURLConnection browserHttpsURLConnection) throws IOException {
        this.urlConnection = browserHttpsURLConnection;
        this.openStream();
        this.open = true;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (0L == this.nativeConnection) {
            return -1;
        }
        int n = this.readStream(this.temp, 0, 1);
        if (1 == n) {
            ++this.seekPos;
            return this.temp[0] & 0xFF;
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (0L == this.nativeConnection) {
            return -1;
        }
        int n3 = this.readStream(byArray, n, n2);
        if (n3 > 0) {
            this.seekPos += (long)n3;
        }
        return n3 > 0 ? n3 : -1;
    }

    public long skip(long l) throws IOException {
        BrowserHttpsInputStream browserHttpsInputStream = this;
        synchronized (browserHttpsInputStream) {
            this.ensureOpen();
        }
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        int n = (int)Math.min(1024L, l2);
        byte[] byArray = new byte[n];
        while (l2 > 0L) {
            int n2 = this.read(byArray, 0, (int)Math.min((long)n, l2));
            if (n2 < 0) break;
            l2 -= (long)n2;
        }
        BrowserHttpsInputStream browserHttpsInputStream2 = this;
        synchronized (browserHttpsInputStream2) {
            this.seekPos += l - l2;
        }
        return l - l2;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return 0L == this.nativeConnection ? 0 : this.bytesAvailable();
    }

    public synchronized void close() throws IOException {
        if (this.open) {
            this.closeStream();
            this.open = false;
        }
    }

    private void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private native void openStream() throws IOException;

    private native int readStream(byte[] var1, int var2, int var3) throws IOException;

    private native int bytesAvailable() throws IOException;

    private native void closeStream() throws IOException;
}

