/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class URLName {
    protected String fullURL;
    private String protocol;
    private String username;
    private String password;
    private String host;
    private InetAddress hostAddress;
    private boolean hostAddressKnown = false;
    private int port = -1;
    private String file;
    private String ref;
    private int hashCode;

    public URLName(String string, String string2, int n, String string3, String string4, String string5) {
        int n2;
        this.protocol = string;
        this.host = string2;
        this.port = n;
        if (string3 != null && (n2 = string3.indexOf(35)) != -1) {
            this.file = string3.substring(0, n2);
            this.ref = string3.substring(n2 + 1);
        } else {
            this.file = string3;
            this.ref = null;
        }
        this.username = string4;
        this.password = string5;
    }

    public URLName(URL uRL) {
        this(uRL.toString());
    }

    public URLName(String string) {
        this.parseString(string);
    }

    public String toString() {
        if (this.fullURL == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.protocol != null) {
                stringBuffer.append(this.protocol);
                stringBuffer.append(":");
            }
            if (this.username != null || this.host != null) {
                stringBuffer.append("//");
                if (this.username != null) {
                    stringBuffer.append(this.username);
                    if (this.password != null) {
                        stringBuffer.append(":");
                        stringBuffer.append(this.password);
                    }
                    stringBuffer.append("@");
                }
                if (this.host != null) {
                    stringBuffer.append(this.host);
                }
                if (this.port != -1) {
                    stringBuffer.append(":");
                    stringBuffer.append(Integer.toString(this.port));
                }
                if (this.file != null) {
                    stringBuffer.append("/");
                }
            }
            if (this.file != null) {
                stringBuffer.append(this.file);
            }
            if (this.ref != null) {
                stringBuffer.append("#");
                stringBuffer.append(this.ref);
            }
            this.fullURL = stringBuffer.toString();
        }
        return this.fullURL;
    }

    protected void parseString(String string) {
        int n;
        this.password = null;
        this.username = null;
        this.host = null;
        this.ref = null;
        this.file = null;
        this.protocol = null;
        this.port = -1;
        int n2 = string.length();
        int n3 = string.indexOf(58);
        if (n3 != -1) {
            this.protocol = string.substring(0, n3);
        }
        if (string.regionMatches(n3 + 1, "//", 0, 2)) {
            int n4;
            String string2 = null;
            int n5 = string.indexOf(47, n3 + 3);
            if (n5 != -1) {
                string2 = string.substring(n3 + 3, n5);
                this.file = n5 + 1 < n2 ? string.substring(n5 + 1) : "";
            } else {
                string2 = string.substring(n3 + 3);
            }
            int n6 = string2.indexOf(64);
            if (n6 != -1) {
                String string3 = string2.substring(0, n6);
                string2 = string2.substring(n6 + 1);
                int n7 = string3.indexOf(58);
                if (n7 != -1) {
                    this.username = string3.substring(0, n7);
                    this.password = string3.substring(n7 + 1);
                } else {
                    this.username = string3;
                }
            }
            if ((n4 = string2.indexOf(58)) != -1) {
                String string4 = string2.substring(n4 + 1);
                if (string4.length() > 0) {
                    try {
                        this.port = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = -1;
                    }
                }
                this.host = string2.substring(0, n4);
            } else {
                this.host = string2;
            }
        } else if (n3 + 1 < n2) {
            this.file = string.substring(n3 + 1);
        }
        if (this.file != null && (n = this.file.indexOf(35)) != -1) {
            this.ref = this.file.substring(n + 1);
            this.file = this.file.substring(0, n);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getProtocol(), this.getHost(), this.getPort(), this.getFile());
    }

    public boolean equals(Object object) {
        String string;
        if (!(object instanceof URLName)) {
            return false;
        }
        URLName uRLName = (URLName)object;
        if (uRLName.protocol == null || !uRLName.protocol.equals(this.protocol)) {
            return false;
        }
        InetAddress inetAddress = this.getHostAddress();
        InetAddress inetAddress2 = uRLName.getHostAddress();
        if (inetAddress != null && inetAddress2 != null ? !inetAddress.equals(inetAddress2) : (this.host != null && uRLName.host != null ? !this.host.equalsIgnoreCase(uRLName.host) : this.host != uRLName.host)) {
            return false;
        }
        if (!(this.username == uRLName.username || this.username != null && this.username.equals(uRLName.username))) {
            return false;
        }
        String string2 = this.file == null ? "" : this.file;
        String string3 = string = uRLName.file == null ? "" : uRLName.file;
        if (!string2.equals(string)) {
            return false;
        }
        return this.port == uRLName.port;
    }

    public int hashCode() {
        InetAddress inetAddress;
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.protocol != null) {
            this.hashCode += this.protocol.hashCode();
        }
        if ((inetAddress = this.getHostAddress()) != null) {
            this.hashCode += inetAddress.hashCode();
        } else if (this.host != null) {
            this.hashCode += this.host.toLowerCase().hashCode();
        }
        if (this.username != null) {
            this.hashCode += this.username.hashCode();
        }
        if (this.file != null) {
            this.hashCode += this.file.hashCode();
        }
        this.hashCode += this.port;
        return this.hashCode;
    }

    private synchronized InetAddress getHostAddress() {
        if (this.hostAddressKnown) {
            return this.hostAddress;
        }
        if (this.host == null) {
            return null;
        }
        try {
            this.hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostAddress = null;
        }
        this.hostAddressKnown = true;
        return this.hostAddress;
    }
}

