/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.iiop.CancelRequestMessage;
import com.sun.corba.se.internal.iiop.LocateReplyMessage;
import com.sun.corba.se.internal.iiop.LocateRequestMessage;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.iiop.ReplyMessage;
import com.sun.corba.se.internal.iiop.RequestMessage;
import com.sun.corba.se.internal.util.Utility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class Message {
    protected boolean debug = false;
    static final int defaultBufferSize = 1024;
    static final int GIOPBigEndian = 0;
    static final int GIOPLittleEndian = 1;
    static final int GIOPBigMagic = 1195986768;
    static final int GIOPLittleMagic = 1347373383;
    static final int GIOPMajor = 1;
    static final int GIOPMinor = 0;
    public static final int GIOPMessageHeaderLength = 12;
    public static final int GIOPRequest = 0;
    public static final int GIOPReply = 1;
    public static final int GIOPCancelRequest = 2;
    public static final int GIOPLocateRequest = 3;
    public static final int GIOPLocateReply = 4;
    public static final int GIOPCloseConnection = 5;
    public static final int GIOPMessageError = 6;
    public static final int GIOPLocateReplyUnknownObject = 0;
    public static final int GIOPLocateReplyObjectHere = 1;
    public static final int GIOPLocateReplyObjectForward = 2;
    private int magic;
    private byte major;
    private byte minor;
    private byte byteOrder;
    private byte type;
    private int size;
    protected int requestId;

    protected Message(boolean bl) {
        this.debug = bl;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public final int getType() {
        return this.type;
    }

    protected void setType(int n) {
        this.type = (byte)n;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean isLittleEndian() {
        return this.byteOrder == 1;
    }

    byte getByteOrder() {
        return this.byteOrder;
    }

    public void setSize(byte[] byArray, int n) {
        this.size = n;
        int n2 = n - 12;
        if (this.byteOrder == 0) {
            byArray[8] = (byte)(n2 >>> 24 & 0xFF);
            byArray[9] = (byte)(n2 >>> 16 & 0xFF);
            byArray[10] = (byte)(n2 >>> 8 & 0xFF);
            byArray[11] = (byte)(n2 >>> 0 & 0xFF);
        } else {
            byArray[8] = (byte)(n2 >>> 0 & 0xFF);
            byArray[9] = (byte)(n2 >>> 8 & 0xFF);
            byArray[10] = (byte)(n2 >>> 16 & 0xFF);
            byArray[11] = (byte)(n2 >>> 24 & 0xFF);
        }
    }

    public static Message createFromStream(ORB oRB, byte[] byArray, java.io.InputStream inputStream) throws SystemException, IOException {
        Message message;
        boolean bl = oRB.transportDebugFlag;
        Message.readFully(inputStream, byArray, 0, 12);
        if (bl) {
            Utility.dprint("Message", "createFromStream: type is " + byArray[7]);
        }
        switch (byArray[7]) {
            case 0: {
                if (bl) {
                    Utility.dprint("Message", "createFromStream: creating RequestMessage");
                }
                message = new RequestMessage(bl);
                break;
            }
            case 3: {
                message = new LocateRequestMessage(bl);
                break;
            }
            case 2: {
                message = new CancelRequestMessage(bl);
                break;
            }
            case 1: {
                message = new ReplyMessage(bl);
                break;
            }
            case 4: {
                message = new LocateReplyMessage(bl);
                break;
            }
            case 5: 
            case 6: {
                message = new Message(bl);
                break;
            }
            default: {
                if (bl) {
                    Utility.dprint("Message", "createFromStream: fell off end!");
                }
                throw new INTERNAL(1398079499, CompletionStatus.COMPLETED_NO);
            }
        }
        int n = byArray[0] << 24 & 0xFF000000;
        int n2 = byArray[1] << 16 & 0xFF0000;
        int n3 = byArray[2] << 8 & 0xFF00;
        int n4 = byArray[3] << 0 & 0xFF;
        message.magic = n | n2 | n3 | n4;
        message.major = byArray[4];
        message.minor = byArray[5];
        message.byteOrder = byArray[6];
        message.type = byArray[7];
        if (message.byteOrder == 0) {
            n = byArray[8] << 24 & 0xFF000000;
            n2 = byArray[9] << 16 & 0xFF0000;
            n3 = byArray[10] << 8 & 0xFF00;
            n4 = byArray[11] << 0 & 0xFF;
        } else {
            n = byArray[11] << 24 & 0xFF000000;
            n2 = byArray[10] << 16 & 0xFF0000;
            n3 = byArray[9] << 8 & 0xFF00;
            n4 = byArray[8] << 0 & 0xFF;
        }
        message.size = (n | n2 | n3 | n4) + 12;
        if (bl) {
            Utility.dprint("Message", "createFromStream: message construction complete.");
        }
        return message;
    }

    public static void readFully(java.io.InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            while (true) {
                try {
                    n4 = inputStream.read(byArray, n + n3, n2 - n3);
                }
                catch (IOException iOException) {
                    if (n5++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n4 < 0) {
                throw new IOException();
            }
            n3 += n4;
        }
    }

    public void write(OutputStream outputStream) throws SystemException {
        outputStream.write_long(1195986768);
        outputStream.write_octet((byte)1);
        outputStream.write_octet((byte)0);
        outputStream.write_boolean(false);
        outputStream.write_octet(this.type);
        outputStream.write_long(0);
    }

    public void read(InputStream inputStream) throws SystemException {
    }
}

