/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.ldap.Control;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private Thread worker;
    private boolean v3 = true;
    String host;
    int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private LdapClient parent = null;
    private int msgId = 0;
    private LdapRequest pendingRequests = null;
    static /* synthetic */ Class class$java$lang$String;

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            Object object;
            if (string2 != null) {
                object = Obj.helper.loadClass(string2);
                Method method = ((Class)object).getMethod("getDefault", new Class[0]);
                Object object2 = method.invoke(null, new Object[0]);
                Method method2 = ((Class)object).getMethod("createSocket", new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE});
                this.sock = (Socket)method2.invoke(object2, new Object[]{string, new Integer(n)});
            } else {
                this.sock = new Socket(string, n);
            }
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            object = this.sock.getOutputStream();
            ((OutputStream)object).write(new byte[0]);
            this.outStream = new BufferedOutputStream((OutputStream)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    synchronized int getMsgId() {
        return ++this.msgId;
    }

    void writeRequest(BerEncoder berEncoder, int n) throws IOException {
        LdapRequest ldapRequest = new LdapRequest();
        ldapRequest.ber = berEncoder;
        ldapRequest.msgId = n;
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        Connection connection = this;
        synchronized (connection) {
            this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
            this.outStream.flush();
        }
    }

    private BerDecoder readReply(int n) throws IOException, ServiceUnavailableException {
        LdapRequest ldapRequest = this.findRequest(n);
        if (ldapRequest == null) {
            if (this.sock == null) {
                throw new ServiceUnavailableException(this.host + ":" + this.port);
            }
            return null;
        }
        BerDecoder berDecoder = ldapRequest.getReplyBer();
        if (berDecoder == null && this.sock == null) {
            throw new ServiceUnavailableException(this.host + ":" + this.port);
        }
        return berDecoder;
    }

    BerDecoder readReply(int n, BerEncoder berEncoder) throws IOException, NamingException {
        BerDecoder berDecoder;
        while ((berDecoder = this.readReply(n)) == null) {
            try {
                BerEncoder berEncoder2 = berEncoder;
                synchronized (berEncoder2) {
                    berEncoder.wait(15000L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedNamingException("Interrupted during LDAP operation");
            }
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        LdapRequest ldapRequest2 = null;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                BerEncoder berEncoder = ldapRequest.ber;
                synchronized (berEncoder) {
                    ldapRequest.ber.notify();
                    ldapRequest.ber = null;
                }
                if (ldapRequest2 != null) {
                    ldapRequest2.next = ldapRequest.next;
                } else {
                    this.pendingRequests = ldapRequest.next;
                }
                ldapRequest.next = null;
            }
            ldapRequest2 = ldapRequest;
            ldapRequest = ldapRequest.next;
        }
    }

    synchronized void abandonRequest(int n, Control[] controlArray) {
        LdapRequest ldapRequest = this.findRequest(n);
        if (ldapRequest == null) {
            return;
        }
        BerEncoder berEncoder = new BerEncoder(256);
        int n2 = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n2);
            berEncoder.encodeInt(n, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
            this.outStream.flush();
            this.removeRequest(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        Object var3_3 = null;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest.msgId, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    private synchronized void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.cleanup(null);
    }

    /*
     * Unable to fully structure code
     */
    synchronized void cleanup(Control[] var1_1) {
        block16: {
            if (this.sock != null) {
                this.abandonOutstandingReqs(var1_1);
                if (this.bound) {
                    this.ldapUnbind(var1_1);
                }
                var3_2 = null;
                try {
                    this.outStream.flush();
                    this.sock.close();
                }
                catch (IOException var4_4) {
                    // empty catch block
                }
                var4_4 = this.pendingRequests;
                while (var4_4 != null) {
                    var5_6 = var4_4.ber;
                    synchronized (var5_6) {
                        var4_4.ber.notify();
                        var4_4.ber = null;
                    }
                    var4_4 = var4_4.next;
                }
                this.sock = null;
                {
                    break block16;
                }
                catch (Throwable var2_10) {
                    var3_3 = null;
                    try {
                        this.outStream.flush();
                        this.sock.close();
                    }
                    catch (IOException var4_5) {
                        // empty catch block
                    }
                    var4_5 = this.pendingRequests;
                    ** while (var4_5 != null)
                }
lbl-1000:
                // 1 sources

                {
                    var5_7 = var4_5.ber;
                    synchronized (var5_7) {
                        var4_5.ber.notify();
                        var4_5.ber = null;
                    }
                    var4_5 = var4_5.next;
                    continue;
                }
lbl51:
                // 1 sources

                this.sock = null;
                throw var2_10;
            }
        }
    }

    public void run() {
        int n = 0;
        try {
            try {
                while (true) {
                    int n2;
                    byte[] byArray = new byte[2048];
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = this.inStream.read(byArray, n3, 1);
                    if (n6 < 0) break;
                    if (byArray[n3++] != 48) continue;
                    n6 = this.inStream.read(byArray, n3, 1);
                    if (n6 < 0) break;
                    if (((n4 = byArray[n3++]) & 0x80) == 128) {
                        n5 = n4 & 0x7F;
                        n6 = 0;
                        n2 = 0;
                        while (n6 < n5) {
                            int n7 = this.inStream.read(byArray, n3 + n6, n5 - n6);
                            if (n7 < 0) {
                                n2 = 1;
                                break;
                            }
                            n6 += n7;
                        }
                        if (n2 != 0) break;
                        n4 = 0;
                        int n8 = 0;
                        while (n8 < n5) {
                            n4 = (n4 << 8) + (byArray[n3 + n8] & 0xFF);
                            ++n8;
                        }
                        n3 += n6;
                    }
                    if (n3 + (n2 = n4) > byArray.length) {
                        byte[] byArray2 = new byte[n3 + n2];
                        System.arraycopy(byArray, 0, byArray2, 0, n3);
                        byArray = byArray2;
                    }
                    while (n2 > 0) {
                        n6 = this.inStream.read(byArray, n3, n2);
                        if (n6 < 0) break;
                        n3 += n6;
                        n2 -= n6;
                    }
                    try {
                        BerDecoder berDecoder = new BerDecoder(byArray, 0, n3);
                        if (this.traceFile != null) {
                            Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n3);
                        }
                        berDecoder.parseSeq(null);
                        n = berDecoder.parseInt();
                        berDecoder.reset();
                        if (n == 0) {
                            this.parent.processUnsolicited(berDecoder);
                            continue;
                        }
                        LdapRequest ldapRequest = this.findRequest(n);
                        if (ldapRequest == null) continue;
                        ldapRequest.addReplyBer(berDecoder);
                        BerEncoder berEncoder = ldapRequest.ber;
                        synchronized (berEncoder) {
                            ldapRequest.ber.notify();
                            continue;
                        }
                    }
                    catch (Ber.DecodeException decodeException) {
                        continue;
                    }
                    break;
                }
                Object var13_17 = null;
                this.cleanup(null);
            }
            catch (IOException iOException) {
                Object var13_18 = null;
                this.cleanup(null);
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            this.cleanup(null);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

