/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public class DragGestureEvent
extends EventObject {
    private List events;
    private DragSource dragSource;
    private Component component;
    private Point origin;
    private int action;

    public DragGestureEvent(DragGestureRecognizer dragGestureRecognizer, int n, Point point, List list) {
        super(dragGestureRecognizer);
        this.component = dragGestureRecognizer.getComponent();
        if (this.component == null) {
            throw new IllegalArgumentException("null component");
        }
        this.dragSource = dragGestureRecognizer.getDragSource();
        if (this.dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("null or empty list of events");
        }
        if (n != 1 && n != 2 && n != 0x40000000) {
            throw new IllegalArgumentException("bad action");
        }
        if (point == null) {
            throw new IllegalArgumentException("null origin");
        }
        this.events = list;
        this.action = n;
        this.origin = point;
    }

    public DragGestureRecognizer getSourceAsDragGestureRecognizer() {
        return (DragGestureRecognizer)this.getSource();
    }

    public Component getComponent() {
        return this.component;
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public Point getDragOrigin() {
        return this.origin;
    }

    public Iterator iterator() {
        return this.events.iterator();
    }

    public Object[] toArray() {
        return this.events.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.events.toArray(objectArray);
    }

    public int getDragAction() {
        return this.action;
    }

    public InputEvent getTriggerEvent() {
        return this.getSourceAsDragGestureRecognizer().getTriggerEvent();
    }

    public void startDrag(Cursor cursor, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, cursor, transferable, dragSourceListener);
    }

    public void startDrag(Cursor cursor, Image image, Point point, Transferable transferable, DragSourceListener dragSourceListener) throws InvalidDnDOperationException {
        this.dragSource.startDrag(this, cursor, image, point, transferable, dragSourceListener);
    }
}

