/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.font.TextHitInfo;
import java.text.AttributedCharacterIterator;

public class InputMethodEvent
extends AWTEvent {
    public static final int INPUT_METHOD_FIRST = 1100;
    public static final int INPUT_METHOD_TEXT_CHANGED = 1100;
    public static final int CARET_POSITION_CHANGED = 1101;
    public static final int INPUT_METHOD_LAST = 1101;
    private transient AttributedCharacterIterator text;
    private transient int committedCharacterCount;
    private transient TextHitInfo caret;
    private transient TextHitInfo visiblePosition;

    public InputMethodEvent(Component component, int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        super(component, n);
        if (n < 1100 || n > 1101) {
            throw new IllegalArgumentException("id outside of valid range");
        }
        if (n == 1101 && attributedCharacterIterator != null) {
            throw new IllegalArgumentException("text must be null for CARET_POSITION_CHANGED");
        }
        this.text = attributedCharacterIterator;
        int n3 = 0;
        if (attributedCharacterIterator != null) {
            n3 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("committedCharacterCount outside of valid range");
        }
        this.committedCharacterCount = n2;
        this.caret = textHitInfo;
        this.visiblePosition = textHitInfo2;
    }

    public InputMethodEvent(Component component, int n, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n, null, 0, textHitInfo, textHitInfo2);
    }

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public int getCommittedCharacterCount() {
        return this.committedCharacterCount;
    }

    public TextHitInfo getCaret() {
        return this.caret;
    }

    public TextHitInfo getVisiblePosition() {
        return this.visiblePosition;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public String paramString() {
        Object object;
        String string;
        String string2;
        switch (this.id) {
            case 1100: {
                string2 = "INPUT_METHOD_TEXT_CHANGED";
                break;
            }
            case 1101: {
                string2 = "CARET_POSITION_CHANGED";
                break;
            }
            default: {
                string2 = "unknown type";
            }
        }
        if (this.text == null) {
            string = "no text";
        } else {
            object = new StringBuffer("\"");
            int n = this.committedCharacterCount;
            char c = this.text.first();
            while (n-- > 0) {
                ((StringBuffer)object).append(c);
                c = this.text.next();
            }
            ((StringBuffer)object).append("\" + \"");
            while (c != '\uffff') {
                ((StringBuffer)object).append(c);
                c = this.text.next();
            }
            ((StringBuffer)object).append("\"");
            string = ((StringBuffer)object).toString();
        }
        object = this.committedCharacterCount + " characters committed";
        String string3 = this.caret == null ? "no caret" : "caret: " + this.caret.toString();
        String string4 = this.visiblePosition == null ? "no visible position" : "visible position: " + this.visiblePosition.toString();
        return string2 + ", " + string + ", " + (String)object + ", " + string3 + ", " + string4;
    }
}

