/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ComponentColorModel
extends ColorModel {
    public ComponentColorModel(ColorSpace colorSpace, int[] nArray, boolean bl, boolean bl2, int n, int n2) {
        super(DataBuffer.getDataTypeSize(n2) * nArray.length, nArray, colorSpace, bl, bl2, n, n2);
    }

    public int getRed(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[0] * 255.0f);
    }

    public int getGreen(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[1] * 255.0f);
    }

    public int getBlue(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        float[] fArray = new float[]{(float)n / (float)((1 << this.nBits[0]) - 1)};
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[2] * 255.0f);
    }

    public int getAlpha(int n) {
        if (!this.supportsAlpha) {
            return 255;
        }
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        return n / ((1 << this.nBits[0]) - 1) * 255;
    }

    public int getRGB(int n) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        return this.getAlpha(n) << 24 | this.getRed(n) << 16 | this.getGreen(n) << 8 | this.getBlue(n) << 0;
    }

    public int getRed(Object object) {
        int[] nArray;
        if (this.is_sRGB) {
            boolean bl = this.supportsAlpha && this.isAlphaPremultiplied;
            int n = 0;
            int n2 = 0;
            switch (this.transferType) {
                case 0: {
                    byte[] byArray = (byte[])object;
                    n2 = byArray[0] & 0xFF;
                    if (!bl) break;
                    n = byArray[this.numColorComponents] & 0xFF;
                    break;
                }
                case 1: {
                    short[] sArray = (short[])object;
                    n2 = sArray[0] & 0xFFFF;
                    if (!bl) break;
                    n = sArray[this.numColorComponents] & 0xFFFF;
                    break;
                }
                case 3: {
                    int[] nArray2 = (int[])object;
                    n2 = nArray2[0];
                    if (!bl) break;
                    n = nArray2[this.numColorComponents];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
            if (this.nBits[0] != 8) {
                int n3 = this.nBits[0] - 8;
                int n4 = n2 = n3 > 0 ? n2 >> n3 : n2 << -n3;
            }
            if (bl) {
                return n != 0 ? (int)((float)n2 * ((float)(1 << this.nBits[this.numColorComponents]) - 1.0f) / (float)n) : 0;
            }
            return n2;
        }
        if (object instanceof int[]) {
            nArray = (int[])object;
        } else {
            nArray = DataBuffer.toIntArray(object);
            if (nArray == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[0] * 255.0f);
    }

    public int getGreen(Object object) {
        int[] nArray;
        if (this.is_sRGB) {
            boolean bl = this.supportsAlpha && this.isAlphaPremultiplied;
            int n = 0;
            int n2 = 0;
            switch (this.transferType) {
                case 0: {
                    byte[] byArray = (byte[])object;
                    n2 = byArray[1] & 0xFF;
                    if (!bl) break;
                    n = byArray[this.numColorComponents] & 0xFF;
                    break;
                }
                case 1: {
                    short[] sArray = (short[])object;
                    n2 = sArray[1] & 0xFFFF;
                    if (!bl) break;
                    n = sArray[this.numColorComponents] & 0xFFFF;
                    break;
                }
                case 3: {
                    int[] nArray2 = (int[])object;
                    n2 = nArray2[1];
                    if (!bl) break;
                    n = nArray2[this.numColorComponents];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
            if (this.nBits[1] != 8) {
                int n3 = this.nBits[1] - 8;
                int n4 = n2 = n3 > 0 ? n2 >> n3 : n2 << -n3;
            }
            if (bl) {
                return n != 0 ? (int)((float)n2 * ((float)(1 << this.nBits[this.numColorComponents]) - 1.0f) / (float)n) : 0;
            }
            return n2;
        }
        if (object instanceof int[]) {
            nArray = (int[])object;
        } else {
            nArray = DataBuffer.toIntArray(object);
            if (nArray == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[1] * 255.0f);
    }

    public int getBlue(Object object) {
        int[] nArray;
        if (this.is_sRGB) {
            boolean bl = this.supportsAlpha && this.isAlphaPremultiplied;
            int n = 0;
            int n2 = 0;
            switch (this.transferType) {
                case 0: {
                    byte[] byArray = (byte[])object;
                    n2 = byArray[2] & 0xFF;
                    if (!bl) break;
                    n = byArray[this.numColorComponents] & 0xFF;
                    break;
                }
                case 1: {
                    short[] sArray = (short[])object;
                    n2 = sArray[2] & 0xFFFF;
                    if (!bl) break;
                    n = sArray[this.numColorComponents] & 0xFFFF;
                    break;
                }
                case 3: {
                    int[] nArray2 = (int[])object;
                    n2 = nArray2[2];
                    if (!bl) break;
                    n = nArray2[this.numColorComponents];
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
            if (this.nBits[2] != 8) {
                int n3 = this.nBits[2] - 8;
                return n3 > 0 ? n2 >> n3 : n2 << -n3;
            }
            if (bl) {
                return n != 0 ? (int)((float)n2 * ((float)(1 << this.nBits[this.numColorComponents]) - 1.0f) / (float)n) : 0;
            }
            return n2;
        }
        if (object instanceof int[]) {
            nArray = (int[])object;
        } else {
            nArray = DataBuffer.toIntArray(object);
            if (nArray == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        float[] fArray2 = this.colorSpace.toRGB(fArray);
        return (int)(fArray2[2] * 255.0f);
    }

    public int getAlpha(Object object) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n = 0;
        int n2 = this.numColorComponents;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n = byArray[n2] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n = sArray[n2] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n = nArray[n2];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (this.nBits[n2] == 8) {
            return n;
        }
        int n3 = this.nBits[n2] - 8;
        return n3 > 0 ? n >> n3 : n << -n3;
    }

    private float getNormAlpha(int[] nArray) {
        return (float)nArray[this.numColorComponents] / ((float)(1 << this.nBits[this.numColorComponents]) - 1.0f);
    }

    public int getRGB(Object object) {
        if (this.colorSpaceType == 6) {
            int n = this.getRed(object);
            return this.getAlpha(object) << 24 | n << 16 | n << 8 | n;
        }
        if (!this.is_sRGB) {
            int[] nArray;
            if (object instanceof int[]) {
                nArray = (int[])object;
            } else {
                nArray = DataBuffer.toIntArray(object);
                if (nArray == null) {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
            float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
            float[] fArray2 = this.colorSpace.toRGB(fArray);
            return this.getAlpha(object) << 24 | (int)(fArray2[0] * 255.0f) << 16 | (int)(fArray2[1] * 255.0f) << 8 | (int)(fArray2[2] * 255.0f) << 0;
        }
        return this.getAlpha(object) << 24 | this.getRed(object) << 16 | this.getGreen(object) << 8 | this.getBlue(object);
    }

    public Object getDataElements(int n, Object object) {
        int n2;
        int n3;
        int[] nArray = null;
        nArray = this.transferType == 3 && object != null ? (int[])object : new int[this.numComponents];
        if (!this.is_sRGB) {
            float[] fArray = new float[]{(float)(n >> 16 & 0xFF) / 255.0f, (float)(n >> 8 & 0xFF) / 255.0f, (float)(n >> 0 & 0xFF) / 255.0f};
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.supportsAlpha) {
                nArray[this.numColorComponents] = this.nBits[this.numColorComponents] == 8 ? n >> 24 & 0xFF : (int)((float)(n >> 24 & 0xFF) / 255.0f * (float)((1 << this.nBits[this.numColorComponents]) - 1));
                if (this.isAlphaPremultiplied) {
                    float f = (float)(n >> 24 & 0xFF) / 255.0f;
                    n3 = 0;
                    while (n3 < this.numColorComponents) {
                        int n4 = n3++;
                        fArray[n4] = fArray[n4] * f;
                    }
                }
            }
            n2 = 0;
            while (n2 < this.numColorComponents) {
                nArray[n2] = (int)(fArray[n2] * (float)((1 << this.nBits[n2]) - 1));
                ++n2;
            }
        } else {
            int n5 = n >> 24 & 0xFF;
            n2 = n >> 16 & 0xFF;
            n3 = n >> 8 & 0xFF;
            int n6 = n & 0xFF;
            if (this.isAlphaPremultiplied) {
                float f = (float)n5 / 255.0f;
                nArray[0] = this.nBits[0] == 8 ? (int)((float)n2 * f) : (int)((float)n2 * f / 255.0f * (float)((1 << this.nBits[0]) - 1));
                nArray[1] = this.nBits[1] == 8 ? (int)((float)n3 * f) : (int)((float)n3 * f / 255.0f * (float)((1 << this.nBits[1]) - 1));
                nArray[2] = this.nBits[2] == 8 ? (int)((float)n6 * f) : (int)((float)n6 * f / 255.0f * (float)((1 << this.nBits[2]) - 1));
                if (this.supportsAlpha) {
                    nArray[3] = this.nBits[3] == 8 ? n5 : (int)(f * (float)((1 << this.nBits[3]) - 1));
                }
            } else {
                nArray[0] = this.nBits[0] == 8 ? n2 : (int)((float)n2 / 255.0f * (float)((1 << this.nBits[0]) - 1));
                nArray[1] = this.nBits[1] == 8 ? n3 : (int)((float)n3 / 255.0f * (float)((1 << this.nBits[1]) - 1));
                nArray[2] = this.nBits[2] == 8 ? n6 : (int)((float)n6 / 255.0f * (float)((1 << this.nBits[2]) - 1));
                if (this.supportsAlpha) {
                    nArray[3] = this.nBits[3] == 8 ? n5 : (int)((float)n5 / 255.0f * (float)((1 << this.nBits[3]) - 1));
                }
            }
        }
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[this.numComponents] : (byte[])object;
                n2 = 0;
                while (n2 < this.numComponents) {
                    byArray[n2] = (byte)(0xFF & nArray[n2]);
                    ++n2;
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[this.numComponents] : (short[])object;
                n2 = 0;
                while (n2 < this.numComponents) {
                    sArray[n2] = (short)(nArray[n2] & 0xFFFF);
                    ++n2;
                }
                return sArray;
            }
            case 3: {
                return nArray;
            }
        }
        throw new IllegalArgumentException("This method has not been implemented for transferType " + this.transferType);
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        if (this.numComponents > 1) {
            throw new IllegalArgumentException("More than one component per pixel");
        }
        if (nArray == null) {
            nArray = new int[n2 + 1];
        }
        nArray[n2 + 0] = n & (1 << this.nBits[0]) - 1;
        return nArray;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        int[] nArray2;
        if (object instanceof int[]) {
            nArray2 = (int[])object;
        } else {
            nArray2 = DataBuffer.toIntArray(object);
            if (nArray2 == null) {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        if (nArray2.length < this.numComponents) {
            throw new IllegalArgumentException("Length of pixel array < number of components in model");
        }
        if (nArray == null) {
            nArray = new int[n + this.numComponents];
        } else if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Length of components array < number of components in model");
        }
        System.arraycopy(nArray2, 0, nArray, n, this.numComponents);
        return nArray;
    }

    public int getDataElement(int[] nArray, int n) {
        if (this.numComponents == 1) {
            return nArray[n + 0];
        }
        throw new IllegalArgumentException("This model returns " + this.numComponents + " elements in the pixel array.");
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        switch (this.transferType) {
            case 3: {
                int[] nArray2 = object == null ? new int[nArray.length] : (int[])object;
                System.arraycopy(nArray, n, nArray2, 0, this.numComponents);
                return nArray2;
            }
            case 0: {
                byte[] byArray = object == null ? new byte[nArray.length] : (byte[])object;
                int n2 = 0;
                while (n2 < this.numComponents) {
                    byArray[n2] = (byte)(nArray[n + n2] & 0xFF);
                    ++n2;
                }
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[nArray.length] : (short[])object;
                int n3 = 0;
                while (n3 < this.numComponents) {
                    sArray[n3] = (short)(nArray[n + n3] & 0xFFFF);
                    ++n3;
                }
                return sArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        block36: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            block35: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied == bl) {
                    return this;
                }
                n5 = writableRaster.getWidth();
                n4 = writableRaster.getHeight();
                n3 = writableRaster.getNumBands() - 1;
                n2 = writableRaster.getMinX();
                n = writableRaster.getMinY();
                if (!bl) break block35;
                switch (this.transferType) {
                    case 0: {
                        byte[] byArray = null;
                        int n6 = 0;
                        while (n6 < n4) {
                            int n7 = n2;
                            int n8 = 0;
                            while (n8 < n5) {
                                int n9 = (byArray = (byte[])writableRaster.getDataElements(n7, n, byArray))[n3] & 0xFF;
                                if (n9 != 0) {
                                    int n10 = 0;
                                    while (n10 < n3) {
                                        byArray[n10] = (byte)((byArray[n10] & 0xFF) * n9);
                                        ++n10;
                                    }
                                    writableRaster.setDataElements(n7, n, byArray);
                                }
                                ++n8;
                                ++n7;
                            }
                            ++n6;
                            ++n;
                        }
                        break block36;
                    }
                    case 1: {
                        short[] sArray = null;
                        int n11 = 0;
                        while (n11 < n4) {
                            int n12 = n2;
                            int n13 = 0;
                            while (n13 < n5) {
                                int n14 = (sArray = (short[])writableRaster.getDataElements(n12, n, sArray))[n3] & 0xFFFF;
                                if (n14 != 0) {
                                    int n15 = 0;
                                    while (n15 < n3) {
                                        sArray[n15] = (short)((sArray[n15] & 0xFFFF) * n14);
                                        ++n15;
                                    }
                                    writableRaster.setDataElements(n12, n, sArray);
                                }
                                ++n13;
                                ++n12;
                            }
                            ++n11;
                            ++n;
                        }
                        break block36;
                    }
                    case 3: {
                        int[] nArray = null;
                        int n16 = 0;
                        while (n16 < n4) {
                            int n17 = n2;
                            int n18 = 0;
                            while (n18 < n5) {
                                int n19 = (nArray = (int[])writableRaster.getDataElements(n17, n, nArray))[n3];
                                if (n19 != 0) {
                                    int n20 = 0;
                                    while (n20 < n3) {
                                        int n21 = n20++;
                                        nArray[n21] = nArray[n21] * n19;
                                    }
                                    writableRaster.setDataElements(n17, n, nArray);
                                }
                                ++n18;
                                ++n17;
                            }
                            ++n16;
                            ++n;
                        }
                        break block36;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    int n22 = 0;
                    while (n22 < n4) {
                        int n23 = n2;
                        int n24 = 0;
                        while (n24 < n5) {
                            byte[] byArray = null;
                            byArray = (byte[])writableRaster.getDataElements(n23, n, byArray);
                            int n25 = byArray[n3] & 0xFF;
                            int n26 = 0;
                            while (n26 < n3) {
                                if (n25 != 0) {
                                    byArray[n26] = (byte)((byArray[n26] & 0xFF) / n25);
                                }
                                ++n26;
                            }
                            writableRaster.setDataElements(n23, n, byArray);
                            ++n24;
                            ++n23;
                        }
                        ++n22;
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n27 = 0;
                    while (n27 < n4) {
                        int n28 = n2;
                        int n29 = 0;
                        while (n29 < n5) {
                            short[] sArray = null;
                            sArray = (short[])writableRaster.getDataElements(n28, n, sArray);
                            int n30 = sArray[n3] & 0xFFFF;
                            int n31 = 0;
                            while (n31 < n3) {
                                if (n30 != 0) {
                                    sArray[n31] = (short)((sArray[n31] & 0xFFFF) / n30);
                                }
                                ++n31;
                            }
                            writableRaster.setDataElements(n28, n, sArray);
                            ++n29;
                            ++n28;
                        }
                        ++n27;
                        ++n;
                    }
                    break;
                }
                case 3: {
                    int n32 = 0;
                    while (n32 < n4) {
                        int n33 = n2;
                        int n34 = 0;
                        while (n34 < n5) {
                            int[] nArray = null;
                            nArray = (int[])writableRaster.getDataElements(n33, n, nArray);
                            int n35 = nArray[n3];
                            int n36 = 0;
                            while (n36 < n3) {
                                if (n35 != 0) {
                                    int n37 = n36;
                                    nArray[n37] = nArray[n37] / n35;
                                }
                                ++n36;
                            }
                            writableRaster.setDataElements(n33, n, nArray);
                            ++n34;
                            ++n33;
                        }
                        ++n32;
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        return new ComponentColorModel(this.colorSpace, this.nBits, this.supportsAlpha, bl, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        boolean bl = true;
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            int n = 0;
            while (n < this.nBits.length) {
                if (sampleModel.getSampleSize(n) < this.nBits[n]) {
                    bl = false;
                }
                ++n;
            }
        } else {
            return false;
        }
        return raster.getTransferType() == this.transferType && bl;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        int n3 = n * n2 * this.numComponents;
        WritableRaster writableRaster = null;
        writableRaster = Raster.createInterleavedRaster(this.transferType, n, n2, this.numComponents, null);
        return writableRaster;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n3] = n3;
            ++n3;
        }
        return new PixelInterleavedSampleModel(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getTransferType() == this.transferType;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        if (!this.hasAlpha()) {
            return null;
        }
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int[] nArray = new int[]{writableRaster.getNumBands() - 1};
        return writableRaster.createWritableChild(n, n2, writableRaster.getWidth(), writableRaster.getHeight(), n, n2, nArray);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object.getClass() == this.getClass();
    }
}

